/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph;

import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.LocationWithPathAndProperty;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.BasicSingleValueProperty;

@Immutable
final class LocationWithPathAndUuid
extends LocationWithPathAndProperty {
    private static final long serialVersionUID = 1L;
    private final UUID uuid;

    LocationWithPathAndUuid(Path path, UUID uuid) {
        super(path, new BasicSingleValueProperty(DnaLexicon.UUID, uuid));
        assert (uuid != null);
        this.uuid = uuid;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public Location with(Property idProperty) {
        if (idProperty == null || idProperty.isEmpty()) {
            return this;
        }
        if (DnaLexicon.UUID.equals(idProperty.getName())) {
            if (idProperty.isSingle() && this.uuid.equals(idProperty.getFirstValue())) {
                return this;
            }
            return Location.create(this.getPath(), idProperty);
        }
        return Location.create(this.getPath(), this.getIdProperties().get(0), idProperty);
    }

    public Location with(Path path) {
        if (path == null) {
            return Location.create(this.uuid);
        }
        if (this.getPath().equals(path)) {
            return this;
        }
        return Location.create(path, this.uuid);
    }

    public Location with(UUID uuid) {
        if (uuid == null) {
            return Location.create(this.getPath());
        }
        if (uuid.equals(this.uuid)) {
            return this;
        }
        return Location.create(this.getPath(), uuid);
    }
}

