/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.List;
import java.util.Map;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.federation.FederatedRequest;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.DateTime;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.CacheableRequest;
import org.jboss.dna.graph.request.CloneBranchRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.FullTextSearchRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.LockBranchRequest;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadBranchRequest;
import org.jboss.dna.graph.request.ReadNextBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.ReadPropertyRequest;
import org.jboss.dna.graph.request.RemovePropertyRequest;
import org.jboss.dna.graph.request.RenameNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.SetPropertyRequest;
import org.jboss.dna.graph.request.UnlockBranchRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.UpdateValuesRequest;
import org.jboss.dna.graph.request.VerifyNodeExistsRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

class JoinMirrorRequestProcessor
extends RequestProcessor {
    private FederatedRequest federatedRequest;

    JoinMirrorRequestProcessor(String sourceName, ExecutionContext context, Observer observer, DateTime now, CachePolicy defaultCachePolicy) {
        super(sourceName, context, observer, now, defaultCachePolicy);
    }

    void setFederatedRequest(FederatedRequest federatedRequest) {
        this.federatedRequest = federatedRequest;
    }

    protected boolean checkErrorOrCancel(Request request, Request sourceRequest) {
        if (sourceRequest.hasError()) {
            request.setError(sourceRequest.getError());
            return true;
        }
        if (sourceRequest.isCancelled()) {
            request.cancel();
            return true;
        }
        return false;
    }

    public void process(ReadNodeRequest request) {
        ReadNodeRequest source = (ReadNodeRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        for (Location childInSource : source.getChildren()) {
            request.addChild(childInSource);
        }
        for (Property propertyInSource : source.getProperties()) {
            request.addProperties(propertyInSource);
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(ReadAllChildrenRequest request) {
        ReadAllChildrenRequest source = (ReadAllChildrenRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        for (Location childInSource : source.getChildren()) {
            request.addChild(childInSource);
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(ReadAllPropertiesRequest request) {
        ReadAllPropertiesRequest source = (ReadAllPropertiesRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        for (Property propertyInSource : source.getProperties()) {
            request.addProperties(propertyInSource);
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(ReadBlockOfChildrenRequest request) {
        ReadBlockOfChildrenRequest source = (ReadBlockOfChildrenRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        for (Location childInSource : source.getChildren()) {
            request.addChild(childInSource);
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        ReadNextBlockOfChildrenRequest source = (ReadNextBlockOfChildrenRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfStartingAfterNode(source.getActualLocationOfStartingAfterNode());
        for (Location childInSource : source.getChildren()) {
            request.addChild(childInSource);
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(ReadPropertyRequest request) {
        ReadPropertyRequest source = (ReadPropertyRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        request.setProperty(source.getProperty());
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(SetPropertyRequest request) {
        SetPropertyRequest source = (SetPropertyRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        request.setNewProperty(source.isNewProperty());
    }

    public void process(VerifyNodeExistsRequest request) {
        VerifyNodeExistsRequest source = (VerifyNodeExistsRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(RemovePropertyRequest request) {
        RemovePropertyRequest source = (RemovePropertyRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
    }

    public void process(RenameNodeRequest request) {
        RenameNodeRequest source = (RenameNodeRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocations(source.getActualLocationBefore(), source.getActualLocationAfter());
    }

    public void process(ReadBranchRequest request) {
        CacheableRequest source = (CacheableRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        if (source instanceof ReadBranchRequest) {
            ReadBranchRequest readSource = (ReadBranchRequest)source;
            request.setActualLocationOfNode(readSource.getActualLocationOfNode());
            for (Location node : readSource) {
                Map<Name, Property> props;
                List<Location> children = readSource.getChildren(node);
                if (children != null) {
                    request.setChildren(node, children);
                }
                if ((props = readSource.getPropertiesFor(node)) == null) continue;
                request.setProperties(node, props.values());
            }
        } else if (source instanceof ReadNodeRequest) {
            ReadNodeRequest readSource = (ReadNodeRequest)source;
            request.setActualLocationOfNode(readSource.getActualLocationOfNode());
            Location parent = readSource.getActualLocationOfNode();
            request.setChildren(parent, readSource.getChildren());
            request.setProperties(parent, readSource.getPropertiesByName().values());
        }
        request.setCachePolicy(this.getDefaultCachePolicy());
        this.setCacheableInfo(request, source.getCachePolicy());
    }

    public void process(CreateNodeRequest request) {
        CreateNodeRequest source = (CreateNodeRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
    }

    public void process(UpdatePropertiesRequest request) {
        UpdatePropertiesRequest source = (UpdatePropertiesRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
        request.setNewProperties(source.getNewPropertyNames());
    }

    public void process(UpdateValuesRequest request) {
        UpdateValuesRequest source = (UpdateValuesRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocation(source.getActualLocationOfNode(), request.getActualAddedValues(), request.getActualRemovedValues());
    }

    public void process(CopyBranchRequest request) {
        CopyBranchRequest source = (CopyBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocations(source.getActualLocationBefore(), source.getActualLocationAfter());
    }

    public void process(CloneBranchRequest request) {
        CloneBranchRequest source = (CloneBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocations(source.getActualLocationBefore(), source.getActualLocationAfter());
        request.setRemovedNodes(source.getRemovedNodes());
    }

    public void process(DeleteBranchRequest request) {
        DeleteBranchRequest source = (DeleteBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
    }

    public void process(DeleteChildrenRequest request) {
        DeleteChildrenRequest source = (DeleteChildrenRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocationOfNode(source.getActualLocationOfNode());
    }

    public void process(MoveBranchRequest request) {
        MoveBranchRequest source = (MoveBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocations(source.getActualLocationBefore(), source.getActualLocationAfter());
    }

    public void process(LockBranchRequest request) {
        LockBranchRequest source = (LockBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocation(source.getActualLocation());
    }

    public void process(UnlockBranchRequest request) {
        UnlockBranchRequest source = (UnlockBranchRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        request.setActualLocation(source.getActualLocation());
    }

    public void process(VerifyWorkspaceRequest request) {
        VerifyNodeExistsRequest source = (VerifyNodeExistsRequest)this.federatedRequest.getFirstProjectedRequest().getRequest();
        if (this.checkErrorOrCancel(request, source)) {
            return;
        }
        assert (source.getActualLocationOfNode().getPath().isRoot());
        request.setActualRootLocation(source.getActualLocationOfNode());
    }

    public void process(GetWorkspacesRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(CreateWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(CloneWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(DestroyWorkspaceRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(AccessQueryRequest request) {
        throw new UnsupportedOperationException();
    }

    public void process(FullTextSearchRequest request) {
        throw new UnsupportedOperationException();
    }
}

