/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.federation;

import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.federation.ProjectedNode;
import org.jboss.dna.graph.connector.federation.Projection;
import org.jboss.dna.graph.connector.federation.Projector;
import org.jboss.dna.graph.connector.federation.ProxyNode;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class MirrorProjector
implements Projector {
    private final Projection projection;

    static MirrorProjector with(ExecutionContext context, List<Projection> projections) {
        assert (projections != null);
        assert (context != null);
        if (projections.size() != 1) {
            return null;
        }
        Projection projection = projections.get(0);
        assert (projection != null);
        if (projection.getRules().size() != 1) {
            return null;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        List<Path> topLevelPaths = projection.getRules().get(0).getTopLevelPathsInRepository(pathFactory);
        if (topLevelPaths.size() != 1) {
            return null;
        }
        if (!topLevelPaths.get(0).isRoot()) {
            return null;
        }
        return new MirrorProjector(projection);
    }

    private MirrorProjector(Projection projection) {
        this.projection = projection;
    }

    @Override
    public ProjectedNode project(ExecutionContext context, Location location, boolean requiresUpdate) {
        if (requiresUpdate && this.projection.isReadOnly()) {
            return null;
        }
        return new ProxyNode(this.projection, location, location);
    }
}

