/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.Set;
import java.util.UUID;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepository;
import org.jboss.dna.graph.connector.map.DefaultMapNode;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryNode
extends DefaultMapNode {
    private final ChangeListener listener;

    public InMemoryNode(ChangeListener listener, UUID uuid) {
        super(uuid);
        this.listener = listener;
        assert (this.listener != null);
    }

    protected void restoreFrom(InMemoryRepository.InMemoryNodeState state) {
        super.setParent(state.getParent());
        super.setName(state.getName());
        super.setProperties(state.getProperties());
        super.clearChildren();
        for (MapNode originalChild : state.getChildren()) {
            originalChild.setParent(this);
            super.addChild(originalChild);
        }
        Set<Name> uniqueChildNames = super.getUniqueChildNames();
        uniqueChildNames.clear();
        uniqueChildNames.addAll(state.getUniqueChildNames());
    }

    @Override
    public void addChild(int index, MapNode child) {
        this.listener.prepareForChange(this);
        super.addChild(index, child);
    }

    @Override
    public void addChild(MapNode child) {
        this.listener.prepareForChange(this);
        super.addChild(child);
    }

    @Override
    public void clearChildren() {
        this.listener.prepareForChange(this);
        super.clearChildren();
    }

    @Override
    public boolean removeChild(MapNode child) {
        this.listener.prepareForChange(this);
        return super.removeChild(child);
    }

    @Override
    public MapNode removeProperty(Name propertyName) {
        this.listener.prepareForChange(this);
        return super.removeProperty(propertyName);
    }

    @Override
    public void setName(Path.Segment name) {
        this.listener.prepareForChange(this);
        super.setName(name);
    }

    @Override
    public void setParent(MapNode parent) {
        this.listener.prepareForChange(this);
        super.setParent(parent);
    }

    @Override
    public MapNode setProperties(Iterable<Property> properties) {
        this.listener.prepareForChange(this);
        return super.setProperties(properties);
    }

    @Override
    public MapNode setProperty(ExecutionContext context, String name, Object ... values) {
        this.listener.prepareForChange(this);
        return super.setProperty(context, name, values);
    }

    @Override
    public MapNode setProperty(Property property) {
        this.listener.prepareForChange(this);
        return super.setProperty(property);
    }

    public static interface ChangeListener {
        public void prepareForChange(InMemoryNode var1);
    }
}

