/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.inmemory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.LockFailedException;
import org.jboss.dna.graph.connector.inmemory.InMemoryNode;
import org.jboss.dna.graph.connector.map.AbstractMapWorkspace;
import org.jboss.dna.graph.connector.map.LockBasedTransaction;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.connector.map.MapRepository;
import org.jboss.dna.graph.connector.map.MapRepositoryTransaction;
import org.jboss.dna.graph.connector.map.MapWorkspace;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.LockBranchRequest;

@NotThreadSafe
public class InMemoryRepository
extends MapRepository {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();

    public InMemoryRepository(String sourceName, UUID rootNodeUuid) {
        super(sourceName, rootNodeUuid, null);
        this.initialize();
    }

    public InMemoryRepository(String sourceName, UUID rootNodeUuid, String defaultWorkspaceName) {
        super(sourceName, rootNodeUuid, defaultWorkspaceName);
        this.initialize();
    }

    @GuardedBy(value="getLock()")
    protected MapWorkspace createWorkspace(ExecutionContext context, String name) {
        return new Workspace(this, name);
    }

    public MapRepositoryTransaction startTransaction(boolean readonly) {
        return new LockBasedTransaction(readonly ? this.lock.readLock() : this.lock.writeLock()){

            public void commit() {
                InMemoryRepository.this.releaseBackups();
                super.commit();
            }

            public void rollback() {
                InMemoryRepository.this.restoreBackups();
                super.rollback();
            }
        };
    }

    protected ReadWriteLock getLock() {
        return this.lock;
    }

    @GuardedBy(value="lock")
    protected void restoreBackups() {
        for (String name : this.getWorkspaceNames()) {
            Workspace workspace = (Workspace)this.getWorkspace(name);
            workspace.restoreBackups();
        }
    }

    @GuardedBy(value="lock")
    protected void releaseBackups() {
        for (String name : this.getWorkspaceNames()) {
            Workspace workspace = (Workspace)this.getWorkspace(name);
            workspace.releaseBackups();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static final class InMemoryNodeState {
        private Path.Segment name;
        private final Set<Property> properties;
        private final List<MapNode> children;
        private final Set<Name> uniqueChildNames;
        private final InMemoryNode node;
        private final MapNode parent;

        protected InMemoryNodeState(InMemoryNode node) {
            this.parent = node.getParent();
            this.node = node;
            this.name = node.getName();
            this.properties = new HashSet<Property>(node.getProperties().values());
            this.children = new ArrayList<MapNode>(node.getChildren());
            this.uniqueChildNames = new HashSet<Name>(node.getUniqueChildNames());
        }

        public Path.Segment getName() {
            return this.name;
        }

        public List<MapNode> getChildren() {
            return this.children;
        }

        public Set<Property> getProperties() {
            return this.properties;
        }

        public Set<Name> getUniqueChildNames() {
            return this.uniqueChildNames;
        }

        public InMemoryNode getOriginalNode() {
            return this.node;
        }

        public MapNode getParent() {
            return this.parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Workspace
    extends AbstractMapWorkspace
    implements InMemoryNode.ChangeListener {
        private final Map<UUID, MapNode> nodesByUuid;
        private Map<UUID, InMemoryNodeState> stateBeforeChanges;

        public Workspace(MapRepository repository, String name) {
            super(repository, name);
            this.nodesByUuid = new HashMap<UUID, MapNode>();
            this.initialize();
        }

        @Override
        protected MapNode createMapNode(UUID uuid) {
            assert (uuid != null);
            return new InMemoryNode(this, uuid);
        }

        @Override
        protected void addNodeToMap(MapNode node) {
            assert (node != null);
            assert (this.nodesByUuid != null);
            this.nodesByUuid.put(node.getUuid(), node);
        }

        @Override
        protected MapNode removeNodeFromMap(UUID nodeUuid) {
            assert (nodeUuid != null);
            return this.nodesByUuid.remove(nodeUuid);
        }

        @Override
        protected void removeAllNodesFromMap() {
            this.nodesByUuid.clear();
        }

        @Override
        public MapNode getNode(UUID nodeUuid) {
            assert (nodeUuid != null);
            return this.nodesByUuid.get(nodeUuid);
        }

        @Override
        protected MapNode copyNode(ExecutionContext context, MapNode original, MapWorkspace newWorkspace, MapNode newParent, Name desiredName, boolean recursive, Map<UUID, UUID> oldToNewUuids) {
            return super.copyNode(context, original, newWorkspace, newParent, desiredName, recursive, oldToNewUuids);
        }

        @Override
        public void lockNode(MapNode node, LockBranchRequest.LockScope lockScope, long lockTimeoutInMillis) throws LockFailedException {
        }

        @Override
        public void unlockNode(MapNode node) {
        }

        final int size() {
            return this.nodesByUuid.size();
        }

        @Override
        public void prepareForChange(InMemoryNode node) {
            assert (node != null);
            UUID uuid = node.getUuid();
            if (!this.nodesByUuid.containsKey(uuid)) {
                return;
            }
            if (this.stateBeforeChanges == null) {
                this.stateBeforeChanges = new HashMap<UUID, InMemoryNodeState>();
                this.stateBeforeChanges.put(uuid, new InMemoryNodeState(node));
            } else {
                assert (this.stateBeforeChanges != null);
                if (!this.stateBeforeChanges.containsKey(uuid)) {
                    this.stateBeforeChanges.put(uuid, new InMemoryNodeState(node));
                }
            }
        }

        protected void restoreBackups() {
            if (this.stateBeforeChanges != null) {
                for (Map.Entry<UUID, InMemoryNodeState> originalState : this.stateBeforeChanges.entrySet()) {
                    UUID uuid = originalState.getKey();
                    InMemoryNodeState state = originalState.getValue();
                    InMemoryNode node = (InMemoryNode)this.nodesByUuid.get(uuid);
                    if (node == null) {
                        node = state.getOriginalNode();
                    }
                    node.restoreFrom(state);
                }
                this.stateBeforeChanges = null;
            }
        }

        protected void releaseBackups() {
            this.stateBeforeChanges = null;
        }
    }
}

