/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.connector.map.MapRepository;
import org.jboss.dna.graph.connector.map.MapWorkspace;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.PropertyFactory;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.CloneBranchRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.FullTextSearchRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.LockBranchRequest;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UnlockBranchRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

public class MapRequestProcessor
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PropertyFactory propertyFactory;
    private final MapRepository repository;
    private final boolean updatesAllowed;

    public MapRequestProcessor(ExecutionContext context, MapRepository repository, Observer observer, boolean updatesAllowed) {
        super(repository.getSourceName(), context, observer);
        this.repository = repository;
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.propertyFactory = context.getPropertyFactory();
        this.updatesAllowed = updatesAllowed;
    }

    public void process(ReadAllChildrenRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        MapNode node = this.getTargetNode(workspace, request, request.of());
        if (node == null) {
            assert (request.hasError());
            return;
        }
        Location actualLocation = this.getActualLocation(request.of(), node);
        assert (actualLocation != null);
        Path path = actualLocation.getPath();
        List<MapNode> children = node.getChildren();
        for (MapNode child : children) {
            Path.Segment childName = child.getName();
            Path childPath = this.pathFactory.create(path, childName);
            request.addChild(childPath, this.propertyFactory.create(DnaLexicon.UUID, child.getUuid()));
        }
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    public void process(LockBranchRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        MapNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.lockNode(node, request.lockScope(), request.lockTimeoutInMillis());
        Location actualLocation = this.getActualLocation(request.at(), node);
        request.setActualLocation(actualLocation);
        this.recordChange(request);
    }

    public void process(UnlockBranchRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        MapNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.unlockNode(node);
        Location actualLocation = this.getActualLocation(request.at(), node);
        request.setActualLocation(actualLocation);
        this.recordChange(request);
    }

    public void process(ReadAllPropertiesRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        MapNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            assert (request.hasError());
            return;
        }
        Location actualLocation = this.getActualLocation(request.at(), node);
        request.addProperty(this.propertyFactory.create(DnaLexicon.UUID, node.getUuid()));
        for (Property property : node.getProperties().values()) {
            request.addProperty(property);
        }
        assert (actualLocation != null);
        request.setActualLocationOfNode(actualLocation);
        this.setCacheableInfo(request);
    }

    public void process(CloneBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        MapWorkspace newWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || newWorkspace == null) {
            return;
        }
        MapNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        MapNode newParent = newWorkspace.getNode(newParentPath);
        HashSet<Location> removedExistingNodes = new HashSet<Location>();
        MapNode newNode = workspace.cloneNode(this.getExecutionContext(), node, newWorkspace, newParent, request.desiredName(), request.desiredSegment(), request.removeExisting(), removedExistingNodes);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, newNode.getName());
        Location oldLocation = this.getActualLocation(request.from(), node);
        Location newLocation = Location.create(newPath, newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        request.setRemovedNodes(Collections.unmodifiableSet(removedExistingNodes));
        this.recordChange(request);
    }

    public void process(CopyBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        MapWorkspace newWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || newWorkspace == null) {
            return;
        }
        MapNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        Path newParentPath = request.into().getPath();
        Name desiredName = request.desiredName();
        MapNode newParent = newWorkspace.getNode(newParentPath);
        MapNode newNode = workspace.copyNode(this.getExecutionContext(), node, newWorkspace, newParent, desiredName, true);
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, newNode.getName());
        Location oldLocation = this.getActualLocation(request.from(), node);
        Location newLocation = Location.create(newPath, newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(CreateNodeRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        Path parent = request.under().getPath();
        CheckArg.isNotNull((Object)parent, (String)"request.under().getPath()");
        MapNode node = null;
        MapNode parentNode = workspace.getNode(parent);
        if (parentNode == null) {
            Path lowestExisting = workspace.getLowestExistingPath(parent);
            request.setError(new PathNotFoundException(request.under(), lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{parent})));
            return;
        }
        UUID uuid = null;
        ArrayList<Property> propsToStore = new ArrayList<Property>(request.properties().size());
        for (Property property : request.properties()) {
            if (property.getName().equals(DnaLexicon.UUID) || property.getName().equals(JcrLexicon.UUID)) {
                uuid = (UUID)this.getExecutionContext().getValueFactories().getUuidFactory().create(property.getValues().next());
                continue;
            }
            if (property.size() <= 0) continue;
            propsToStore.add(property);
        }
        switch (request.conflictBehavior()) {
            case APPEND: {
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid, propsToStore);
                break;
            }
            case DO_NOT_REPLACE: {
                for (MapNode child : parentNode.getChildren()) {
                    if (!request.named().equals(child.getName().getName())) continue;
                    node = child;
                    break;
                }
                if (node != null) break;
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid, propsToStore);
                break;
            }
            case REPLACE: {
                node = this.getTargetNode(workspace, null, Location.create(this.pathFactory.create(parent, request.named()), uuid));
                if (node != null) {
                    workspace.removeNode(this.getExecutionContext(), node);
                }
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid, propsToStore);
                break;
            }
            case UPDATE: {
                node = this.getTargetNode(workspace, null, Location.create(this.pathFactory.create(parent, request.named()), uuid));
                if (node != null) break;
                node = workspace.createNode(this.getExecutionContext(), parentNode, request.named(), uuid, propsToStore);
            }
        }
        assert (node != null);
        Path path = this.getExecutionContext().getValueFactories().getPathFactory().create(parent, node.getName());
        Location actualLocation = this.getActualLocation(Location.create(path), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(DeleteBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        MapNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.removeNode(this.getExecutionContext(), node);
        Location actualLocation = this.getActualLocation(request.at(), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(MoveBranchRequest request) {
        Path newParentPath;
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        MapNode beforeNode = request.before() != null ? this.getTargetNode(workspace, request, request.before()) : null;
        MapNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (request.hasError()) {
            return;
        }
        if (request.into() != null) {
            newParentPath = request.into().getPath();
        } else {
            assert (beforeNode != null);
            LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
            MapNode current = beforeNode.getParent();
            while (!current.equals(workspace.getRoot())) {
                segments.addFirst(current.getName());
                current = current.getParent();
            }
            newParentPath = this.getExecutionContext().getValueFactories().getPathFactory().createAbsolutePath(segments);
        }
        MapNode newParent = workspace.getNode(newParentPath);
        if (newParent == null) {
            Path lowestExisting = workspace.getLowestExistingPath(newParentPath);
            request.setError(new PathNotFoundException(request.into(), lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{newParentPath})));
            return;
        }
        workspace.moveNode(this.getExecutionContext(), node, request.desiredName(), workspace, newParent, beforeNode);
        assert (node.getParent().equals(newParent));
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(newParentPath, node.getName());
        Location oldLocation = this.getActualLocation(request.from(), node);
        Location newLocation = Location.create(newPath, node.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(UpdatePropertiesRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        MapNode node = this.getTargetNode(workspace, request, request.on());
        if (node == null) {
            return;
        }
        for (Map.Entry<Name, Property> propertyEntry : request.properties().entrySet()) {
            Property property = propertyEntry.getValue();
            if (property == null) {
                node.removeProperty(propertyEntry.getKey());
                continue;
            }
            Name propName = property.getName();
            if (propName.equals(DnaLexicon.UUID)) continue;
            if (node.getProperties().get(propName) == null) {
                request.setNewProperty(propName);
            }
            node.setProperty(property);
        }
        Location actualLocation = this.getActualLocation(request.on(), node);
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(CreateWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.repository.createWorkspace(this.getExecutionContext(), request.desiredNameOfNewWorkspace(), request.conflictBehavior());
        if (workspace == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{request.desiredNameOfNewWorkspace(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            MapNode root = workspace.getRoot();
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            request.setActualWorkspaceName(workspace.getName());
            this.recordChange(request);
        }
    }

    public void process(DestroyWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        MapWorkspace workspace = this.repository.getWorkspace(request.workspaceName());
        if (workspace != null) {
            MapNode root = workspace.getRoot();
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
            this.recordChange(request);
        } else {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{request.workspaceName(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
    }

    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.repository.getWorkspaceNames();
        request.setAvailableWorkspaceNames(new HashSet<String>(names));
        this.setCacheableInfo(request);
    }

    public void process(VerifyWorkspaceRequest request) {
        MapWorkspace original = this.getWorkspace(request, request.workspaceName());
        if (original != null) {
            Path path = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setActualRootLocation(Location.create(path, original.getRoot().getUuid()));
            request.setActualWorkspaceName(original.getName());
        }
    }

    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        String targetWorkspaceName = request.desiredNameOfTargetWorkspace();
        String nameOfWorkspaceToBeCloned = request.nameOfWorkspaceToBeCloned();
        MapWorkspace original = this.repository.getWorkspace(nameOfWorkspaceToBeCloned);
        MapWorkspace target = this.repository.getWorkspace(targetWorkspaceName);
        if (target != null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{targetWorkspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
            return;
        }
        if (original == null) {
            switch (request.cloneConflictBehavior()) {
                case DO_NOT_CLONE: {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{nameOfWorkspaceToBeCloned, this.repository.getSourceName()});
                    request.setError(new InvalidWorkspaceException(msg));
                    return;
                }
                case SKIP_CLONE: {
                    target = this.repository.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior());
                    assert (target != null);
                    MapNode root = target.getRoot();
                    request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
                    request.setActualWorkspaceName(target.getName());
                    return;
                }
            }
        }
        assert (original != null);
        target = this.repository.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior(), nameOfWorkspaceToBeCloned);
        assert (target != null);
        MapNode root = target.getRoot();
        request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), root.getUuid()));
        request.setActualWorkspaceName(target.getName());
        this.recordChange(request);
    }

    public void process(AccessQueryRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.query(context, request);
        if (results != null) {
            request.setResults(results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    public void process(FullTextSearchRequest request) {
        MapWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.search(context, request.expression());
        if (results != null) {
            request.setResults(results.getColumns(), results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    protected Location getActualLocation(Location location, MapNode node) {
        Path path = location.getPath();
        if (path == null) {
            LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
            for (MapNode n = node; n != null && n.getParent() != null; n = n.getParent()) {
                segments.addFirst(n.getName());
            }
            path = this.pathFactory.createAbsolutePath(segments);
        }
        assert (location.getUuid() == null || location.getUuid().equals(node.getUuid()));
        if (location.hasIdProperties()) {
            return location.with(path);
        }
        return Location.create(path, node.getUuid());
    }

    protected MapWorkspace getWorkspace(Request request, String workspaceName) {
        MapWorkspace workspace = this.repository.getWorkspace(workspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{workspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected boolean updatesAllowed(Request request) {
        if (!this.updatesAllowed) {
            request.setError(new InvalidRequestException(GraphI18n.sourceIsReadOnly.text(new Object[]{this.getSourceName()})));
        }
        return !request.hasError();
    }

    protected MapNode getTargetNode(MapWorkspace workspace, Request request, Location location) {
        if (workspace == null) {
            return null;
        }
        MapNode node = null;
        UUID uuid = location.getUuid();
        if (uuid != null) {
            node = workspace.getNode(uuid);
        }
        Path path = null;
        if (node == null && (path = location.getPath()) != null) {
            node = workspace.getNode(path);
        }
        if (node == null && request != null) {
            if (path == null) {
                if (uuid == null) {
                    I18n msg = GraphI18n.inMemoryConnectorRequestsMustHavePathOrUuid;
                    request.setError(new IllegalArgumentException(msg.text(new Object[0])));
                    return null;
                }
                request.setError(new PathNotFoundException(location, this.pathFactory.createRootPath(), GraphI18n.nodeDoesNotExist.text(new Object[]{path})));
                return null;
            }
            Path lowestExisting = workspace.getLowestExistingPath(path);
            request.setError(new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{path})));
        }
        return node;
    }
}

