/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.map;

import java.util.Set;
import java.util.UUID;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.LockFailedException;
import org.jboss.dna.graph.connector.UuidAlreadyExistsException;
import org.jboss.dna.graph.connector.map.MapNode;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.LockBranchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MapWorkspace {
    public String getName();

    public MapNode getRoot();

    public MapNode getNode(UUID var1);

    public MapNode getNode(Path var1);

    public boolean removeNode(ExecutionContext var1, MapNode var2);

    public MapNode createNode(ExecutionContext var1, String var2, Iterable<Property> var3);

    public MapNode createNode(ExecutionContext var1, MapNode var2, Name var3, UUID var4, Iterable<Property> var5);

    public void moveNode(ExecutionContext var1, MapNode var2, Name var3, MapWorkspace var4, MapNode var5, MapNode var6);

    public MapNode copyNode(ExecutionContext var1, MapNode var2, MapWorkspace var3, MapNode var4, Name var5, boolean var6);

    public MapNode cloneNode(ExecutionContext var1, MapNode var2, MapWorkspace var3, MapNode var4, Name var5, Path.Segment var6, boolean var7, Set<Location> var8) throws UuidAlreadyExistsException;

    public void lockNode(MapNode var1, LockBranchRequest.LockScope var2, long var3) throws LockFailedException;

    public void unlockNode(MapNode var1);

    public Path getLowestExistingPath(Path var1);

    public Path pathFor(PathFactory var1, MapNode var2);

    public QueryResults query(ExecutionContext var1, AccessQueryRequest var2);

    public QueryResults search(ExecutionContext var1, String var2);
}

