/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.text.NoOpEncoder;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.connector.path.PathNode;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NameFactory;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultPathNode
implements PathNode {
    private static final TextEncoder TO_STRING_ENCODER = new NoOpEncoder();
    private final Path path;
    private final Map<Name, Property> properties;
    private final List<Path.Segment> childSegments;
    private final UUID uuid;
    private Set<Name> uniqueChildNames;

    public DefaultPathNode(Path path, UUID uuid, Map<Name, Property> properties, List<Path.Segment> childSegments) {
        this.path = path;
        this.uuid = uuid;
        this.properties = properties;
        this.childSegments = childSegments;
    }

    public DefaultPathNode(Path path, UUID uuid, Iterable<Property> properties, List<Path.Segment> childSegments) {
        this.path = path;
        this.uuid = uuid;
        this.childSegments = childSegments;
        this.properties = new HashMap<Name, Property>();
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
    }

    @Override
    public List<Path.Segment> getChildSegments() {
        return this.childSegments;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Map<Name, Property> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Property getProperty(ExecutionContext context, String name) {
        NameFactory nameFactory = context.getValueFactories().getNameFactory();
        return this.getProperty((Name)nameFactory.create(name));
    }

    @Override
    public Property getProperty(Name name) {
        return this.properties.get(name);
    }

    @Override
    public Set<Name> getUniqueChildNames() {
        if (this.uniqueChildNames == null) {
            HashSet<Name> childNames = new HashSet<Name>(this.childSegments.size());
            for (Path.Segment childSegment : this.childSegments) {
                childNames.add(childSegment.getName());
            }
            this.uniqueChildNames = childNames;
        }
        return null;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.path.getString(TO_STRING_ENCODER)).append('(').append(this.properties.keySet()).append(')');
        return buff.toString();
    }
}

