/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.connector.path.PathNode;
import org.jboss.dna.graph.connector.path.PathRepository;
import org.jboss.dna.graph.connector.path.PathRepositoryTransaction;
import org.jboss.dna.graph.connector.path.PathWorkspace;
import org.jboss.dna.graph.connector.path.WritablePathRepository;
import org.jboss.dna.graph.connector.path.WritablePathWorkspace;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.CloneBranchRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.FullTextSearchRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.InvalidRequestException;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.request.LockBranchRequest;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UnlockBranchRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

public class PathRequestProcessor
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PathRepository repository;
    private final boolean updatesAllowed;
    private final PathRepositoryTransaction txn;

    public PathRequestProcessor(ExecutionContext context, PathRepository repository, Observer observer, boolean updatesAllowed, PathRepositoryTransaction txn) {
        super(repository.getSourceName(), context, observer);
        this.repository = repository;
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.updatesAllowed = updatesAllowed;
        this.txn = txn;
    }

    protected boolean updatesAllowed(Request request) {
        if (!this.updatesAllowed) {
            request.setError(new InvalidRequestException(GraphI18n.sourceIsReadOnly.text(new Object[]{this.getSourceName()})));
        }
        return !request.hasError();
    }

    public void process(VerifyWorkspaceRequest request) {
        PathWorkspace original = this.getWorkspace(request, request.workspaceName());
        if (original != null) {
            Path path = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setActualRootLocation(Location.create(path, this.repository.getRootNodeUuid()));
            request.setActualWorkspaceName(original.getName());
        }
    }

    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.repository.getWorkspaceNames();
        request.setAvailableWorkspaceNames(new HashSet<String>(names));
        this.setCacheableInfo(request);
    }

    public void process(CreateWorkspaceRequest request) {
        if (!this.repository.isWritable()) {
            String msg = GraphI18n.sourceIsReadOnly.text(new Object[]{this.repository.getSourceName()});
            request.setError(new InvalidRequestException(msg));
            return;
        }
        WritablePathRepository writableRepo = (WritablePathRepository)this.repository;
        WritablePathWorkspace workspace = writableRepo.createWorkspace(this.getExecutionContext(), request.desiredNameOfNewWorkspace(), request.conflictBehavior());
        if (workspace == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{request.desiredNameOfNewWorkspace(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), this.repository.getRootNodeUuid()));
            request.setActualWorkspaceName(workspace.getName());
            this.recordChange(request);
        }
    }

    public void process(CloneBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        PathWorkspace intoWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || intoWorkspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (!(intoWorkspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), intoWorkspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)intoWorkspace;
        Path newParentPath = request.into().getPath();
        PathNode newParent = newWorkspace.getNode(newParentPath);
        HashSet removedExistingNodes = new HashSet();
        Name desiredName = request.desiredName();
        PathNode newNode = newWorkspace.copyNode(this.getExecutionContext(), node, workspace, newParent, desiredName, true);
        Location oldLocation = Location.create(node.getPath(), node.getUuid());
        Location newLocation = Location.create(newNode.getPath(), newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        request.setRemovedNodes(Collections.unmodifiableSet(removedExistingNodes));
        this.recordChange(request);
    }

    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        String targetWorkspaceName = request.desiredNameOfTargetWorkspace();
        String nameOfWorkspaceToBeCloned = request.nameOfWorkspaceToBeCloned();
        PathWorkspace original = this.repository.getWorkspace(nameOfWorkspaceToBeCloned);
        PathWorkspace target = this.repository.getWorkspace(targetWorkspaceName);
        if (!this.repository.isWritable()) {
            String msg = GraphI18n.sourceIsReadOnly.text(new Object[]{this.repository.getSourceName()});
            request.setError(new InvalidRequestException(msg));
            return;
        }
        WritablePathRepository writableRepo = (WritablePathRepository)this.repository;
        if (target != null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(new Object[]{targetWorkspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
            return;
        }
        if (original == null) {
            switch (request.cloneConflictBehavior()) {
                case DO_NOT_CLONE: {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{nameOfWorkspaceToBeCloned, this.repository.getSourceName()});
                    request.setError(new InvalidWorkspaceException(msg));
                    return;
                }
                case SKIP_CLONE: {
                    target = writableRepo.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior());
                    assert (target != null);
                    request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), writableRepo.getRootNodeUuid()));
                    request.setActualWorkspaceName(target.getName());
                    return;
                }
            }
        }
        assert (original != null);
        target = writableRepo.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior(), nameOfWorkspaceToBeCloned);
        assert (target != null);
        request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), writableRepo.getRootNodeUuid()));
        request.setActualWorkspaceName(target.getName());
        this.recordChange(request);
    }

    public void process(DestroyWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.repository.getWorkspace(request.workspaceName());
        if (workspace != null) {
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), this.repository.getRootNodeUuid()));
            this.recordChange(request);
        } else {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{request.workspaceName(), this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
    }

    public void process(CopyBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        PathWorkspace intoWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || intoWorkspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (!(intoWorkspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), intoWorkspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)intoWorkspace;
        Path newParentPath = request.into().getPath();
        Name desiredName = request.desiredName();
        PathNode newParent = newWorkspace.getNode(newParentPath);
        PathNode newNode = newWorkspace.copyNode(this.getExecutionContext(), node, workspace, newParent, desiredName, true);
        Location oldLocation = Location.create(node.getPath(), node.getUuid());
        Location newLocation = Location.create(newNode.getPath(), newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(CreateNodeRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        Path parent = request.under().getPath();
        CheckArg.isNotNull((Object)parent, (String)"request.under().getPath()");
        PathNode node = null;
        PathNode parentNode = workspace.getNode(parent);
        if (parentNode == null) {
            Path lowestExisting = workspace.getLowestExistingPath(parent);
            request.setError(new PathNotFoundException(request.under(), lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{parent})));
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), workspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        HashMap<Name, Property> propsToStore = new HashMap<Name, Property>(request.properties().size());
        for (Property property : request.properties()) {
            if (property.size() <= 0) continue;
            propsToStore.put(property.getName(), property);
        }
        NodeConflictBehavior conflictBehavior = request.conflictBehavior();
        switch (conflictBehavior) {
            case APPEND: {
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case DO_NOT_REPLACE: {
                for (Path.Segment childSegment : parentNode.getChildSegments()) {
                    if (!request.named().equals(childSegment.getName())) continue;
                    Path childPath = this.pathFactory.create(parent, childSegment);
                    node = newWorkspace.getNode(childPath);
                    break;
                }
                if (node != null) break;
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case REPLACE: {
                node = workspace.getNode(this.pathFactory.create(parent, request.named()));
                if (node != null) {
                    newWorkspace.removeNode(this.getExecutionContext(), node.getPath());
                }
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case UPDATE: {
                node = newWorkspace.getNode(this.pathFactory.create(parent, request.named()));
                if (node != null) break;
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
            }
        }
        assert (node != null);
        Location actualLocation = Location.create(node.getPath(), node.getUuid());
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(DeleteBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), workspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        newWorkspace.removeNode(this.getExecutionContext(), node.getPath());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(MoveBranchRequest request) {
        Path newParentPath;
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode beforeNode = request.before() != null ? this.getTargetNode(workspace, request, request.before()) : null;
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (request.hasError()) {
            return;
        }
        if (request.into() != null) {
            newParentPath = request.into().getPath();
        } else {
            assert (beforeNode != null);
            newParentPath = beforeNode.getPath().getParent();
        }
        PathNode newParent = workspace.getNode(newParentPath);
        if (newParent == null) {
            Path lowestExisting = workspace.getLowestExistingPath(newParentPath);
            request.setError(new PathNotFoundException(request.into(), lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{newParentPath})));
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), workspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        node = newWorkspace.moveNode(this.getExecutionContext(), node, request.desiredName(), newWorkspace, newParent, beforeNode);
        assert (node.getPath().getParent().equals(newParent.getPath()));
        Location oldLocation = Location.create(request.from().getPath());
        Location newLocation = Location.create(node.getPath(), node.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(ReadNodeRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            request.setError(new PathNotFoundException(request.at(), workspace.getLowestExistingPath(request.at().getPath())));
            return;
        }
        for (Path.Segment childSegment : node.getChildSegments()) {
            request.addChild(Location.create(this.pathFactory.create(node.getPath(), childSegment)));
        }
        request.addProperties(node.getProperties().values());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(ReadAllChildrenRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.of());
        if (node == null) {
            request.setError(new PathNotFoundException(request.of(), workspace.getLowestExistingPath(request.of().getPath())));
            return;
        }
        List<Path.Segment> childSegments = node.getChildSegments();
        for (Path.Segment childSegment : childSegments) {
            request.addChild(Location.create(this.pathFactory.create(node.getPath(), childSegment)));
        }
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(ReadAllPropertiesRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            request.setError(new PathNotFoundException(request.at(), workspace.getLowestExistingPath(request.at().getPath())));
            return;
        }
        request.addProperties(node.getProperties().values());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(AccessQueryRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.query(context, request);
        if (results != null) {
            request.setResults(results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    public void process(FullTextSearchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.search(context, request.expression());
        if (results != null) {
            request.setResults(results.getColumns(), results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    public void process(UpdatePropertiesRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.on());
        if (node == null) {
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(new Object[]{this.repository.getSourceName(), workspace.getName()})));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        newWorkspace.setProperties(this.getExecutionContext(), node.getPath(), request.properties());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(LockBranchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.lockNode(node, request.lockScope(), request.lockTimeoutInMillis());
        request.setActualLocation(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(UnlockBranchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.unlockNode(node);
        request.setActualLocation(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    protected PathWorkspace getWorkspace(Request request, String workspaceName) {
        PathWorkspace workspace = this.repository.getWorkspace(workspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(new Object[]{workspaceName, this.repository.getSourceName()});
            request.setError(new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected PathNode getTargetNode(PathWorkspace workspace, Request request, Location location) {
        if (workspace == null) {
            return null;
        }
        PathNode node = null;
        if (location.getUuid() != null && this.repository.getRootNodeUuid().equals(location.getUuid())) {
            PathFactory pathFactory = new ExecutionContext().getValueFactories().getPathFactory();
            return workspace.getNode(pathFactory.createRootPath());
        }
        if (!location.hasPath()) {
            I18n msg = GraphI18n.pathConnectorRequestsMustHavePath;
            request.setError(new IllegalArgumentException(msg.text(new Object[0])));
            return null;
        }
        Path path = location.getPath();
        if (path != null) {
            node = workspace.getNode(path);
        }
        if (node == null && request != null) {
            if (path == null) {
                request.setError(new PathNotFoundException(location, this.pathFactory.createRootPath(), GraphI18n.nodeDoesNotExist.text(new Object[]{path})));
                return null;
            }
            Path lowestExisting = workspace.getLowestExistingPath(path);
            request.setError(new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{path})));
        }
        return node;
    }

    public PathRepositoryTransaction getTransaction() {
        return this.txn;
    }
}

