/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.connector.path.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.graph.connector.path.cache.PathCachePolicy;
import org.jboss.dna.graph.connector.path.cache.WorkspaceCache;

@ThreadSafe
public class PathRepositoryCache {
    private final PathCachePolicy policy;
    private final ConcurrentMap<String, WorkspaceCache> cachesByName = new ConcurrentHashMap<String, WorkspaceCache>();

    public PathRepositoryCache(PathCachePolicy policy) {
        this.policy = policy;
    }

    public void close() {
        for (WorkspaceCache cache : this.cachesByName.values()) {
            cache.close();
        }
    }

    public WorkspaceCache getCache(String workspaceName) {
        WorkspaceCache cache = (WorkspaceCache)this.cachesByName.get(workspaceName);
        if (cache != null) {
            return cache;
        }
        cache = this.newCache(workspaceName);
        this.cachesByName.putIfAbsent(workspaceName, cache);
        return (WorkspaceCache)this.cachesByName.get(workspaceName);
    }

    private final WorkspaceCache newCache(String workspaceName) {
        WorkspaceCache cache = null;
        try {
            cache = this.policy.getCacheClass().newInstance();
            cache.initialize(this.policy, workspaceName);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        return cache;
    }
}

