/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property;

import net.jcip.annotations.Immutable;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;

@Immutable
public class PathNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = -3703984046286975978L;
    private final Location location;
    private final Path lowestAncestorThatDoesExist;

    public PathNotFoundException(Location location, Path lowestAncestorThatDoesExist) {
        this.location = location;
        this.lowestAncestorThatDoesExist = lowestAncestorThatDoesExist;
    }

    public PathNotFoundException(Location location, Path lowestAncestorThatDoesExist, String message) {
        super(message);
        this.location = location;
        this.lowestAncestorThatDoesExist = lowestAncestorThatDoesExist;
    }

    public PathNotFoundException(Location location, Path lowestAncestorThatDoesExist, Throwable cause) {
        super(cause);
        this.location = location;
        this.lowestAncestorThatDoesExist = lowestAncestorThatDoesExist;
    }

    public PathNotFoundException(Location location, Path lowestAncestorThatDoesExist, String message, Throwable cause) {
        super(message, cause);
        this.location = location;
        this.lowestAncestorThatDoesExist = lowestAncestorThatDoesExist;
    }

    public String toString() {
        return super.toString();
    }

    public String getMessage() {
        if (this.lowestAncestorThatDoesExist != null) {
            String locationPart = this.location.hasPath() ? this.location.getPath().toString() : this.location.toString();
            return GraphI18n.pathNotFoundExceptionLowestExistingLocationFound.text(new Object[]{locationPart, this.lowestAncestorThatDoesExist});
        }
        return super.getMessage();
    }

    public Location getLocation() {
        return this.location;
    }

    public Path getLowestAncestorThatDoesExist() {
        return this.lowestAncestorThatDoesExist;
    }
}

