/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property.basic;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.basic.BasicNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class SimpleNamespaceRegistry
implements NamespaceRegistry {
    public static final String DEFAULT_NAMESPACE_URI = "";
    public static final String DEFAULT_PREFIX_TEMPLATE = "ns##000";
    public static final String DEFAULT_PREFIX_NUMBER_FORMAT = "##000";
    private final Map<String, String> namespacesByPrefix = new HashMap<String, String>();
    private final Map<String, String> prefixesByNamespace = new HashMap<String, String>();
    private String generatedPrefixTemplate = "ns##000";
    private int nextGeneratedPrefixNumber = 1;

    public SimpleNamespaceRegistry() {
        this(DEFAULT_NAMESPACE_URI);
    }

    public SimpleNamespaceRegistry(String defaultNamespaceUri) {
        this.register(DEFAULT_NAMESPACE_URI, defaultNamespaceUri);
    }

    public String getGeneratedPrefixTemplate() {
        return this.generatedPrefixTemplate;
    }

    public void setGeneratedPrefixTemplate(String prefixTemplate) {
        if (prefixTemplate == null) {
            prefixTemplate = DEFAULT_PREFIX_TEMPLATE;
        }
        this.generatedPrefixTemplate = prefixTemplate;
    }

    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        return this.namespacesByPrefix.get(prefix);
    }

    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String prefix = null;
        prefix = this.prefixesByNamespace.get(namespaceUri);
        if (prefix == null && generateIfMissing) {
            prefix = this.generatePrefix();
            this.register(prefix, namespaceUri);
            return prefix;
        }
        return prefix;
    }

    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        return this.prefixesByNamespace.containsKey(namespaceUri);
    }

    @Override
    public String getDefaultNamespaceUri() {
        return this.namespacesByPrefix.get(DEFAULT_NAMESPACE_URI);
    }

    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String previousNamespaceForPrefix = null;
        namespaceUri = namespaceUri.trim();
        if (prefix == null) {
            prefix = this.generatePrefix();
        }
        prefix = prefix.trim();
        prefix = prefix.replaceFirst("^:+", DEFAULT_NAMESPACE_URI);
        prefix = prefix.replaceFirst(":+$", DEFAULT_NAMESPACE_URI);
        previousNamespaceForPrefix = this.namespacesByPrefix.put(prefix, namespaceUri);
        String previousPrefix = this.prefixesByNamespace.put(namespaceUri, prefix);
        if (previousPrefix != null && !previousPrefix.equals(prefix)) {
            this.namespacesByPrefix.remove(previousPrefix);
        }
        if (previousNamespaceForPrefix != null && !previousNamespaceForPrefix.equals(namespaceUri)) {
            this.prefixesByNamespace.remove(previousNamespaceForPrefix);
        }
        return previousNamespaceForPrefix;
    }

    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        namespaceUri = namespaceUri.trim();
        String prefix = this.prefixesByNamespace.remove(namespaceUri);
        if (prefix == null) {
            return false;
        }
        this.namespacesByPrefix.remove(prefix);
        return true;
    }

    @Override
    public Set<String> getRegisteredNamespaceUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.prefixesByNamespace.keySet());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        HashSet<BasicNamespace> result = new HashSet<BasicNamespace>();
        for (Map.Entry<String, String> entry : this.namespacesByPrefix.entrySet()) {
            result.add(new BasicNamespace(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }

    protected String generatePrefix() {
        DecimalFormat formatter = new DecimalFormat(this.generatedPrefixTemplate);
        return formatter.format(this.nextGeneratedPrefixNumber++);
    }
}

