/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.basic.SimpleNamespaceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ThreadSafeNamespaceRegistry
implements NamespaceRegistry {
    private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final NamespaceRegistry delegate;

    public ThreadSafeNamespaceRegistry() {
        this(new SimpleNamespaceRegistry());
    }

    public ThreadSafeNamespaceRegistry(NamespaceRegistry nonThreadSafeRegistry) {
        CheckArg.isNotNull((Object)nonThreadSafeRegistry, (String)"nonThreadSafeRegistry");
        this.delegate = nonThreadSafeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNamespaceForPrefix(String prefix) {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.delegate.getNamespaceForPrefix(prefix);
            Object var5_4 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        String prefix = null;
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            prefix = this.delegate.getPrefixForNamespaceUri(namespaceUri, false);
            Object var6_5 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
        if (prefix == null && generateIfMissing) {
            lock = this.registryLock.writeLock();
            try {
                lock.lock();
                String string = prefix = this.delegate.getPrefixForNamespaceUri(namespaceUri, true);
                Object var8_9 = null;
                lock.unlock();
                return string;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                lock.unlock();
                throw throwable;
            }
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            boolean bl = this.delegate.isRegisteredNamespaceUri(namespaceUri);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultNamespaceUri() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            String string = this.delegate.getDefaultNamespaceUri();
            Object var4_3 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String register(String prefix, String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            String string = this.delegate.register(prefix, namespaceUri);
            Object var6_5 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unregister(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            boolean bl = this.delegate.unregister(namespaceUri);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getRegisteredNamespaceUris() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            Set<String> set = this.delegate.getRegisteredNamespaceUris();
            Object var4_3 = null;
            lock.unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            Set<NamespaceRegistry.Namespace> set = this.delegate.getNamespaces();
            Object var4_3 = null;
            lock.unlock();
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        ArrayList<NamespaceRegistry.Namespace> namespaces = new ArrayList<NamespaceRegistry.Namespace>(this.getNamespaces());
        Collections.sort(namespaces);
        return ((Object)namespaces).toString();
    }
}

