/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.query.model.ArithmeticOperator;
import org.jboss.dna.graph.query.model.DynamicOperand;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class ArithmeticOperand
extends DynamicOperand {
    private static final long serialVersionUID = 1L;
    private final ArithmeticOperator operator;
    private final DynamicOperand left;
    private final DynamicOperand right;
    private final int hc;

    public ArithmeticOperand(DynamicOperand left, ArithmeticOperator operator, DynamicOperand right) {
        super(left, right);
        CheckArg.isNotNull((Object)((Object)operator), (String)"operator");
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.hc = HashCode.compute((Object[])new Object[]{left, operator, right});
    }

    public ArithmeticOperator getOperator() {
        return this.operator;
    }

    public DynamicOperand getLeft() {
        return this.left;
    }

    public DynamicOperand getRight() {
        return this.right;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArithmeticOperand) {
            ArithmeticOperand that = (ArithmeticOperand)obj;
            return this.getOperator() == that.getOperator() && this.getLeft().equals(that.getLeft()) && this.getRight().equals(that.getRight());
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

