/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.ObjectUtil;
import org.jboss.dna.graph.query.model.LanguageObject;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class Column
implements LanguageObject {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final String columnName;

    public Column(SelectorName selectorName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        this.selectorName = selectorName;
        this.propertyName = null;
        this.columnName = null;
    }

    public Column(SelectorName selectorName, String propertyName, String columnName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)columnName, (String)"columnName");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.columnName = columnName;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final String getColumnName() {
        return this.columnName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.getSelectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.propertyName, (Object)that.propertyName)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls((Object)this.columnName, (Object)that.columnName);
        }
        return false;
    }

    public Column with(SelectorName newSelectorName) {
        return new Column(newSelectorName, this.propertyName, this.columnName);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

