/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class DescendantNode
extends Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String ancestorPath;

    public DescendantNode(SelectorName selectorName, String ancestorPath) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)ancestorPath, (String)"ancestorPath");
        this.selectorName = selectorName;
        this.ancestorPath = ancestorPath;
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getAncestorPath() {
        return this.ancestorPath;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.getSelectorName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DescendantNode) {
            DescendantNode that = (DescendantNode)obj;
            if (!this.selectorName.equals(that.selectorName)) {
                return false;
            }
            return this.ancestorPath.equals(that.ancestorPath);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

