/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.query.model.LanguageObject;
import org.jboss.dna.graph.query.model.SelectorName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class DynamicOperand
implements LanguageObject {
    private static final long serialVersionUID = 1L;
    private final Set<SelectorName> selectorNames;

    protected DynamicOperand(SelectorName ... selectorNames) {
        CheckArg.isNotNull((Object)selectorNames, (String)"selectorNames");
        if (selectorNames.length == 1) {
            CheckArg.isNotNull((Object)selectorNames, (String)"selectorNames[0]");
            this.selectorNames = Collections.singleton(selectorNames[0]);
        } else {
            CheckArg.isNotNull((Object)selectorNames, (String)"selectorNames[0]");
            this.selectorNames = Collections.unmodifiableSet(new LinkedHashSet<SelectorName>(Arrays.asList(selectorNames)));
            int i = 0;
            for (SelectorName name : this.selectorNames) {
                CheckArg.isNotNull((Object)name, (String)("selectorNames[" + i++ + "]"));
            }
        }
    }

    protected DynamicOperand(Collection<SelectorName> selectorNames) {
        CheckArg.isNotNull(selectorNames, (String)"selectorName");
        this.selectorNames = Collections.unmodifiableSet(new LinkedHashSet<SelectorName>(selectorNames));
    }

    protected DynamicOperand(DynamicOperand operand) {
        CheckArg.isNotNull((Object)operand, (String)"operand");
        this.selectorNames = operand.getSelectorNames();
    }

    protected DynamicOperand(Iterable<? extends DynamicOperand> operands) {
        CheckArg.isNotNull(operands, (String)"operands");
        LinkedHashSet<SelectorName> names = new LinkedHashSet<SelectorName>();
        for (DynamicOperand dynamicOperand : operands) {
            names.addAll(dynamicOperand.getSelectorNames());
        }
        this.selectorNames = Collections.unmodifiableSet(names);
    }

    protected DynamicOperand(DynamicOperand ... operands) {
        CheckArg.isNotNull((Object)operands, (String)"operands");
        LinkedHashSet<SelectorName> names = new LinkedHashSet<SelectorName>();
        for (DynamicOperand operand : operands) {
            names.addAll(operand.getSelectorNames());
        }
        this.selectorNames = Collections.unmodifiableSet(names);
    }

    public Set<SelectorName> getSelectorNames() {
        return this.selectorNames;
    }
}

