/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.query.model.JoinCondition;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.model.Source;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class Join
extends Source {
    private static final long serialVersionUID = 1L;
    private final Source left;
    private final Source right;
    private final JoinType type;
    private final JoinCondition joinCondition;
    private final int hc;

    public Join(Source left, JoinType type, Source right, JoinCondition joinCondition) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        CheckArg.isNotNull((Object)type, (String)"type");
        CheckArg.isNotNull((Object)joinCondition, (String)"joinCondition");
        this.left = left;
        this.right = right;
        this.type = type;
        this.joinCondition = joinCondition;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right, this.type, this.joinCondition});
    }

    public final Source getLeft() {
        return this.left;
    }

    public final Source getRight() {
        return this.right;
    }

    public final JoinType getType() {
        return this.type;
    }

    public final JoinCondition getJoinCondition() {
        return this.joinCondition;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Join) {
            Join that = (Join)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.type.equals(that.type)) {
                return false;
            }
            if (!this.left.equals(that.left)) {
                return false;
            }
            if (!this.right.equals(that.right)) {
                return false;
            }
            return this.joinCondition.equals(that.joinCondition);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

