/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class Or
extends Constraint {
    private static final long serialVersionUID = 1L;
    private final Constraint left;
    private final Constraint right;
    private final int hc;

    public Or(Constraint left, Constraint right) {
        CheckArg.isNotNull((Object)left, (String)"left");
        CheckArg.isNotNull((Object)right, (String)"right");
        this.left = left;
        this.right = right;
        this.hc = HashCode.compute((Object[])new Object[]{this.left, this.right});
    }

    public final Constraint getLeft() {
        return this.left;
    }

    public final Constraint getRight() {
        return this.right;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Or) {
            Or that = (Or)obj;
            if (this.hc != that.hc) {
                return false;
            }
            return this.left.equals(that.left) && this.right.equals(that.right);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

