/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.query.model.DynamicOperand;
import org.jboss.dna.graph.query.model.LanguageObject;
import org.jboss.dna.graph.query.model.Order;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

@Immutable
public class Ordering
implements LanguageObject {
    private static final long serialVersionUID = 1L;
    private final DynamicOperand operand;
    private final Order order;

    public Ordering(DynamicOperand operand, Order order) {
        CheckArg.isNotNull((Object)operand, (String)"operand");
        CheckArg.isNotNull((Object)order, (String)"order");
        this.operand = operand;
        this.order = order;
    }

    public final DynamicOperand getOperand() {
        return this.operand;
    }

    public final Order getOrder() {
        return this.order;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.operand.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Ordering) {
            Ordering that = (Ordering)obj;
            if (this.order != that.order) {
                return false;
            }
            return this.operand.equals(that.operand);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

