/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.common.util.ObjectUtil;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.Limit;
import org.jboss.dna.graph.query.model.Ordering;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.Source;
import org.jboss.dna.graph.query.model.Visitor;
import org.jboss.dna.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Query
extends QueryCommand {
    private static final long serialVersionUID = 1L;
    public static final boolean IS_DISTINCT_DEFAULT = false;
    private final Source source;
    private final Constraint constraint;
    private final List<Column> columns;
    private final boolean distinct;
    private final int hc;

    public Query(Source source) {
        CheckArg.isNotNull((Object)source, (String)"source");
        this.source = source;
        this.constraint = null;
        this.columns = Collections.emptyList();
        this.distinct = false;
        this.hc = HashCode.compute((Object[])new Object[]{this.source, this.constraint, this.columns, this.distinct});
    }

    public Query(Source source, Constraint constraint, List<Ordering> orderings, List<Column> columns, Limit limit, boolean isDistinct) {
        super(orderings, limit);
        CheckArg.isNotNull((Object)source, (String)"source");
        this.source = source;
        this.constraint = constraint;
        this.columns = columns != null ? columns : Collections.emptyList();
        this.distinct = isDistinct;
        this.hc = HashCode.compute((Object[])new Object[]{this.source, this.constraint, this.columns, this.distinct});
    }

    public final Source getSource() {
        return this.source;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final List<Column> getColumns() {
        return this.columns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Query distinct() {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits(), true);
    }

    public Query noDistinct() {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits(), false);
    }

    public Query constrainedBy(Constraint constraint) {
        return new Query(this.source, constraint, this.getOrderings(), this.columns, this.getLimits(), this.distinct);
    }

    public Query orderedBy(List<Ordering> orderings) {
        return new Query(this.source, this.constraint, orderings, this.columns, this.getLimits(), this.distinct);
    }

    public Query withLimit(int rowLimit) {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits().withRowLimit(rowLimit), this.distinct);
    }

    public Query withOffset(int offset) {
        return new Query(this.source, this.constraint, this.getOrderings(), this.columns, this.getLimits().withOffset(offset), this.distinct);
    }

    public Query returning(List<Column> columns) {
        return new Query(this.source, this.constraint, this.getOrderings(), columns, this.getLimits(), this.distinct);
    }

    public Query adding(Ordering ... orderings) {
        List<Ordering> newOrderings = null;
        if (this.getOrderings() != null) {
            newOrderings = new ArrayList<Ordering>(this.getOrderings());
            for (Ordering ordering : orderings) {
                newOrderings.add(ordering);
            }
        } else {
            newOrderings = Arrays.asList(orderings);
        }
        return new Query(this.source, this.constraint, newOrderings, this.columns, this.getLimits(), this.distinct);
    }

    public Query adding(Column ... columns) {
        List<Column> newColumns = null;
        if (this.columns != null) {
            newColumns = new ArrayList<Column>(this.columns);
            for (Column column : columns) {
                newColumns.add(column);
            }
        } else {
            newColumns = Arrays.asList(columns);
        }
        return new Query(this.source, this.constraint, this.getOrderings(), newColumns, this.getLimits(), this.distinct);
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Query) {
            Query that = (Query)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (this.distinct != that.distinct) {
                return false;
            }
            if (!this.source.equals(that.source)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.getLimits(), (Object)that.getLimits())) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls((Object)this.constraint, (Object)that.constraint)) {
                return false;
            }
            if (!ObjectUtil.isEqualWithNulls(this.columns, that.columns)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls(this.getOrderings(), that.getOrderings());
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

