/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.optimize;

import java.util.LinkedList;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.optimize.AddAccessNodes;
import org.jboss.dna.graph.query.optimize.ChooseJoinAlgorithm;
import org.jboss.dna.graph.query.optimize.CopyCriteria;
import org.jboss.dna.graph.query.optimize.Optimizer;
import org.jboss.dna.graph.query.optimize.OptimizerRule;
import org.jboss.dna.graph.query.optimize.PushProjects;
import org.jboss.dna.graph.query.optimize.PushSelectCriteria;
import org.jboss.dna.graph.query.optimize.ReplaceAliases;
import org.jboss.dna.graph.query.optimize.ReplaceViews;
import org.jboss.dna.graph.query.optimize.RewriteAsRangeCriteria;
import org.jboss.dna.graph.query.optimize.RewriteIdentityJoins;
import org.jboss.dna.graph.query.optimize.RightOuterToLeftOuterJoins;
import org.jboss.dna.graph.query.plan.PlanHints;
import org.jboss.dna.graph.query.plan.PlanNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RuleBasedOptimizer
implements Optimizer {
    private final Logger logger = Logger.getLogger(this.getClass());

    @Override
    public PlanNode optimize(QueryContext context, PlanNode plan) {
        LinkedList<OptimizerRule> rules = new LinkedList<OptimizerRule>();
        this.populateRuleStack(rules, context.getHints());
        Problems problems = context.getProblems();
        while (rules.peek() != null && !problems.hasErrors()) {
            OptimizerRule nextRule = rules.poll();
            this.logger.debug("Running query optimizer rule {0}", new Object[]{nextRule});
            plan = nextRule.execute(context, plan, rules);
        }
        return plan;
    }

    protected void populateRuleStack(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
        ruleStack.addFirst(ReplaceAliases.INSTANCE);
        ruleStack.addFirst(RewriteAsRangeCriteria.INSTANCE);
        if (hints.hasJoin) {
            ruleStack.addFirst(ChooseJoinAlgorithm.USE_ONLY_NESTED_JOIN_ALGORITHM);
            ruleStack.addFirst(RewriteIdentityJoins.INSTANCE);
        }
        ruleStack.addFirst(PushProjects.INSTANCE);
        ruleStack.addFirst(PushSelectCriteria.INSTANCE);
        ruleStack.addFirst(AddAccessNodes.INSTANCE);
        ruleStack.addFirst(RightOuterToLeftOuterJoins.INSTANCE);
        ruleStack.addFirst(CopyCriteria.INSTANCE);
        if (hints.hasView) {
            ruleStack.addFirst(ReplaceViews.INSTANCE);
        }
    }
}

