/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.parse;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.TypeSystem;
import org.jboss.dna.graph.query.parse.QueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class QueryParsers {
    private final ConcurrentMap<String, QueryParser> parsers = new ConcurrentHashMap<String, QueryParser>();

    public QueryParsers(QueryParser ... parsers) {
        if (parsers != null) {
            for (QueryParser parser : parsers) {
                if (parser == null) continue;
                this.addLanguage(parser);
            }
        }
    }

    public QueryParsers(Iterable<QueryParser> parsers) {
        if (parsers != null) {
            this.addLanguages(parsers);
        }
    }

    public void addLanguage(QueryParser languageParser) {
        CheckArg.isNotNull((Object)languageParser, (String)"languageParser");
        this.parsers.put(languageParser.getLanguage().trim().toLowerCase(), languageParser);
    }

    public void addLanguages(QueryParser firstLanguage, QueryParser ... additionalLanguages) {
        this.addLanguage(firstLanguage);
        for (QueryParser language : additionalLanguages) {
            this.addLanguage(language);
        }
    }

    public void addLanguages(Iterable<QueryParser> languages) {
        CheckArg.isNotNull(languages, (String)"languages");
        for (QueryParser language : languages) {
            this.addLanguage(language);
        }
    }

    public QueryParser removeLanguage(String language) {
        CheckArg.isNotNull((Object)language, (String)"language");
        return (QueryParser)this.parsers.remove(language.toLowerCase());
    }

    public Collection<QueryParser> removeLanguages(String firstLanguage, String ... additionalLanguages) {
        HashSet<QueryParser> removed = new HashSet<QueryParser>();
        QueryParser parser = this.removeLanguage(firstLanguage);
        if (parser != null) {
            removed.add(parser);
        }
        for (String language : additionalLanguages) {
            parser = this.removeLanguage(language);
            if (parser == null) continue;
            removed.add(parser);
        }
        return removed;
    }

    public Set<String> getLanguages() {
        HashSet<String> result = new HashSet<String>();
        for (QueryParser parser : this.parsers.values()) {
            result.add(parser.getLanguage());
        }
        return Collections.unmodifiableSet(result);
    }

    public QueryParser getParserFor(String language) {
        CheckArg.isNotNull((Object)language, (String)"language");
        return (QueryParser)this.parsers.get(language.trim().toLowerCase());
    }

    public QueryCommand parse(TypeSystem typeSystem, String language, String query) {
        CheckArg.isNotNull((Object)language, (String)"language");
        CheckArg.isNotNull((Object)typeSystem, (String)"typeSystem");
        CheckArg.isNotNull((Object)query, (String)"query");
        QueryParser parser = (QueryParser)this.parsers.get(language.trim().toLowerCase());
        if (parser == null) {
            throw new IllegalArgumentException(GraphI18n.unknownQueryLanguage.text(new Object[]{language}));
        }
        return parser.parseQuery(query, typeSystem);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParsers) {
            QueryParsers that = (QueryParsers)obj;
            return ((Object)this.getLanguages()).equals(that.getLanguages());
        }
        return false;
    }

    public String toString() {
        return "Query parsers: " + this.parsers.keySet();
    }
}

