/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.dna.common.CommonI18n;
import org.jboss.dna.common.text.ParsingException;
import org.jboss.dna.common.text.Position;
import org.jboss.dna.common.text.TokenStream;
import org.jboss.dna.common.xml.XmlCharacters;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.property.ValueFormatException;
import org.jboss.dna.graph.query.model.And;
import org.jboss.dna.graph.query.model.ArithmeticOperand;
import org.jboss.dna.graph.query.model.ArithmeticOperator;
import org.jboss.dna.graph.query.model.Between;
import org.jboss.dna.graph.query.model.BindVariableName;
import org.jboss.dna.graph.query.model.ChildNode;
import org.jboss.dna.graph.query.model.ChildNodeJoinCondition;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.Comparison;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.DescendantNode;
import org.jboss.dna.graph.query.model.DescendantNodeJoinCondition;
import org.jboss.dna.graph.query.model.DynamicOperand;
import org.jboss.dna.graph.query.model.EquiJoinCondition;
import org.jboss.dna.graph.query.model.FullTextSearch;
import org.jboss.dna.graph.query.model.FullTextSearchScore;
import org.jboss.dna.graph.query.model.Join;
import org.jboss.dna.graph.query.model.JoinCondition;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.model.Length;
import org.jboss.dna.graph.query.model.Limit;
import org.jboss.dna.graph.query.model.Literal;
import org.jboss.dna.graph.query.model.LowerCase;
import org.jboss.dna.graph.query.model.NamedSelector;
import org.jboss.dna.graph.query.model.NodeDepth;
import org.jboss.dna.graph.query.model.NodeLocalName;
import org.jboss.dna.graph.query.model.NodeName;
import org.jboss.dna.graph.query.model.NodePath;
import org.jboss.dna.graph.query.model.Not;
import org.jboss.dna.graph.query.model.Operator;
import org.jboss.dna.graph.query.model.Or;
import org.jboss.dna.graph.query.model.Order;
import org.jboss.dna.graph.query.model.Ordering;
import org.jboss.dna.graph.query.model.PropertyExistence;
import org.jboss.dna.graph.query.model.PropertyValue;
import org.jboss.dna.graph.query.model.Query;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.SameNode;
import org.jboss.dna.graph.query.model.SameNodeJoinCondition;
import org.jboss.dna.graph.query.model.Selector;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.SetCriteria;
import org.jboss.dna.graph.query.model.SetQuery;
import org.jboss.dna.graph.query.model.Source;
import org.jboss.dna.graph.query.model.StaticOperand;
import org.jboss.dna.graph.query.model.TypeSystem;
import org.jboss.dna.graph.query.model.UpperCase;
import org.jboss.dna.graph.query.parse.ColumnExpression;
import org.jboss.dna.graph.query.parse.FullTextSearchParser;
import org.jboss.dna.graph.query.parse.QueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQueryParser
implements QueryParser {
    public static final String LANGUAGE = "SQL";

    @Override
    public String getLanguage() {
        return LANGUAGE;
    }

    public String toString() {
        return LANGUAGE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryParser) {
            QueryParser that = (QueryParser)obj;
            return this.getLanguage().equals(that.getLanguage());
        }
        return false;
    }

    @Override
    public QueryCommand parseQuery(String query, TypeSystem typeSystem) {
        SqlTokenizer tokenizer = new SqlTokenizer(false);
        TokenStream tokens = new TokenStream(query, (TokenStream.Tokenizer)tokenizer, false);
        tokens.start();
        return this.parseQueryCommand(tokens, typeSystem);
    }

    protected QueryCommand parseQueryCommand(TokenStream tokens, TypeSystem typeSystem) {
        QueryCommand command = null;
        if (tokens.matches("SELECT")) {
            command = this.parseQuery(tokens, typeSystem);
            while (tokens.hasNext()) {
                if (tokens.matchesAnyOf("UNION", new String[]{"INTERSECT", "EXCEPT"})) {
                    command = this.parseSetQuery(tokens, command, typeSystem);
                    continue;
                }
                Position pos = tokens.previousPosition();
                String msg = GraphI18n.unexpectedToken.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
        } else {
            Position pos = tokens.nextPosition();
            String msg = GraphI18n.unexpectedToken.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        return command;
    }

    protected Query parseQuery(TokenStream tokens, TypeSystem typeSystem) {
        AtomicBoolean isDistinct = new AtomicBoolean(false);
        List<ColumnExpression> columnExpressions = this.parseSelect(tokens, isDistinct, typeSystem);
        Source source = this.parseFrom(tokens, typeSystem);
        Constraint constraint = this.parseWhere(tokens, typeSystem, source);
        List<Ordering> orderings = this.parseOrderBy(tokens, typeSystem, source);
        Limit limit = this.parseLimit(tokens);
        if (orderings == null) {
            this.parseOrderBy(tokens, typeSystem, source);
        }
        ArrayList<Column> columns = new ArrayList<Column>(columnExpressions.size());
        for (ColumnExpression expression : columnExpressions) {
            SelectorName selectorName = expression.getSelectorName();
            String propertyName = expression.getPropertyName();
            if (selectorName == null) {
                if (source instanceof Selector) {
                    selectorName = ((Selector)source).getName();
                } else {
                    Position pos = expression.getPosition();
                    String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{expression, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
            }
            columns.add(new Column(selectorName, propertyName, expression.getColumnName()));
        }
        return new Query(source, constraint, orderings, columns, limit, isDistinct.get());
    }

    protected SetQuery parseSetQuery(TokenStream tokens, QueryCommand leftHandSide, TypeSystem typeSystem) {
        SetQuery.Operation operation = null;
        if (tokens.canConsume("UNION")) {
            operation = SetQuery.Operation.UNION;
        } else if (tokens.canConsume("INTERSECT")) {
            operation = SetQuery.Operation.INTERSECT;
        } else {
            tokens.consume("EXCEPT");
            operation = SetQuery.Operation.EXCEPT;
        }
        boolean all = tokens.canConsume("ALL");
        Query rightQuery = this.parseQuery(tokens, typeSystem);
        return new SetQuery(leftHandSide, operation, rightQuery, all);
    }

    protected List<ColumnExpression> parseSelect(TokenStream tokens, AtomicBoolean isDistinct, TypeSystem typeSystem) {
        tokens.consume("SELECT");
        if (tokens.canConsume("DISTINCT")) {
            isDistinct.set(true);
        }
        if (tokens.canConsume('*')) {
            return Collections.emptyList();
        }
        ArrayList<ColumnExpression> columns = new ArrayList<ColumnExpression>();
        do {
            Position position = tokens.nextPosition();
            String propertyName = this.removeBracketsAndQuotes(tokens.consume());
            SelectorName selectorName = null;
            if (tokens.canConsume('.')) {
                selectorName = new SelectorName(propertyName);
                propertyName = this.removeBracketsAndQuotes(tokens.consume());
            }
            String alias = propertyName;
            if (tokens.canConsume("AS")) {
                alias = this.removeBracketsAndQuotes(tokens.consume());
            }
            columns.add(new ColumnExpression(selectorName, propertyName, alias, position));
        } while (tokens.canConsume(','));
        return columns;
    }

    protected Source parseFrom(TokenStream tokens, TypeSystem typeSystem) {
        Source source = null;
        tokens.consume("FROM");
        source = this.parseNamedSelector(tokens);
        while (tokens.hasNext()) {
            JoinType joinType = null;
            if (tokens.canConsume("JOIN") || tokens.canConsume("INNER", new String[]{"JOIN"})) {
                joinType = JoinType.INNER;
            } else if (tokens.canConsume("OUTER", new String[]{"JOIN"}) || tokens.canConsume("LEFT", new String[]{"JOIN"}) || tokens.canConsume("LEFT", new String[]{"OUTER", "JOIN"})) {
                joinType = JoinType.LEFT_OUTER;
            } else if (tokens.canConsume("RIGHT", new String[]{"OUTER", "JOIN"}) || tokens.canConsume("RIGHT", new String[]{"OUTER"})) {
                joinType = JoinType.RIGHT_OUTER;
            } else if (tokens.canConsume("FULL", new String[]{"OUTER", "JOIN"}) || tokens.canConsume("FULL", new String[]{"OUTER"})) {
                joinType = JoinType.FULL_OUTER;
            } else if (tokens.canConsume("CROSS", new String[]{"JOIN"}) || tokens.canConsume("CROSS")) {
                joinType = JoinType.CROSS;
            }
            if (joinType == null) break;
            NamedSelector right = this.parseNamedSelector(tokens);
            JoinCondition joinCondition = this.parseJoinCondition(tokens, typeSystem);
            source = new Join(source, joinType, right, joinCondition);
        }
        return source;
    }

    protected JoinCondition parseJoinCondition(TokenStream tokens, TypeSystem typeSystem) {
        tokens.consume("ON");
        if (tokens.canConsume("ISSAMENODE", new String[]{"("})) {
            SelectorName selector1Name = this.parseSelectorName(tokens);
            tokens.consume(',');
            SelectorName selector2Name = this.parseSelectorName(tokens);
            if (tokens.canConsume('.')) {
                String path = this.parsePath(tokens, typeSystem);
                tokens.consume(')');
                return new SameNodeJoinCondition(selector1Name, selector2Name, path);
            }
            tokens.consume(')');
            return new SameNodeJoinCondition(selector1Name, selector2Name);
        }
        if (tokens.canConsume("ISCHILDNODE", new String[]{"("})) {
            SelectorName child = this.parseSelectorName(tokens);
            tokens.consume(',');
            SelectorName parent = this.parseSelectorName(tokens);
            tokens.consume(')');
            return new ChildNodeJoinCondition(parent, child);
        }
        if (tokens.canConsume("ISDESCENDANTNODE", new String[]{"("})) {
            SelectorName descendant = this.parseSelectorName(tokens);
            tokens.consume(',');
            SelectorName ancestor = this.parseSelectorName(tokens);
            tokens.consume(')');
            return new DescendantNodeJoinCondition(ancestor, descendant);
        }
        SelectorName selector1 = this.parseSelectorName(tokens);
        tokens.consume('.');
        String property1 = this.parseName(tokens, typeSystem);
        tokens.consume('=');
        SelectorName selector2 = this.parseSelectorName(tokens);
        tokens.consume('.');
        String property2 = this.parseName(tokens, typeSystem);
        return new EquiJoinCondition(selector1, property1, selector2, property2);
    }

    protected Constraint parseWhere(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.canConsume("WHERE")) {
            return this.parseConstraint(tokens, typeSystem, source);
        }
        return null;
    }

    protected Constraint parseConstraint(TokenStream tokens, TypeSystem typeSystem, Source source) {
        String path;
        SelectorName selectorName;
        Constraint constraint = null;
        Position pos = tokens.nextPosition();
        if (tokens.canConsume("(")) {
            constraint = this.parseConstraint(tokens, typeSystem, source);
            tokens.consume(")");
        } else if (tokens.canConsume("NOT")) {
            tokens.canConsume('(');
            constraint = new Not(this.parseConstraint(tokens, typeSystem, source));
            tokens.canConsume(')');
        } else if (tokens.canConsume("CONTAINS", new String[]{"("})) {
            String first = tokens.consume();
            SelectorName selectorName2 = null;
            String propertyName = null;
            if (tokens.canConsume(".", new String[]{"*"})) {
                selectorName2 = new SelectorName(this.removeBracketsAndQuotes(first));
            } else if (tokens.canConsume('.')) {
                selectorName2 = new SelectorName(this.removeBracketsAndQuotes(first));
                propertyName = this.parseName(tokens, typeSystem);
            } else {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"CONTAINS()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName2 = ((Selector)source).getName();
                propertyName = first;
            }
            tokens.consume(',');
            String expression = this.removeBracketsAndQuotes(tokens.consume());
            FullTextSearch.Term term = this.parseFullTextSearchExpression(expression, tokens.previousPosition());
            tokens.consume(")");
            constraint = new FullTextSearch(selectorName2, propertyName, expression, term);
        } else if (tokens.canConsume("ISSAMENODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISSAMENODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).getName();
            } else {
                selectorName = this.parseSelectorName(tokens);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = new SameNode(selectorName, path);
        } else if (tokens.canConsume("ISCHILDNODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISCHILDNODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).getName();
            } else {
                selectorName = this.parseSelectorName(tokens);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = new ChildNode(selectorName, path);
        } else if (tokens.canConsume("ISDESCENDANTNODE", new String[]{"("})) {
            selectorName = null;
            if (tokens.matches("any value", new String[]{")"})) {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"ISDESCENDANTNODE()", pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).getName();
            } else {
                selectorName = this.parseSelectorName(tokens);
                tokens.consume(',');
            }
            path = this.parsePath(tokens, typeSystem);
            tokens.consume(')');
            constraint = new DescendantNode(selectorName, path);
        } else {
            DynamicOperand left;
            Position pos2 = tokens.nextPosition();
            constraint = this.parsePropertyExistance(tokens, typeSystem, source);
            if (constraint == null && (left = this.parseDynamicOperand(tokens, typeSystem, source)) != null) {
                if (tokens.matches('(') && left instanceof PropertyValue) {
                    String name = ((PropertyValue)left).getPropertyName();
                    String msg = GraphI18n.expectingConstraintCondition.text(new Object[]{name, pos2.getLine(), pos2.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                if (tokens.matches("IN", new String[]{"("}) || tokens.matches("NOT", new String[]{"IN", "("})) {
                    boolean not = tokens.canConsume("NOT");
                    List<StaticOperand> staticOperands = this.parseInClause(tokens, typeSystem);
                    constraint = new SetCriteria(left, staticOperands);
                    if (not) {
                        constraint = new Not(constraint);
                    }
                } else if (tokens.matches("BETWEEN") || tokens.matches("NOT", new String[]{"BETWEEN"})) {
                    boolean not = tokens.canConsume("NOT");
                    tokens.consume("BETWEEN");
                    StaticOperand lowerBound = this.parseStaticOperand(tokens, typeSystem);
                    boolean lowerInclusive = !tokens.canConsume("EXCLUSIVE");
                    tokens.consume("AND");
                    StaticOperand upperBound = this.parseStaticOperand(tokens, typeSystem);
                    boolean upperInclusive = !tokens.canConsume("EXCLUSIVE");
                    constraint = new Between(left, lowerBound, upperBound, lowerInclusive, upperInclusive);
                    if (not) {
                        constraint = new Not(constraint);
                    }
                } else {
                    Operator operator = this.parseComparisonOperator(tokens);
                    StaticOperand right = this.parseStaticOperand(tokens, typeSystem);
                    constraint = new Comparison(left, operator, right);
                }
            }
        }
        if (constraint == null) {
            String msg = GraphI18n.expectingConstraintCondition.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
        while (tokens.canConsume("AND")) {
            constraint = new And(constraint, this.parseConstraint(tokens, typeSystem, source));
        }
        while (tokens.canConsume("OR")) {
            constraint = new Or(constraint, this.parseConstraint(tokens, typeSystem, source));
        }
        return constraint;
    }

    protected List<StaticOperand> parseInClause(TokenStream tokens, TypeSystem typeSystem) {
        ArrayList<StaticOperand> result = new ArrayList<StaticOperand>();
        tokens.consume("IN");
        tokens.consume("(");
        if (!tokens.canConsume(")")) {
            do {
                result.add(this.parseStaticOperand(tokens, typeSystem));
            } while (tokens.canConsume(','));
            tokens.consume(")");
        }
        return result;
    }

    protected FullTextSearch.Term parseFullTextSearchExpression(String expression, Position startOfExpression) {
        try {
            return new FullTextSearchParser().parse(expression);
        }
        catch (ParsingException e) {
            Position queryPos = startOfExpression.add(e.getPosition());
            throw new ParsingException(queryPos, e.getMessage());
        }
    }

    protected Operator parseComparisonOperator(TokenStream tokens) {
        if (tokens.canConsume("=")) {
            return Operator.EQUAL_TO;
        }
        if (tokens.canConsume("LIKE")) {
            return Operator.LIKE;
        }
        if (tokens.canConsume("!", new String[]{"="})) {
            return Operator.NOT_EQUAL_TO;
        }
        if (tokens.canConsume("<", new String[]{">"})) {
            return Operator.NOT_EQUAL_TO;
        }
        if (tokens.canConsume("<", new String[]{"="})) {
            return Operator.LESS_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume(">", new String[]{"="})) {
            return Operator.GREATER_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume("<")) {
            return Operator.LESS_THAN;
        }
        if (tokens.canConsume(">")) {
            return Operator.GREATER_THAN;
        }
        Position pos = tokens.nextPosition();
        String msg = GraphI18n.expectingComparisonOperator.text(new Object[]{tokens.consume(), pos.getLine(), pos.getColumn()});
        throw new ParsingException(pos, msg);
    }

    protected List<Ordering> parseOrderBy(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.canConsume("ORDER", new String[]{"BY"})) {
            ArrayList<Ordering> orderings = new ArrayList<Ordering>();
            do {
                orderings.add(this.parseOrdering(tokens, typeSystem, source));
            } while (tokens.canConsume(','));
            return orderings;
        }
        return null;
    }

    protected Ordering parseOrdering(TokenStream tokens, TypeSystem typeSystem, Source source) {
        DynamicOperand operand = this.parseDynamicOperand(tokens, typeSystem, source);
        Order order = Order.ASCENDING;
        if (tokens.canConsume("DESC")) {
            order = Order.DESCENDING;
        }
        if (tokens.canConsume("ASC")) {
            order = Order.ASCENDING;
        }
        return new Ordering(operand, order);
    }

    protected Constraint parsePropertyExistance(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.matches("any value", new String[]{".", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", "IS", "NULL"}) || tokens.matches("any value", new String[]{"IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{"IS", "NULL"})) {
            Position pos = tokens.nextPosition();
            String firstWord = tokens.consume();
            SelectorName selectorName = null;
            String propertyName = null;
            if (tokens.canConsume('.')) {
                selectorName = new SelectorName(firstWord);
                propertyName = this.parseName(tokens, typeSystem);
            } else {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{firstWord, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).getName();
                propertyName = firstWord;
            }
            if (tokens.canConsume("IS", new String[]{"NOT", "NULL"})) {
                return new PropertyExistence(selectorName, propertyName);
            }
            tokens.consume("IS", new String[]{"NULL"});
            return new Not(new PropertyExistence(selectorName, propertyName));
        }
        return null;
    }

    protected StaticOperand parseStaticOperand(TokenStream tokens, TypeSystem typeSystem) {
        if (tokens.canConsume('$')) {
            String value = tokens.consume();
            if (!XmlCharacters.isValidNcName((String)value)) {
                Position pos = tokens.previousPosition();
                String msg = GraphI18n.bindVariableMustConformToNcName.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            return new BindVariableName(value);
        }
        return this.parseLiteral(tokens, typeSystem);
    }

    protected Literal parseLiteral(TokenStream tokens, TypeSystem typeSystem) {
        if (tokens.canConsume("CAST", new String[]{"("})) {
            Position pos = tokens.nextPosition();
            String value = this.parseLiteralValue(tokens, typeSystem);
            tokens.consume("AS");
            String typeName = tokens.consume();
            TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(typeName);
            if (typeFactory == null) {
                Position typePos = tokens.previousPosition();
                String msg = GraphI18n.invalidPropertyType.text(new Object[]{tokens.consume(), typePos.getLine(), typePos.getColumn()});
                throw new ParsingException(typePos, msg);
            }
            tokens.consume(')');
            try {
                Object literal = typeFactory.create(value);
                return new Literal(literal);
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.valueCannotBeCastToSpecifiedType.text(new Object[]{value, pos.getLine(), pos.getColumn(), typeFactory.getTypeName(), e.getMessage()});
                throw new ParsingException(pos, msg);
            }
        }
        return new Literal(this.parseLiteralValue(tokens, typeSystem));
    }

    protected String parseLiteralValue(TokenStream tokens, TypeSystem typeSystem) {
        TypeSystem.TypeFactory<?> dateTimeFactory;
        if (tokens.matches(4)) {
            return this.removeBracketsAndQuotes(tokens.consume());
        }
        TypeSystem.TypeFactory<Boolean> booleanFactory = typeSystem.getBooleanFactory();
        if (booleanFactory != null) {
            if (tokens.canConsume("TRUE")) {
                return booleanFactory.asString(Boolean.TRUE);
            }
            if (tokens.canConsume("FALSE")) {
                return booleanFactory.asString(Boolean.FALSE);
            }
        }
        Position pos = tokens.nextPosition();
        String sign = "";
        if (tokens.canConsume('-')) {
            sign = "-";
        } else if (tokens.canConsume('+')) {
            sign = "";
        }
        String integral = tokens.consume();
        TypeSystem.TypeFactory<Double> doubleFactory = typeSystem.getDoubleFactory();
        if (doubleFactory != null) {
            String decimal = null;
            if (tokens.canConsume('.')) {
                decimal = tokens.consume();
                String value = sign + integral + "." + decimal;
                if (decimal.endsWith("e") && (tokens.matches('+') || tokens.matches('-'))) {
                    value = value + tokens.consume() + tokens.consume();
                }
                try {
                    return doubleFactory.asString(doubleFactory.create(value));
                }
                catch (ValueFormatException e) {
                    String msg = GraphI18n.expectingLiteralAndUnableToParseAsDouble.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
            }
        }
        if ((dateTimeFactory = typeSystem.getDateTimeFactory()) != null && tokens.canConsume('-')) {
            String year = integral;
            String month = tokens.consume();
            tokens.consume('-');
            String dateAndHour = tokens.consume();
            tokens.consume(':');
            String minutes = tokens.consume();
            tokens.consume(':');
            String seconds = tokens.consume();
            tokens.consume('.');
            String subSeconds = tokens.consume();
            String tzSign = "+";
            String tzHours = "00";
            String tzMinutes = "00";
            String tzDelim = ":";
            if (tokens.canConsume('+')) {
                tzHours = tokens.consume();
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (tokens.canConsume('-')) {
                tzSign = "-";
                tzHours = tokens.consume();
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (tokens.canConsume(':')) {
                tzSign = "";
                tzHours = "";
                if (tokens.canConsume(':')) {
                    tzMinutes = tokens.consume();
                }
            } else if (subSeconds.endsWith("Z")) {
                tzHours = "";
                tzDelim = "";
                tzMinutes = "";
                tzSign = "";
            } else if (subSeconds.endsWith("UTC")) {
                subSeconds = subSeconds.length() > 3 ? subSeconds.substring(0, subSeconds.length() - 3) : subSeconds;
            }
            String value = sign + year + "-" + month + "-" + dateAndHour + ":" + minutes + ":" + seconds + "." + subSeconds + tzSign + tzHours + tzDelim + tzMinutes;
            try {
                Object dateTime = dateTimeFactory.create(value);
                return dateTimeFactory.asString(dateTime);
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.expectingLiteralAndUnableToParseAsDate.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
        }
        TypeSystem.TypeFactory<Long> longFactory = typeSystem.getLongFactory();
        String value = sign + integral;
        try {
            return longFactory.asString(longFactory.create(value));
        }
        catch (ValueFormatException e) {
            String msg = GraphI18n.expectingLiteralAndUnableToParseAsLong.text(new Object[]{value, pos.getLine(), pos.getColumn()});
            throw new ParsingException(pos, msg);
        }
    }

    protected DynamicOperand parseDynamicOperand(TokenStream tokens, TypeSystem typeSystem, Source source) {
        DynamicOperand result = null;
        Position pos = tokens.nextPosition();
        if (tokens.canConsume('(')) {
            result = this.parseDynamicOperand(tokens, typeSystem, source);
            tokens.consume(")");
        } else if (tokens.canConsume("LENGTH", new String[]{"("})) {
            result = new Length(this.parsePropertyValue(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("LOWER", new String[]{"("})) {
            result = new LowerCase(this.parseDynamicOperand(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("UPPER", new String[]{"("})) {
            result = new UpperCase(this.parseDynamicOperand(tokens, typeSystem, source));
            tokens.consume(")");
        } else if (tokens.canConsume("NAME", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return new NodeName(((Selector)source).getName());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"NAME()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = new NodeName(this.parseSelectorName(tokens));
            tokens.consume(")");
        } else if (tokens.canConsume("LOCALNAME", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return new NodeLocalName(((Selector)source).getName());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"LOCALNAME()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = new NodeLocalName(this.parseSelectorName(tokens));
            tokens.consume(")");
        } else if (tokens.canConsume("SCORE", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return new FullTextSearchScore(((Selector)source).getName());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"SCORE()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = new FullTextSearchScore(this.parseSelectorName(tokens));
            tokens.consume(")");
        } else if (tokens.canConsume("DEPTH", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return new NodeDepth(((Selector)source).getName());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"DEPTH()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = new NodeDepth(this.parseSelectorName(tokens));
            tokens.consume(")");
        } else if (tokens.canConsume("PATH", new String[]{"("})) {
            if (tokens.canConsume(")")) {
                if (source instanceof Selector) {
                    return new NodePath(((Selector)source).getName());
                }
                String msg = GraphI18n.functionIsAmbiguous.text(new Object[]{"PATH()", pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            result = new NodePath(this.parseSelectorName(tokens));
            tokens.consume(")");
        } else {
            result = this.parsePropertyValue(tokens, typeSystem, source);
        }
        ArithmeticOperator arithmeticOperator = null;
        if (tokens.canConsume('+')) {
            arithmeticOperator = ArithmeticOperator.ADD;
        } else if (tokens.canConsume('-')) {
            arithmeticOperator = ArithmeticOperator.SUBTRACT;
        } else if (tokens.canConsume('*')) {
            arithmeticOperator = ArithmeticOperator.MULTIPLY;
        } else if (tokens.canConsume('/')) {
            arithmeticOperator = ArithmeticOperator.DIVIDE;
        }
        if (arithmeticOperator != null) {
            if (tokens.matches('(')) {
                DynamicOperand right = this.parseDynamicOperand(tokens, typeSystem, source);
                result = new ArithmeticOperand(result, arithmeticOperator, right);
            } else {
                DynamicOperand right = this.parseDynamicOperand(tokens, typeSystem, source);
                if (right instanceof ArithmeticOperand) {
                    ArithmeticOperand arithRhs = (ArithmeticOperand)right;
                    ArithmeticOperator rhsOperator = arithRhs.getOperator();
                    if (arithmeticOperator.precedes(rhsOperator)) {
                        DynamicOperand newRhs = arithRhs.getRight();
                        ArithmeticOperand newLhs = new ArithmeticOperand(result, arithmeticOperator, arithRhs.getLeft());
                        result = new ArithmeticOperand((DynamicOperand)newLhs, rhsOperator, newRhs);
                    } else {
                        result = new ArithmeticOperand(result, arithmeticOperator, right);
                    }
                } else {
                    result = new ArithmeticOperand(result, arithmeticOperator, right);
                }
            }
        }
        return result;
    }

    protected PropertyValue parsePropertyValue(TokenStream tokens, TypeSystem typeSystem, Source source) {
        Position pos = tokens.nextPosition();
        String firstWord = this.removeBracketsAndQuotes(tokens.consume());
        SelectorName selectorName = null;
        if (tokens.canConsume('.')) {
            selectorName = new SelectorName(firstWord);
            String propertyName = this.parseName(tokens, typeSystem);
            return new PropertyValue(selectorName, propertyName);
        }
        if (source instanceof Selector) {
            selectorName = ((Selector)source).getAliasOrName();
            return new PropertyValue(selectorName, firstWord);
        }
        String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{firstWord, pos.getLine(), pos.getColumn()});
        throw new ParsingException(pos, msg);
    }

    protected Limit parseLimit(TokenStream tokens) {
        if (tokens.canConsume("LIMIT")) {
            int first = tokens.consumeInteger();
            if (tokens.canConsume(',')) {
                int to = tokens.consumeInteger();
                int offset = to - first;
                if (offset < 0) {
                    Position pos = tokens.previousPosition();
                    String msg = GraphI18n.secondValueInLimitRangeCannotBeLessThanFirst.text(new Object[]{first, to, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                return new Limit(offset, first);
            }
            if (tokens.canConsume("OFFSET")) {
                int offset = tokens.consumeInteger();
                return new Limit(first, offset);
            }
            return new Limit(first, 0);
        }
        return null;
    }

    protected String removeBracketsAndQuotes(String text) {
        if (text.length() > 0) {
            char firstChar = text.charAt(0);
            switch (firstChar) {
                case '\"': 
                case '\'': {
                    assert (text.charAt(text.length() - 1) == firstChar);
                    return this.removeBracketsAndQuotes(text.substring(1, text.length() - 1));
                }
                case '[': {
                    assert (text.charAt(text.length() - 1) == ']');
                    return this.removeBracketsAndQuotes(text.substring(1, text.length() - 1));
                }
            }
        }
        return text;
    }

    protected NamedSelector parseNamedSelector(TokenStream tokens) {
        SelectorName name = this.parseSelectorName(tokens);
        SelectorName alias = null;
        if (tokens.canConsume("AS")) {
            alias = this.parseSelectorName(tokens);
        }
        return new NamedSelector(name, alias);
    }

    protected SelectorName parseSelectorName(TokenStream tokens) {
        return new SelectorName(this.removeBracketsAndQuotes(tokens.consume()));
    }

    protected String parsePath(TokenStream tokens, TypeSystem typeSystem) {
        return this.removeBracketsAndQuotes(tokens.consume());
    }

    protected String parseName(TokenStream tokens, TypeSystem typeSystem) {
        return this.removeBracketsAndQuotes(tokens.consume());
    }

    public static class SqlTokenizer
    implements TokenStream.Tokenizer {
        public static final int WORD = 1;
        public static final int SYMBOL = 2;
        public static final int OTHER = 3;
        public static final int QUOTED_STRING = 4;
        public static final int COMMENT = 6;
        private final boolean useComments;

        public SqlTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            block7: while (input.hasNext()) {
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    case '!': 
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case ']': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '[': {
                        int startIndex = input.index();
                        char closingChar = c == '[' ? (char)']' : (char)c;
                        Position pos = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext(closingChar)) {
                                c = input.next();
                                continue;
                            }
                            if (c != closingChar) continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            if (closingChar == '\'') {
                                msg = CommonI18n.noMatchingSingleQuoteFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            } else if (closingChar == ']') {
                                msg = GraphI18n.noMatchingBracketFound.text(new Object[]{pos.getLine(), pos.getColumn()});
                            }
                            throw new ParsingException(pos, msg);
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, 4);
                        break;
                    }
                    case '-': {
                        int endIndex;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        if (input.isNext('-')) {
                            boolean foundLineTerminator = false;
                            while (input.hasNext()) {
                                c = input.next();
                                if (c != '\n' && c != '\r') continue;
                                foundLineTerminator = true;
                                break;
                            }
                            endIndex = input.index();
                            if (!foundLineTerminator) {
                                ++endIndex;
                            }
                            if (c == '\r' && input.isNext('\n')) {
                                input.next();
                            }
                            if (!this.useComments) continue block7;
                            tokens.addToken(pos, startIndex, endIndex, 6);
                            break;
                        }
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    case '/': {
                        int endIndex;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        if (input.isNext('*')) {
                            while (input.hasNext() && !input.isNext('*', '/')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (!this.useComments) continue block7;
                            endIndex = input.index() + 1;
                            tokens.addToken(pos, startIndex, endIndex, 6);
                            break;
                        }
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        break;
                    }
                    default: {
                        int tokenType;
                        int startIndex = input.index();
                        Position pos = input.position(input.index());
                        int n = tokenType = Character.isLetterOrDigit(c) || c == '_' ? 1 : 3;
                        while (input.isNextLetterOrDigit() || input.isNext('_')) {
                            c = input.next();
                        }
                        int endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, tokenType);
                    }
                }
            }
        }
    }
}

