/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.plan;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.model.AllNodes;
import org.jboss.dna.graph.query.model.And;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.FullTextSearch;
import org.jboss.dna.graph.query.model.Join;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.model.Limit;
import org.jboss.dna.graph.query.model.NamedSelector;
import org.jboss.dna.graph.query.model.Ordering;
import org.jboss.dna.graph.query.model.Query;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.Selector;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.SetQuery;
import org.jboss.dna.graph.query.model.Source;
import org.jboss.dna.graph.query.model.Visitors;
import org.jboss.dna.graph.query.plan.JoinAlgorithm;
import org.jboss.dna.graph.query.plan.PlanNode;
import org.jboss.dna.graph.query.plan.Planner;
import org.jboss.dna.graph.query.validate.Schemata;
import org.jboss.dna.graph.query.validate.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalPlanner
implements Planner {
    @Override
    public PlanNode createPlan(QueryContext context, QueryCommand query) {
        PlanNode plan = null;
        plan = query instanceof Query ? this.createCanonicalPlan(context, (Query)query) : this.createCanonicalPlan(context, (SetQuery)query);
        return plan;
    }

    protected PlanNode createCanonicalPlan(QueryContext context, Query query) {
        PlanNode plan = null;
        HashMap<SelectorName, Schemata.Table> usedSources = new HashMap<SelectorName, Schemata.Table>();
        plan = this.createPlanNode(context, query.getSource(), usedSources);
        plan = this.attachCriteria(context, plan, query.getConstraint());
        plan = this.attachProject(context, plan, query.getColumns(), usedSources);
        if (query.isDistinct()) {
            plan = this.attachDuplicateRemoval(context, plan);
        }
        plan = this.attachSorting(context, plan, query.getOrderings());
        plan = this.attachLimits(context, plan, query.getLimits());
        this.validate(context, query, usedSources);
        return plan;
    }

    protected void validate(QueryContext context, QueryCommand query, Map<SelectorName, Schemata.Table> usedSelectors) {
        Visitors.visitAll(query, new Validator(context, usedSelectors));
    }

    protected PlanNode createCanonicalPlan(QueryContext context, SetQuery query) {
        PlanNode left = this.createPlan(context, query.getLeft());
        PlanNode right = this.createPlan(context, query.getRight());
        PlanNode plan = new PlanNode(PlanNode.Type.SET_OPERATION);
        plan.addChildren(left, right);
        plan.setProperty(PlanNode.Property.SET_OPERATION, query.getOperation());
        plan.setProperty(PlanNode.Property.SET_USE_ALL, query.isAll());
        plan = this.attachSorting(context, plan, query.getOrderings());
        plan = this.attachLimits(context, plan, query.getLimits());
        return plan;
    }

    protected PlanNode createPlanNode(QueryContext context, Source source, Map<SelectorName, Schemata.Table> usedSelectors) {
        if (source instanceof Selector) {
            assert (source instanceof AllNodes || source instanceof NamedSelector);
            Selector selector = (Selector)source;
            PlanNode node = new PlanNode(PlanNode.Type.SOURCE);
            if (selector.hasAlias()) {
                node.addSelector(selector.getAlias());
                node.setProperty(PlanNode.Property.SOURCE_ALIAS, selector.getAlias());
                node.setProperty(PlanNode.Property.SOURCE_NAME, selector.getName());
            } else {
                node.addSelector(selector.getName());
                node.setProperty(PlanNode.Property.SOURCE_NAME, selector.getName());
            }
            Schemata.Table table = context.getSchemata().getTable(selector.getName());
            if (table != null) {
                if (table instanceof Schemata.View) {
                    context.getHints().hasView = true;
                }
                if (usedSelectors.put(selector.getAliasOrName(), table) != null) {
                    // empty if block
                }
                node.setProperty(PlanNode.Property.SOURCE_COLUMNS, table.getColumns());
            } else {
                context.getProblems().addError(GraphI18n.tableDoesNotExist, new Object[]{selector.getName()});
            }
            return node;
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            PlanNode node = new PlanNode(PlanNode.Type.JOIN);
            node.setProperty(PlanNode.Property.JOIN_TYPE, join.getType());
            node.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
            node.setProperty(PlanNode.Property.JOIN_CONDITION, join.getJoinCondition());
            context.getHints().hasJoin = true;
            if (join.getType() == JoinType.LEFT_OUTER) {
                context.getHints().hasOptionalJoin = true;
            }
            Source[] clauses = new Source[]{join.getLeft(), join.getRight()};
            for (int i = 0; i < 2; ++i) {
                PlanNode sourceNode = this.createPlanNode(context, clauses[i], usedSelectors);
                node.addLastChild(sourceNode);
                for (PlanNode child : node.getChildren()) {
                    node.addSelectors(child.getSelectors());
                }
            }
            return node;
        }
        assert (false);
        return null;
    }

    protected PlanNode attachCriteria(final QueryContext context, PlanNode plan, Constraint constraint) {
        if (constraint == null) {
            return plan;
        }
        context.getHints().hasCriteria = true;
        LinkedList<Constraint> andableConstraints = new LinkedList<Constraint>();
        this.separateAndConstraints(constraint, andableConstraints);
        assert (!andableConstraints.isEmpty());
        while (!andableConstraints.isEmpty()) {
            Constraint criteria = andableConstraints.removeLast();
            PlanNode criteriaNode = new PlanNode(PlanNode.Type.SELECT);
            criteriaNode.setProperty(PlanNode.Property.SELECT_CRITERIA, criteria);
            criteriaNode.addSelectors(Visitors.getSelectorsReferencedBy(criteria));
            Visitors.visitAll(criteria, new Visitors.AbstractVisitor(){

                public void visit(FullTextSearch obj) {
                    context.getHints().hasFullTextSearch = true;
                }
            });
            criteriaNode.addFirstChild(plan);
            plan = criteriaNode;
        }
        return plan;
    }

    protected void separateAndConstraints(Constraint constraint, List<Constraint> andableConstraints) {
        if (constraint == null) {
            return;
        }
        assert (andableConstraints != null);
        if (constraint instanceof And) {
            And and = (And)constraint;
            this.separateAndConstraints(and.getLeft(), andableConstraints);
            this.separateAndConstraints(and.getRight(), andableConstraints);
        } else {
            andableConstraints.add(constraint);
        }
    }

    protected PlanNode attachSorting(QueryContext context, PlanNode plan, List<Ordering> orderings) {
        if (orderings.isEmpty()) {
            return plan;
        }
        PlanNode sortNode = new PlanNode(PlanNode.Type.SORT);
        context.getHints().hasSort = true;
        sortNode.setProperty(PlanNode.Property.SORT_ORDER_BY, orderings);
        for (Ordering ordering : orderings) {
            sortNode.addSelectors(Visitors.getSelectorsReferencedBy(ordering));
        }
        sortNode.addLastChild(plan);
        return sortNode;
    }

    protected PlanNode attachLimits(QueryContext context, PlanNode plan, Limit limit) {
        if (limit.isUnlimited()) {
            return plan;
        }
        context.getHints().hasLimit = true;
        PlanNode limitNode = new PlanNode(PlanNode.Type.LIMIT);
        boolean attach = false;
        if (limit.getOffset() != 0) {
            limitNode.setProperty(PlanNode.Property.LIMIT_OFFSET, limit.getOffset());
            attach = true;
        }
        if (!limit.isUnlimited()) {
            limitNode.setProperty(PlanNode.Property.LIMIT_COUNT, limit.getRowLimit());
            attach = true;
        }
        if (attach) {
            limitNode.addLastChild(plan);
            plan = limitNode;
        }
        return plan;
    }

    protected PlanNode attachProject(QueryContext context, PlanNode plan, List<Column> columns, Map<SelectorName, Schemata.Table> selectors) {
        if (columns == null) {
            columns = Collections.emptyList();
        }
        PlanNode projectNode = new PlanNode(PlanNode.Type.PROJECT);
        if (columns.isEmpty()) {
            columns = new LinkedList();
            for (Map.Entry<SelectorName, Schemata.Table> entry : selectors.entrySet()) {
                SelectorName tableName = entry.getKey();
                Schemata.Table table = entry.getValue();
                projectNode.addSelector(tableName);
                for (Schemata.Column column : table.getColumns()) {
                    String columnName;
                    String propertyName = columnName = column.getName();
                    columns.add(new Column(tableName, propertyName, columnName));
                }
            }
        } else {
            for (Column column : columns) {
                SelectorName tableName = column.getSelectorName();
                projectNode.addSelector(tableName);
                Schemata.Table table = selectors.get(tableName);
                if (table == null) {
                    context.getProblems().addError(GraphI18n.tableDoesNotExist, new Object[]{tableName});
                    continue;
                }
                String columnName = column.getPropertyName();
                String name = columnName;
                if (table.getColumn(name) != null) continue;
                context.getProblems().addError(GraphI18n.columnDoesNotExistOnTable, new Object[]{name, tableName});
            }
        }
        projectNode.setProperty(PlanNode.Property.PROJECT_COLUMNS, columns);
        projectNode.addLastChild(plan);
        return projectNode;
    }

    protected PlanNode attachDuplicateRemoval(QueryContext context, PlanNode plan) {
        PlanNode dupNode = new PlanNode(PlanNode.Type.DUP_REMOVE);
        plan.setParent(dupNode);
        return dupNode;
    }
}

