/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jboss.dna.graph.query.process.DelegatingComponent;
import org.jboss.dna.graph.query.process.SortValuesComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctOfSortedComponent
extends DelegatingComponent {
    private final Comparator<Object[]> comparator;

    public DistinctOfSortedComponent(SortValuesComponent delegate) {
        super(delegate);
        this.comparator = delegate.getSortingComparator();
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        Iterator<Object[]> iter = tuples.iterator();
        Object[] previous = null;
        while (iter.hasNext()) {
            Object[] current = iter.next();
            if (previous != null && this.comparator.compare(previous, current) == 0) {
                iter.remove();
                continue;
            }
            previous = current;
        }
        return tuples;
    }
}

