/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.ArrayList;
import java.util.Comparator;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.ValueComparators;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.query.model.ChildNodeJoinCondition;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.DescendantNodeJoinCondition;
import org.jboss.dna.graph.query.model.EquiJoinCondition;
import org.jboss.dna.graph.query.model.JoinCondition;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.model.SameNodeJoinCondition;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.TypeSystem;
import org.jboss.dna.graph.query.process.ProcessingComponent;
import org.jboss.dna.graph.query.process.QueryResultColumns;
import org.jboss.dna.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinComponent
extends ProcessingComponent {
    protected static final Comparator<Location> LOCATION_COMPARATOR = Location.comparator();
    private final ProcessingComponent left;
    private final ProcessingComponent right;
    private final JoinCondition condition;
    private final JoinType joinType;

    protected JoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, JoinCondition condition, JoinType joinType) {
        super(context, JoinComponent.computeJoinedColumns(left.getColumns(), right.getColumns()));
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.condition = condition;
        assert (this.left != null);
        assert (this.right != null);
        assert (this.joinType != null);
    }

    public final JoinType getJoinType() {
        return this.joinType;
    }

    public final JoinCondition getJoinCondition() {
        return this.condition;
    }

    protected final ProcessingComponent left() {
        return this.left;
    }

    protected final ProcessingComponent right() {
        return this.right;
    }

    protected final QueryResults.Columns leftColunns() {
        return this.left.getColumns();
    }

    protected final QueryResults.Columns rightColumns() {
        return this.right.getColumns();
    }

    protected static QueryResults.Columns computeJoinedColumns(QueryResults.Columns leftColumns, QueryResults.Columns rightColumns) {
        ArrayList<Column> columns = new ArrayList<Column>(leftColumns.getColumnCount() + rightColumns.getColumnCount());
        columns.addAll(leftColumns.getColumns());
        columns.addAll(rightColumns.getColumns());
        boolean includeFullTextScores = leftColumns.hasFullTextSearchScores() || rightColumns.hasFullTextSearchScores();
        return new QueryResultColumns(columns, includeFullTextScores);
    }

    protected static TupleMerger createMerger(QueryResults.Columns joinColumns, QueryResults.Columns leftColumns, QueryResults.Columns rightColumns) {
        final int joinTupleSize = joinColumns.getTupleSize();
        int joinColumnCount = joinColumns.getColumnCount();
        int joinLocationCount = joinColumns.getLocationCount();
        final int leftColumnCount = leftColumns.getColumnCount();
        final int leftLocationCount = leftColumns.getLocationCount();
        int leftTupleSize = leftColumns.getTupleSize();
        final int rightColumnCount = rightColumns.getColumnCount();
        final int rightLocationCount = rightColumns.getLocationCount();
        int rightTupleSize = rightColumns.getTupleSize();
        final int startLeftLocations = joinColumnCount;
        final int startRightLocations = startLeftLocations + leftLocationCount;
        assert (joinLocationCount == leftLocationCount + rightLocationCount);
        if (joinColumns.hasFullTextSearchScores()) {
            final int leftScoreCount = leftTupleSize - leftColumnCount - leftLocationCount;
            final int rightScoreCount = rightTupleSize - rightColumnCount - rightLocationCount;
            final int startLeftScores = startRightLocations + rightLocationCount;
            final int startRightScores = startLeftScores + leftScoreCount;
            final boolean leftScores = leftScoreCount > 0;
            final boolean rightScores = rightScoreCount > 0;
            return new TupleMerger(){

                public Object[] merge(Object[] leftTuple, Object[] rightTuple) {
                    Object[] result = new Object[joinTupleSize];
                    if (leftTuple != null) {
                        System.arraycopy(result, 0, leftTuple, 0, leftColumnCount);
                        System.arraycopy(result, startLeftLocations, leftTuple, leftColumnCount, leftLocationCount);
                        if (leftScores) {
                            System.arraycopy(result, startLeftScores, leftTuple, leftLocationCount, leftScoreCount);
                        }
                    }
                    if (rightTuple != null) {
                        System.arraycopy(result, leftColumnCount, rightTuple, 0, rightColumnCount);
                        System.arraycopy(result, startRightLocations, rightTuple, rightColumnCount, rightLocationCount);
                        if (rightScores) {
                            System.arraycopy(result, startRightScores, rightTuple, rightLocationCount, rightScoreCount);
                        }
                    }
                    return result;
                }
            };
        }
        return new TupleMerger(){

            public Object[] merge(Object[] leftTuple, Object[] rightTuple) {
                Object[] result = new Object[joinTupleSize];
                if (leftTuple != null) {
                    System.arraycopy(result, 0, leftTuple, 0, leftColumnCount);
                    System.arraycopy(result, startLeftLocations, leftTuple, leftColumnCount, leftLocationCount);
                }
                if (rightTuple != null) {
                    System.arraycopy(result, leftColumnCount, rightTuple, 0, rightColumnCount);
                    System.arraycopy(result, startRightLocations, rightTuple, rightColumnCount, rightLocationCount);
                }
                return result;
            }
        };
    }

    protected static ValueSelector valueSelectorFor(ProcessingComponent source, JoinCondition condition) {
        if (condition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition joinCondition = (ChildNodeJoinCondition)condition;
            String childSelectorName = joinCondition.getChildSelectorName().getName();
            if (source.getColumns().hasSelector(childSelectorName)) {
                return JoinComponent.selectPath(source, childSelectorName);
            }
            String parentSelectorName = joinCondition.getParentSelectorName().getName();
            return JoinComponent.selectPath(source, parentSelectorName);
        }
        if (condition instanceof SameNodeJoinCondition) {
            SameNodeJoinCondition joinCondition = (SameNodeJoinCondition)condition;
            String selector1Name = joinCondition.getSelector1Name().getName();
            if (source.getColumns().hasSelector(selector1Name)) {
                return JoinComponent.selectPath(source, selector1Name);
            }
            String selector2Name = joinCondition.getSelector2Name().getName();
            return JoinComponent.selectPath(source, selector2Name);
        }
        if (condition instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition joinCondition = (DescendantNodeJoinCondition)condition;
            String ancestorSelectorName = joinCondition.getAncestorSelectorName().getName();
            if (source.getColumns().hasSelector(ancestorSelectorName)) {
                return JoinComponent.selectPath(source, ancestorSelectorName);
            }
            String descendantSelectorName = joinCondition.getDescendantSelectorName().getName();
            return JoinComponent.selectPath(source, descendantSelectorName);
        }
        if (condition instanceof EquiJoinCondition) {
            EquiJoinCondition joinCondition = (EquiJoinCondition)condition;
            SelectorName selector1Name = joinCondition.getSelector1Name();
            String propName1 = joinCondition.getProperty1Name();
            if (source.getColumns().hasSelector(selector1Name.getName())) {
                return JoinComponent.selectValue(source, selector1Name, propName1);
            }
            SelectorName selector2Name = joinCondition.getSelector2Name();
            String propName2 = joinCondition.getProperty2Name();
            return JoinComponent.selectValue(source, selector2Name, propName2);
        }
        throw new IllegalArgumentException();
    }

    private static ValueSelector selectPath(ProcessingComponent component, String selectorName) {
        final int index = component.getColumns().getLocationIndex(selectorName);
        return new ValueSelector(){

            public Object evaluate(Object[] tuple) {
                Location location = (Location)tuple[index];
                return location != null ? location.getPath() : null;
            }
        };
    }

    private static ValueSelector selectValue(ProcessingComponent component, SelectorName selectorName, String propertyName) {
        final int index = component.getColumns().getColumnIndexForProperty(selectorName.getName(), propertyName);
        return new ValueSelector(){

            public Object evaluate(Object[] tuple) {
                return tuple[index];
            }
        };
    }

    protected static Joinable joinableFor(ProcessingComponent left, ProcessingComponent right, JoinCondition condition) {
        if (condition instanceof SameNodeJoinCondition) {
            return new Joinable(){

                public boolean evaluate(Object locationA, Object locationB) {
                    Location location1 = (Location)locationA;
                    Location location2 = (Location)locationB;
                    return location1.isSame(location2);
                }
            };
        }
        if (condition instanceof EquiJoinCondition) {
            return new Joinable(){

                public boolean evaluate(Object leftValue, Object rightValue) {
                    return leftValue.equals(rightValue);
                }
            };
        }
        if (condition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition joinCondition = (ChildNodeJoinCondition)condition;
            String childSelectorName = joinCondition.getChildSelectorName().getName();
            if (left.getColumns().hasSelector(childSelectorName)) {
                return new Joinable(){

                    public boolean evaluate(Object childLocation, Object parentLocation) {
                        Path childPath = ((Location)childLocation).getPath();
                        Path parentPath = ((Location)parentLocation).getPath();
                        return childPath.getParent().isSameAs(parentPath);
                    }
                };
            }
            return new Joinable(){

                public boolean evaluate(Object parentLocation, Object childLocation) {
                    Path childPath = ((Location)childLocation).getPath();
                    Path parentPath = ((Location)parentLocation).getPath();
                    return childPath.getParent().isSameAs(parentPath);
                }
            };
        }
        if (condition instanceof DescendantNodeJoinCondition) {
            DescendantNodeJoinCondition joinCondition = (DescendantNodeJoinCondition)condition;
            String ancestorSelectorName = joinCondition.getAncestorSelectorName().getName();
            if (left.getColumns().hasSelector(ancestorSelectorName)) {
                return new Joinable(){

                    public boolean evaluate(Object ancestorLocation, Object descendantLocation) {
                        Path ancestorPath = ((Location)ancestorLocation).getPath();
                        Path descendantPath = ((Location)descendantLocation).getPath();
                        return ancestorPath.isAncestorOf(descendantPath);
                    }
                };
            }
            return new Joinable(){

                public boolean evaluate(Object descendantLocation, Object ancestorLocation) {
                    Path ancestorPath = ((Location)ancestorLocation).getPath();
                    Path descendantPath = ((Location)descendantLocation).getPath();
                    return ancestorPath.isAncestorOf(descendantPath);
                }
            };
        }
        throw new IllegalArgumentException();
    }

    protected static Comparator<Object> comparatorFor(QueryContext context, ProcessingComponent left, ProcessingComponent right, JoinCondition condition) {
        final Comparator<Path> pathComparator = ValueComparators.PATH_COMPARATOR;
        if (condition instanceof SameNodeJoinCondition) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object location1, Object location2) {
                    Path path1 = ((Location)location1).getPath();
                    Path path2 = ((Location)location2).getPath();
                    return pathComparator.compare(path1, path2);
                }
            };
        }
        if (condition instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition joinCondition = (ChildNodeJoinCondition)condition;
            String childSelectorName = joinCondition.getChildSelectorName().getName();
            if (left.getColumns().hasSelector(childSelectorName)) {
                return new Comparator<Object>(){

                    @Override
                    public int compare(Object childLocation, Object parentLocation) {
                        Path childPath = ((Location)childLocation).getPath();
                        Path parentPath = ((Location)parentLocation).getPath();
                        if (childPath.isRoot()) {
                            return parentPath.isRoot() ? 0 : -1;
                        }
                        Path parentOfChild = childPath.getParent();
                        return pathComparator.compare(parentPath, parentOfChild);
                    }
                };
            }
            return new Comparator<Object>(){

                @Override
                public int compare(Object parentLocation, Object childLocation) {
                    Path childPath = ((Location)childLocation).getPath();
                    Path parentPath = ((Location)parentLocation).getPath();
                    if (childPath.isRoot()) {
                        return parentPath.isRoot() ? 0 : -1;
                    }
                    Path parentOfChild = childPath.getParent();
                    return pathComparator.compare(parentPath, parentOfChild);
                }
            };
        }
        if (condition instanceof EquiJoinCondition) {
            TypeSystem.TypeFactory<?> typeFactory;
            EquiJoinCondition joinCondition = (EquiJoinCondition)condition;
            SelectorName leftSelectorName = joinCondition.getSelector1Name();
            SelectorName rightSelectorName = joinCondition.getSelector2Name();
            String leftPropertyName = joinCondition.getProperty1Name();
            String rightPropertyName = joinCondition.getProperty2Name();
            Schemata schemata = context.getSchemata();
            Schemata.Table leftTable = schemata.getTable(leftSelectorName);
            Schemata.Column leftColumn = leftTable.getColumn(leftPropertyName);
            String leftType = leftColumn.getPropertyType();
            Schemata.Table rightTable = schemata.getTable(rightSelectorName);
            Schemata.Column rightColumn = rightTable.getColumn(rightPropertyName);
            String rightType = rightColumn.getPropertyType();
            TypeSystem typeSystem = context.getTypeSystem();
            if (leftType.equals(rightType) && (typeFactory = typeSystem.getTypeFactory(leftType)) != null) {
                return typeFactory.getComparator();
            }
            return typeSystem.getDefaultComparator();
        }
        throw new IllegalArgumentException();
    }

    protected static interface Joinable {
        public boolean evaluate(Object var1, Object var2);
    }

    protected static interface ValueSelector {
        public Object evaluate(Object[] var1);
    }

    protected static interface TupleMerger {
        public Object[] merge(Object[] var1, Object[] var2);
    }
}

