/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.List;
import org.jboss.dna.graph.query.model.Limit;
import org.jboss.dna.graph.query.process.DelegatingComponent;
import org.jboss.dna.graph.query.process.ProcessingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitComponent
extends DelegatingComponent {
    private final Limit limit;

    public LimitComponent(ProcessingComponent delegate, Limit limit) {
        super(delegate);
        this.limit = limit;
        assert (this.limit != null);
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (this.limit.isOffset()) {
            if (this.limit.getOffset() >= tuples.size()) {
                return this.emptyTuples();
            }
            if (this.limit.isUnlimited()) {
                tuples = tuples.subList(this.limit.getOffset(), tuples.size());
            } else {
                int toIndex = Math.min(this.limit.getOffset() + this.limit.getRowLimit(), tuples.size());
                tuples = tuples.subList(this.limit.getOffset(), toIndex);
            }
        } else if (!this.limit.isUnlimited()) {
            int toIndex = Math.min(this.limit.getRowLimit(), tuples.size());
            tuples = tuples.subList(0, toIndex);
        }
        return tuples;
    }
}

