/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.model.JoinCondition;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.process.JoinComponent;
import org.jboss.dna.graph.query.process.ProcessingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedLoopJoinComponent
extends JoinComponent {
    public NestedLoopJoinComponent(QueryContext context, ProcessingComponent left, ProcessingComponent right, JoinCondition condition, JoinType joinType) {
        super(context, left, right, condition, joinType);
    }

    @Override
    public List<Object[]> execute() {
        JoinComponent.ValueSelector leftSelector = NestedLoopJoinComponent.valueSelectorFor(this.left(), this.getJoinCondition());
        JoinComponent.ValueSelector rightSelector = NestedLoopJoinComponent.valueSelectorFor(this.right(), this.getJoinCondition());
        JoinComponent.Joinable joinable = NestedLoopJoinComponent.joinableFor(this.left(), this.right(), this.getJoinCondition());
        JoinComponent.TupleMerger merger = NestedLoopJoinComponent.createMerger(this.getColumns(), this.left().getColumns(), this.right().getColumns());
        List<Object[]> leftTuples = this.left().execute();
        List<Object[]> rightTuples = this.right().execute();
        ArrayList<Object[]> tuples = new ArrayList<Object[]>(leftTuples.size() * rightTuples.size());
        for (Object[] leftTuple : leftTuples) {
            for (Object[] rightTuple : rightTuples) {
                Object rightValue;
                Object leftValue = leftSelector.evaluate(leftTuple);
                if (!joinable.evaluate(leftValue, rightValue = rightSelector.evaluate(rightTuple))) continue;
                Object[] result = merger.merge(leftTuple, rightTuple);
                tuples.add(result);
            }
        }
        return tuples;
    }
}

