/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.query.model.ChildNodeJoinCondition;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.EquiJoinCondition;
import org.jboss.dna.graph.query.model.JoinCondition;
import org.jboss.dna.graph.query.model.JoinType;
import org.jboss.dna.graph.query.model.Limit;
import org.jboss.dna.graph.query.model.Ordering;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.SameNodeJoinCondition;
import org.jboss.dna.graph.query.model.SetQuery;
import org.jboss.dna.graph.query.plan.JoinAlgorithm;
import org.jboss.dna.graph.query.plan.PlanNode;
import org.jboss.dna.graph.query.process.DistinctComponent;
import org.jboss.dna.graph.query.process.ExceptComponent;
import org.jboss.dna.graph.query.process.IntersectComponent;
import org.jboss.dna.graph.query.process.LimitComponent;
import org.jboss.dna.graph.query.process.MergeJoinComponent;
import org.jboss.dna.graph.query.process.NestedLoopJoinComponent;
import org.jboss.dna.graph.query.process.NoResultsComponent;
import org.jboss.dna.graph.query.process.ProcessingComponent;
import org.jboss.dna.graph.query.process.Processor;
import org.jboss.dna.graph.query.process.ProjectComponent;
import org.jboss.dna.graph.query.process.QueryResultColumns;
import org.jboss.dna.graph.query.process.SelectComponent;
import org.jboss.dna.graph.query.process.SortLocationsComponent;
import org.jboss.dna.graph.query.process.SortValuesComponent;
import org.jboss.dna.graph.query.process.UnionComponent;

public abstract class QueryProcessor
implements Processor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults execute(QueryContext context, QueryCommand command, QueryResults.Statistics statistics, PlanNode plan) {
        long nanos = System.nanoTime();
        QueryResultColumns columns = null;
        List<Object[]> tuples = null;
        try {
            PlanNode project = plan.findAtOrBelow(PlanNode.Type.PROJECT);
            assert (project != null);
            List<Column> projectedColumns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
            assert (projectedColumns != null);
            assert (!projectedColumns.isEmpty());
            columns = new QueryResultColumns(projectedColumns, context.getHints().hasFullTextSearch);
            SelectComponent.Analyzer analyzer = this.createAnalyzer(context);
            ProcessingComponent component = this.createComponent(command, context, plan, columns, analyzer);
            long nanos2 = System.nanoTime();
            statistics = statistics.withResultsFormulationTime(nanos2 - nanos);
            nanos = nanos2;
            if (component != null) {
                try {
                    this.preExecute(context);
                    tuples = component.execute();
                    Object var16_13 = null;
                    this.postExecute(context);
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    this.postExecute(context);
                    throw throwable;
                }
            } else {
                assert (context.getProblems().hasErrors());
                tuples = Collections.emptyList();
            }
            Object var18_16 = null;
            statistics = statistics.withExecutionTime(System.nanoTime() - nanos);
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            statistics = statistics.withExecutionTime(System.nanoTime() - nanos);
            throw throwable;
        }
        assert (tuples != null);
        String planDesc = context.getHints().showPlan ? plan.getString() : null;
        return new org.jboss.dna.graph.query.process.QueryResults(columns, statistics, tuples, context.getProblems(), planDesc);
    }

    protected void preExecute(QueryContext context) {
    }

    protected void postExecute(QueryContext context) {
    }

    protected SelectComponent.Analyzer createAnalyzer(QueryContext context) {
        return null;
    }

    protected abstract ProcessingComponent createAccessComponent(QueryCommand var1, QueryContext var2, PlanNode var3, QueryResults.Columns var4, SelectComponent.Analyzer var5);

    protected ProcessingComponent createComponent(QueryCommand originalQuery, QueryContext context, PlanNode node, QueryResults.Columns columns, SelectComponent.Analyzer analyzer) {
        ProcessingComponent component = null;
        switch (node.getType()) {
            case ACCESS: {
                if (node.hasProperty(PlanNode.Property.ACCESS_NO_RESULTS)) {
                    component = new NoResultsComponent(context, columns);
                    break;
                }
                assert (node.getChildCount() == 1);
                component = this.createAccessComponent(originalQuery, context, node, columns, analyzer);
                break;
            }
            case DUP_REMOVE: {
                assert (node.getChildCount() == 1);
                ProcessingComponent distinctDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                component = new DistinctComponent(distinctDelegate);
                break;
            }
            case GROUP: {
                throw new UnsupportedOperationException();
            }
            case JOIN: {
                assert (node.getChildCount() == 2);
                ProcessingComponent left = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                ProcessingComponent right = this.createComponent(originalQuery, context, node.getLastChild(), columns, analyzer);
                JoinAlgorithm algorithm = node.getProperty(PlanNode.Property.JOIN_ALGORITHM, JoinAlgorithm.class);
                JoinType joinType = node.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class);
                JoinCondition joinCondition = node.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
                switch (algorithm) {
                    case MERGE: {
                        JoinCondition condition;
                        if (joinCondition instanceof SameNodeJoinCondition) {
                            condition = (SameNodeJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (SameNodeJoinCondition)condition, joinType);
                            break;
                        }
                        if (joinCondition instanceof ChildNodeJoinCondition) {
                            condition = (ChildNodeJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (ChildNodeJoinCondition)condition, joinType);
                            break;
                        }
                        if (joinCondition instanceof EquiJoinCondition) {
                            condition = (EquiJoinCondition)joinCondition;
                            component = new MergeJoinComponent(context, left, right, (EquiJoinCondition)condition, joinType);
                            break;
                        }
                        assert (false) : "Unable to use merge algorithm with descendant node join conditions";
                        throw new UnsupportedOperationException();
                    }
                    case NESTED_LOOP: {
                        component = new NestedLoopJoinComponent(context, left, right, joinCondition, joinType);
                    }
                }
                List<Constraint> constraints = node.getPropertyAsList(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class);
                for (Constraint constraint : constraints) {
                    component = new SelectComponent(component, constraint, context.getVariables());
                }
                break;
            }
            case LIMIT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent limitDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                Integer rowLimit = node.getProperty(PlanNode.Property.LIMIT_COUNT, Integer.class);
                Integer offset = node.getProperty(PlanNode.Property.LIMIT_OFFSET, Integer.class);
                Limit limit = Limit.NONE;
                if (rowLimit != null) {
                    limit = limit.withRowLimit(rowLimit);
                }
                if (offset != null) {
                    limit = limit.withOffset(offset);
                }
                component = new LimitComponent(limitDelegate, limit);
                break;
            }
            case NULL: {
                component = new NoResultsComponent(context, columns);
                break;
            }
            case PROJECT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent projectDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                List<Column> projectedColumns = node.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                component = new ProjectComponent(projectDelegate, projectedColumns);
                break;
            }
            case SELECT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent selectDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                Constraint constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
                component = new SelectComponent(selectDelegate, constraint, context.getVariables(), analyzer);
                break;
            }
            case SET_OPERATION: {
                LinkedList<ProcessingComponent> setDelegates = new LinkedList<ProcessingComponent>();
                for (PlanNode child : node) {
                    setDelegates.add(this.createComponent(originalQuery, context, child, columns, analyzer));
                }
                SetQuery.Operation operation = node.getProperty(PlanNode.Property.SET_OPERATION, SetQuery.Operation.class);
                boolean all = node.getProperty(PlanNode.Property.SET_USE_ALL, Boolean.class);
                boolean alreadySorted = false;
                switch (operation) {
                    case EXCEPT: {
                        component = new ExceptComponent(context, columns, setDelegates, alreadySorted, all);
                        break;
                    }
                    case INTERSECT: {
                        component = new IntersectComponent(context, columns, setDelegates, alreadySorted, all);
                        break;
                    }
                    case UNION: {
                        component = new UnionComponent(context, columns, setDelegates, alreadySorted, all);
                    }
                }
                break;
            }
            case SORT: {
                assert (node.getChildCount() == 1);
                ProcessingComponent sortDelegate = this.createComponent(originalQuery, context, node.getFirstChild(), columns, analyzer);
                List<Object> orderBys = node.getPropertyAsList(PlanNode.Property.SORT_ORDER_BY, Object.class);
                if (orderBys.isEmpty()) {
                    component = sortDelegate;
                    break;
                }
                if (orderBys.get(0) instanceof Ordering) {
                    ArrayList<Ordering> orderings = new ArrayList<Ordering>(orderBys.size());
                    for (Object orderBy : orderBys) {
                        orderings.add((Ordering)orderBy);
                    }
                    component = new SortValuesComponent(sortDelegate, orderings);
                    break;
                }
                component = new SortLocationsComponent(sortDelegate);
                break;
            }
            case SOURCE: {
                assert (false) : "Source nodes should always be below ACCESS nodes by the time a plan is executed";
                throw new UnsupportedOperationException();
            }
        }
        assert (component != null);
        return component;
    }
}

