/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.Constraint;
import org.jboss.dna.graph.query.model.FullTextSearch;
import org.jboss.dna.graph.query.model.Visitors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class QueryResultColumns
implements QueryResults.Columns {
    private static final long serialVersionUID = 1L;
    protected static final List<Column> NO_COLUMNS = Collections.emptyList();
    protected static final QueryResultColumns EMPTY = new QueryResultColumns(false, null);
    protected static final String DEFAULT_SELECTOR_NAME = "Results";
    private final int tupleSize;
    private final List<Column> columns;
    private final List<String> columnNames;
    private final List<String> selectorNames;
    private List<String> tupleValueNames;
    private final Map<String, Column> columnsByName;
    private final Map<String, Integer> columnIndexByColumnName;
    private final Map<String, Integer> locationIndexBySelectorName;
    private final Map<String, Integer> locationIndexByColumnName;
    private final Map<Integer, Integer> locationIndexByColumnIndex;
    private final Map<String, Map<String, Integer>> columnIndexByPropertyNameBySelectorName;
    private final Map<String, Integer> fullTextSearchScoreIndexBySelectorName;

    public static QueryResultColumns empty() {
        return EMPTY;
    }

    public QueryResultColumns(List<Column> columns, boolean includeFullTextSearchScores) {
        this(includeFullTextSearchScores, columns);
        CheckArg.isNotEmpty(columns, (String)"columns");
    }

    protected QueryResultColumns(boolean includeFullTextSearchScores, List<Column> columns) {
        this.columns = columns != null ? Collections.unmodifiableList(columns) : NO_COLUMNS;
        this.columnsByName = new HashMap<String, Column>();
        this.columnIndexByColumnName = new HashMap<String, Integer>();
        HashSet<String> selectors = new HashSet<String>();
        int columnCount = this.columns.size();
        Integer selectorIndex = new Integer(columnCount - 1);
        this.locationIndexBySelectorName = new HashMap<String, Integer>();
        this.locationIndexByColumnIndex = new HashMap<Integer, Integer>();
        this.locationIndexByColumnName = new HashMap<String, Integer>();
        this.columnIndexByPropertyNameBySelectorName = new HashMap<String, Map<String, Integer>>();
        ArrayList<String> selectorNames = new ArrayList<String>(columnCount);
        ArrayList<String> names = new ArrayList<String>(columnCount);
        int max = this.columns.size();
        for (int i = 0; i != max; ++i) {
            Column column = this.columns.get(i);
            assert (column != null);
            String columnName = column.getColumnName();
            assert (columnName != null);
            if (this.columnsByName.put(columnName, column) != null) assert (false) : "Column names must be unique";
            names.add(columnName);
            this.columnIndexByColumnName.put(columnName, new Integer(i));
            String selectorName = column.getSelectorName().getName();
            if (selectors.add(selectorName)) {
                selectorNames.add(selectorName);
                selectorIndex = new Integer(selectorIndex + 1);
                this.locationIndexBySelectorName.put(selectorName, selectorIndex);
            }
            this.locationIndexByColumnIndex.put(new Integer(i), selectorIndex);
            this.locationIndexByColumnName.put(columnName, selectorIndex);
            Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
            if (byPropertyName == null) {
                byPropertyName = new HashMap<String, Integer>();
                this.columnIndexByPropertyNameBySelectorName.put(selectorName, byPropertyName);
            }
            byPropertyName.put(column.getPropertyName(), new Integer(i));
        }
        if (columns != null && selectorNames.isEmpty()) {
            String selectorName = DEFAULT_SELECTOR_NAME;
            selectorNames.add(selectorName);
            this.locationIndexBySelectorName.put(selectorName, 0);
        }
        this.selectorNames = Collections.unmodifiableList(selectorNames);
        this.columnNames = Collections.unmodifiableList(names);
        if (includeFullTextSearchScores) {
            this.fullTextSearchScoreIndexBySelectorName = new HashMap<String, Integer>();
            int index = this.columnNames.size() + selectorNames.size();
            for (String selectorName : selectorNames) {
                this.fullTextSearchScoreIndexBySelectorName.put(selectorName, new Integer(index++));
            }
            this.tupleSize = this.columnNames.size() + selectorNames.size() + selectorNames.size();
        } else {
            this.fullTextSearchScoreIndexBySelectorName = null;
            this.tupleSize = this.columnNames.size() + selectorNames.size();
        }
    }

    public static boolean includeFullTextScores(Iterable<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            if (!QueryResultColumns.includeFullTextScores(constraint)) continue;
            return true;
        }
        return false;
    }

    public static boolean includeFullTextScores(Constraint constraint) {
        final AtomicBoolean includeFullTextScores = new AtomicBoolean(false);
        if (constraint != null) {
            Visitors.visitAll(constraint, new Visitors.AbstractVisitor(){

                public void visit(FullTextSearch obj) {
                    includeFullTextScores.set(true);
                }
            });
        }
        return includeFullTextScores.get();
    }

    @Override
    public QueryResults.Columns subSelect(List<Column> columns) {
        return new QueryResultColumns(columns, this);
    }

    @Override
    public QueryResults.Columns subSelect(Column ... columns) {
        return new QueryResultColumns(Arrays.asList(columns), this);
    }

    private QueryResultColumns(List<Column> columns, QueryResultColumns wrappedAround) {
        assert (columns != null);
        this.columns = Collections.unmodifiableList(columns);
        this.columnsByName = new HashMap<String, Column>();
        this.columnIndexByColumnName = new HashMap<String, Integer>();
        this.locationIndexBySelectorName = new HashMap<String, Integer>();
        this.locationIndexByColumnIndex = new HashMap<Integer, Integer>();
        this.locationIndexByColumnName = new HashMap<String, Integer>();
        this.columnIndexByPropertyNameBySelectorName = new HashMap<String, Map<String, Integer>>();
        this.selectorNames = new ArrayList<String>(columns.size());
        ArrayList<String> names = new ArrayList<String>(columns.size());
        int max = this.columns.size();
        for (int i = 0; i != max; ++i) {
            Column column = this.columns.get(i);
            assert (column != null);
            String columnName = column.getColumnName();
            assert (columnName != null);
            if (this.columnsByName.put(columnName, column) != null) assert (false) : "Column names must be unique";
            names.add(columnName);
            Integer columnIndex = new Integer(wrappedAround.getColumnIndexForName(columnName));
            this.columnIndexByColumnName.put(columnName, columnIndex);
            String selectorName = column.getSelectorName().getName();
            if (!this.selectorNames.contains(selectorName)) {
                this.selectorNames.add(selectorName);
            }
            Integer selectorIndex = new Integer(wrappedAround.getLocationIndex(selectorName));
            this.locationIndexBySelectorName.put(selectorName, selectorIndex);
            this.locationIndexByColumnIndex.put(new Integer(0), selectorIndex);
            this.locationIndexByColumnName.put(columnName, selectorIndex);
            Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
            if (byPropertyName == null) {
                byPropertyName = new HashMap<String, Integer>();
                this.columnIndexByPropertyNameBySelectorName.put(selectorName, byPropertyName);
            }
            byPropertyName.put(column.getPropertyName(), columnIndex);
        }
        if (this.selectorNames.isEmpty()) {
            String selectorName = DEFAULT_SELECTOR_NAME;
            this.selectorNames.add(selectorName);
            this.locationIndexBySelectorName.put(selectorName, 0);
        }
        this.columnNames = Collections.unmodifiableList(names);
        if (wrappedAround.fullTextSearchScoreIndexBySelectorName != null) {
            this.fullTextSearchScoreIndexBySelectorName = new HashMap<String, Integer>();
            int index = this.columnNames.size() + this.selectorNames.size();
            for (String selectorName : this.selectorNames) {
                this.fullTextSearchScoreIndexBySelectorName.put(selectorName, new Integer(index++));
            }
            this.tupleSize = this.columnNames.size() + this.selectorNames.size() + this.selectorNames.size();
        } else {
            this.fullTextSearchScoreIndexBySelectorName = null;
            this.tupleSize = this.columnNames.size() + this.selectorNames.size();
        }
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getLocationCount() {
        return this.selectorNames.size();
    }

    @Override
    public List<String> getSelectorNames() {
        return this.selectorNames;
    }

    @Override
    public int getTupleSize() {
        return this.tupleSize;
    }

    @Override
    public List<String> getTupleValueNames() {
        if (this.tupleValueNames == null) {
            String name;
            ArrayList<String> results = new ArrayList<String>(this.getTupleSize());
            results.addAll(this.columnNames);
            for (String selectorName : this.selectorNames) {
                name = "Location(" + selectorName + ")";
                results.add(name);
            }
            if (this.fullTextSearchScoreIndexBySelectorName != null) {
                for (String selectorName : this.selectorNames) {
                    name = "Score(" + selectorName + ")";
                    results.add(name);
                }
            }
            this.tupleValueNames = results;
        }
        return this.tupleValueNames;
    }

    @Override
    public int getLocationIndexForColumn(int columnIndex) {
        if (this.locationIndexByColumnIndex.isEmpty()) {
            return 0;
        }
        Integer result = this.locationIndexByColumnIndex.get(new Integer(columnIndex));
        if (result == null) {
            throw new IndexOutOfBoundsException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnIndex}));
        }
        return result;
    }

    @Override
    public int getLocationIndexForColumn(String columnName) {
        if (this.locationIndexByColumnName.isEmpty()) {
            return 0;
        }
        Integer result = this.locationIndexByColumnName.get(columnName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnName}));
        }
        return result;
    }

    @Override
    public int getLocationIndex(String selectorName) {
        Integer result = this.locationIndexBySelectorName.get(selectorName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        return result;
    }

    @Override
    public boolean hasSelector(String selectorName) {
        return this.locationIndexBySelectorName.containsKey(selectorName);
    }

    @Override
    public String getPropertyNameForColumn(int columnIndex) {
        return this.columns.get(columnIndex).getPropertyName();
    }

    @Override
    public String getPropertyNameForColumn(String columnName) {
        Column result = this.columnsByName.get(columnName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnName}));
        }
        return result.getPropertyName();
    }

    @Override
    public int getColumnIndexForName(String columnName) {
        Integer result = this.columnIndexByColumnName.get(columnName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnName}));
        }
        return result;
    }

    @Override
    public int getColumnIndexForProperty(String selectorName, String propertyName) {
        Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
        if (byPropertyName == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        Integer result = byPropertyName.get(propertyName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.propertyOnSelectorIsNotUsedInQuery.text(new Object[]{propertyName, selectorName}));
        }
        return result;
    }

    @Override
    public int getFullTextSearchScoreIndexFor(String selectorName) {
        if (this.fullTextSearchScoreIndexBySelectorName == null) {
            return -1;
        }
        Integer result = this.fullTextSearchScoreIndexBySelectorName.get(selectorName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        return result;
    }

    @Override
    public boolean hasFullTextSearchScores() {
        return this.fullTextSearchScoreIndexBySelectorName != null;
    }

    @Override
    public boolean includes(QueryResults.Columns other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getColumns().containsAll(other.getColumns());
    }

    @Override
    public boolean isUnionCompatible(QueryResults.Columns other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hasFullTextSearchScores() != other.hasFullTextSearchScores()) {
            return false;
        }
        if (this.getColumnCount() != other.getColumnCount()) {
            return false;
        }
        return this.getColumns().containsAll(other.getColumns()) && other.getColumns().containsAll(this.getColumns());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryResultColumns) {
            QueryResultColumns that = (QueryResultColumns)obj;
            return ((Object)this.getColumns()).equals(that.getColumns());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean first = true;
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append("] => Locations[");
        first = true;
        int count = this.getColumnCount();
        for (int i = 0; i != count; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getLocationIndexForColumn(i));
        }
        sb.append(']');
        return sb.toString();
    }
}

