/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.ImmutableProblems;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.query.model.TypeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class QueryResults
implements org.jboss.dna.graph.query.QueryResults {
    private static final Problems NO_PROBLEMS = new ImmutableProblems((Problems)new SimpleProblems());
    private static final long serialVersionUID = 1L;
    private final Problems problems;
    private final QueryResults.Columns columns;
    private final List<Object[]> tuples;
    private final QueryResults.Statistics statistics;
    private final String plan;

    public QueryResults(QueryResults.Columns columns, QueryResults.Statistics statistics, List<Object[]> tuples, Problems problems, String plan) {
        assert (columns != null);
        assert (statistics != null);
        this.problems = problems != null ? problems : NO_PROBLEMS;
        this.columns = columns;
        this.tuples = tuples;
        this.statistics = statistics;
        this.plan = plan;
    }

    public QueryResults(QueryResults.Columns columns, QueryResults.Statistics statistics, List<Object[]> tuples) {
        this(columns, statistics, tuples, NO_PROBLEMS, null);
    }

    public QueryResults(QueryResults.Columns columns, QueryResults.Statistics statistics, Problems problems) {
        this(columns, statistics, Collections.emptyList(), problems, null);
    }

    public QueryResults(QueryResults.Columns columns, QueryResults.Statistics statistics) {
        this(columns, statistics, Collections.emptyList(), null, null);
    }

    @Override
    public QueryResults.Columns getColumns() {
        return this.columns;
    }

    @Override
    public QueryResults.Cursor getCursor() {
        return new TupleCursor(this.columns, this.tuples.iterator());
    }

    @Override
    public List<Object[]> getTuples() {
        return this.tuples;
    }

    @Override
    public int getRowCount() {
        return this.tuples.size();
    }

    @Override
    public String getPlan() {
        return this.plan;
    }

    @Override
    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public boolean hasErrors() {
        return this.getProblems().hasErrors();
    }

    @Override
    public boolean hasWarnings() {
        return this.getProblems().hasWarnings();
    }

    @Override
    public QueryResults.Statistics getStatistics() {
        return this.statistics;
    }

    public String toString() {
        return this.toString(null, Integer.MAX_VALUE);
    }

    public String toString(TypeSystem typeSystem, int maxTuples) {
        StringBuilder sb = new StringBuilder();
        this.toString(typeSystem, sb, maxTuples);
        return sb.toString();
    }

    public void toString(TypeSystem typeSystem, StringBuilder sb) {
        this.toString(typeSystem, sb, Integer.MAX_VALUE);
    }

    public void toString(TypeSystem typeSystem, StringBuilder sb, int maxTuples) {
        int[] columnWidths = this.determineColumnWidths(typeSystem, Integer.MAX_VALUE, true);
        this.printDelimiterLine(sb, columnWidths, true);
        this.printHeader(sb, columnWidths);
        this.printDelimiterLine(sb, columnWidths, true);
        this.printLines(typeSystem, sb, columnWidths, maxTuples);
        this.printDelimiterLine(sb, columnWidths, false);
    }

    protected int[] determineColumnWidths(TypeSystem typeSystem, int maxWidth, boolean useData) {
        assert (maxWidth > 0);
        int tupleLength = this.columns.getTupleSize();
        int[] columnWidths = new int[tupleLength + 1];
        for (int i = 0; i != columnWidths.length; ++i) {
            columnWidths[i] = 0;
        }
        String rowNumber = Integer.toString(this.getTuples().size());
        columnWidths[0] = rowNumber.length();
        List<String> tupleValueNames = this.columns.getTupleValueNames();
        int i = 0;
        int j = 1;
        int max = tupleValueNames.size();
        while (i != max) {
            String name = tupleValueNames.get(i);
            columnWidths[j] = Math.max(Math.min(maxWidth, name.length()), columnWidths[j]);
            ++i;
            ++j;
        }
        if (useData) {
            for (Object[] tuple : this.getTuples()) {
                int i2 = 0;
                int j2 = 1;
                while (i2 != tupleLength) {
                    String valueStr = this.stringOf(typeSystem, tuple[i2]);
                    if (valueStr != null) {
                        columnWidths[j2] = Math.max(Math.min(maxWidth, valueStr.length()), columnWidths[j2]);
                    }
                    ++i2;
                    ++j2;
                }
            }
        }
        return columnWidths;
    }

    protected String stringOf(TypeSystem typeSystem, Object value) {
        if (value == null) {
            return null;
        }
        if (typeSystem == null) {
            return value.toString();
        }
        TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(value);
        return typeFactory.asReadableString(value);
    }

    protected void printHeader(StringBuilder sb, int[] columnWidths) {
        sb.append("| ").append(StringUtil.justifyLeft((String)"#", (int)columnWidths[0], (char)' ')).append(' ');
        sb.append('|');
        int i = 1;
        for (String name : this.columns.getTupleValueNames()) {
            sb.append(' ');
            sb.append(StringUtil.justifyLeft((String)name, (int)columnWidths[i], (char)' '));
            sb.append(" |");
            ++i;
        }
        sb.append('\n');
    }

    protected void printLines(TypeSystem typeSystem, StringBuilder sb, int[] columnWidths, int maxRowsToPrint) {
        int rowNumber = 1;
        int tupleLength = this.columns.getTupleSize();
        if (maxRowsToPrint > this.tuples.size()) {
            for (Object[] tuple : this.getTuples()) {
                this.printTuple(typeSystem, sb, columnWidths, rowNumber, tupleLength, tuple);
                ++rowNumber;
            }
        } else {
            for (Object[] tuple : this.getTuples()) {
                this.printTuple(typeSystem, sb, columnWidths, rowNumber, tupleLength, tuple);
                if (rowNumber < maxRowsToPrint) {
                    ++rowNumber;
                    continue;
                }
                break;
            }
        }
    }

    private final void printTuple(TypeSystem typeSystem, StringBuilder sb, int[] columnWidths, int rowNumber, int tupleLength, Object[] tuple) {
        sb.append("| ").append(StringUtil.justifyLeft((String)Integer.toString(rowNumber), (int)columnWidths[0], (char)' ')).append(' ');
        int i = 0;
        int j = 1;
        while (i != tupleLength) {
            String valueStr = this.stringOf(typeSystem, tuple[i]);
            valueStr = StringUtil.justifyLeft((String)valueStr, (int)columnWidths[j], (char)' ');
            sb.append('|').append(' ').append(valueStr).append(' ');
            ++i;
            ++j;
        }
        sb.append('|');
        sb.append('\n');
    }

    protected void printDelimiterLine(StringBuilder sb, int[] columnWidths, boolean includeLineFeed) {
        sb.append('+');
        int max = columnWidths.length;
        for (int i = 0; i != max; ++i) {
            int width = columnWidths[i] + 2;
            for (int j = 0; j != width; ++j) {
                sb.append('-');
            }
            sb.append('+');
        }
        if (includeLineFeed) {
            sb.append('\n');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TupleCursor
    implements QueryResults.Cursor {
        private final QueryResults.Columns columns;
        private final Iterator<Object[]> iterator;
        private Object[] currentTuple;
        private int tupleIndex;

        protected TupleCursor(QueryResults.Columns columns, Iterator<Object[]> iterator) {
            this.iterator = iterator;
            this.columns = columns;
            this.tupleIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void next() {
            this.currentTuple = this.iterator.next();
            ++this.tupleIndex;
        }

        @Override
        public Location getLocation(int columnNumber) {
            return (Location)this.currentTuple[this.columns.getLocationIndexForColumn(columnNumber)];
        }

        @Override
        public Location getLocation(String selectorName) {
            return (Location)this.currentTuple[this.columns.getLocationIndex(selectorName)];
        }

        @Override
        public int getRowIndex() {
            return this.tupleIndex;
        }

        @Override
        public Object getValue(int columnNumber) {
            if (columnNumber >= this.columns.getColumnCount()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.currentTuple == null) {
                throw new IllegalStateException(GraphI18n.nextMethodMustBeCalledBeforeGettingValue.text(new Object[0]));
            }
            return this.currentTuple[columnNumber];
        }

        @Override
        public Object getValue(String columnName) {
            if (this.currentTuple == null) {
                throw new IllegalStateException(GraphI18n.nextMethodMustBeCalledBeforeGettingValue.text(new Object[0]));
            }
            return this.currentTuple[this.columns.getColumnIndexForName(columnName)];
        }
    }
}

