/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.QueryResults;
import org.jboss.dna.graph.query.model.Order;
import org.jboss.dna.graph.query.model.Ordering;
import org.jboss.dna.graph.query.model.TypeSystem;
import org.jboss.dna.graph.query.process.DelegatingComponent;
import org.jboss.dna.graph.query.process.ProcessingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortValuesComponent
extends DelegatingComponent {
    private final Comparator<Object[]> sortingComparator;

    public SortValuesComponent(ProcessingComponent delegate, List<Ordering> orderings) {
        super(delegate);
        this.sortingComparator = this.createSortComparator(delegate.getContext(), delegate.getColumns(), orderings);
    }

    public Comparator<Object[]> getSortingComparator() {
        return this.sortingComparator;
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (tuples.size() > 1 && this.sortingComparator != null) {
            Collections.sort(tuples, this.sortingComparator);
        }
        return tuples;
    }

    protected Comparator<Object[]> createSortComparator(QueryContext context, QueryResults.Columns columns, List<Ordering> orderings) {
        assert (context != null);
        assert (orderings != null);
        if (orderings.isEmpty()) {
            return null;
        }
        if (orderings.size() == 1) {
            return this.createSortComparator(context, columns, orderings.get(0));
        }
        final ArrayList<Comparator<Object[]>> comparators = new ArrayList<Comparator<Object[]>>(orderings.size());
        for (Ordering ordering : orderings) {
            comparators.add(this.createSortComparator(context, columns, ordering));
        }
        return new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tuple1, Object[] tuple2) {
                for (Comparator comparator : comparators) {
                    int result = comparator.compare(tuple1, tuple2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }

    protected Comparator<Object[]> createSortComparator(QueryContext context, QueryResults.Columns columns, Ordering ordering) {
        assert (context != null);
        assert (ordering != null);
        final ProcessingComponent.DynamicOperation operation = this.createDynamicOperation(context.getTypeSystem(), context.getSchemata(), columns, ordering.getOperand());
        TypeSystem typeSystem = context.getTypeSystem();
        final TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(operation.getExpectedType());
        assert (typeFactory != null);
        final Comparator<?> typeComparator = typeFactory.getComparator();
        assert (typeComparator != null);
        if (ordering.getOrder() == Order.DESCENDING) {
            return new Comparator<Object[]>(){

                @Override
                public int compare(Object[] tuple1, Object[] tuple2) {
                    Object value1 = typeFactory.create(operation.evaluate(tuple1));
                    Object value2 = typeFactory.create(operation.evaluate(tuple2));
                    return 0 - typeComparator.compare(value1, value2);
                }
            };
        }
        return new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tuple1, Object[] tuple2) {
                Object value1 = typeFactory.create(operation.evaluate(tuple1));
                Object value2 = typeFactory.create(operation.evaluate(tuple2));
                return typeComparator.compare(value1, value2);
            }
        };
    }
}

