/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.query.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.query.QueryContext;
import org.jboss.dna.graph.query.model.Column;
import org.jboss.dna.graph.query.model.QueryCommand;
import org.jboss.dna.graph.query.model.SelectorName;
import org.jboss.dna.graph.query.model.TypeSystem;
import org.jboss.dna.graph.query.model.Visitors;
import org.jboss.dna.graph.query.parse.InvalidQueryException;
import org.jboss.dna.graph.query.parse.SqlQueryParser;
import org.jboss.dna.graph.query.plan.CanonicalPlanner;
import org.jboss.dna.graph.query.plan.PlanNode;
import org.jboss.dna.graph.query.validate.ImmutableColumn;
import org.jboss.dna.graph.query.validate.ImmutableTable;
import org.jboss.dna.graph.query.validate.ImmutableView;
import org.jboss.dna.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class ImmutableSchemata
implements Schemata {
    private final Map<SelectorName, Schemata.Table> tables;

    public static Builder createBuilder(TypeSystem typeSystem) {
        CheckArg.isNotNull((Object)typeSystem, (String)"typeSystem");
        return new Builder(typeSystem);
    }

    protected ImmutableSchemata(Map<SelectorName, Schemata.Table> tables) {
        this.tables = Collections.unmodifiableMap(tables);
    }

    @Override
    public Schemata.Table getTable(SelectorName name) {
        return this.tables.get(name);
    }

    public ImmutableSchemata with(Schemata.Table table) {
        HashMap<SelectorName, Schemata.Table> tables = new HashMap<SelectorName, Schemata.Table>(this.tables);
        tables.put(table.getName(), table);
        return new ImmutableSchemata(tables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Schemata.Table table : this.tables.values()) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(table);
        }
        return sb.toString();
    }

    @NotThreadSafe
    public static class Builder {
        private final TypeSystem typeSystem;
        private final Map<SelectorName, ImmutableTable> tables = new HashMap<SelectorName, ImmutableTable>();
        private final Map<SelectorName, QueryCommand> viewDefinitions = new HashMap<SelectorName, QueryCommand>();

        protected Builder(TypeSystem typeSystem) {
            this.typeSystem = typeSystem;
        }

        public Builder addTable(String name, String ... columnNames) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            CheckArg.isNotEmpty((Object[])columnNames, (String)"columnNames");
            ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
            int i = 0;
            for (String columnName : columnNames) {
                CheckArg.isNotEmpty((String)columnName, (String)("columnName[" + i++ + "]"));
                columns.add(new ImmutableColumn(columnName, this.typeSystem.getDefaultType()));
            }
            ImmutableTable table = new ImmutableTable(new SelectorName(name), columns);
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder addTable(String name, String[] columnNames, String[] types) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            CheckArg.isNotEmpty((Object[])columnNames, (String)"columnNames");
            CheckArg.isNotEmpty((Object[])types, (String)"types");
            CheckArg.isEquals((Object)columnNames.length, (String)"columnNames.length", (Object)types.length, (String)"types.length");
            ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
            assert (columnNames.length == types.length);
            for (int i = 0; i != columnNames.length; ++i) {
                String columnName = columnNames[i];
                CheckArg.isNotEmpty((String)columnName, (String)("columnName[" + i + "]"));
                columns.add(new ImmutableColumn(columnName, types[i]));
            }
            ImmutableTable table = new ImmutableTable(new SelectorName(name), columns);
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder addView(String name, String definition) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            CheckArg.isNotEmpty((String)definition, (String)"definition");
            SqlQueryParser parser = new SqlQueryParser();
            QueryCommand command = parser.parseQuery(definition, this.typeSystem);
            this.viewDefinitions.put(new SelectorName(name), command);
            return this;
        }

        public Builder addView(String name, QueryCommand definition) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            CheckArg.isNotNull((Object)definition, (String)"definition");
            this.viewDefinitions.put(new SelectorName(name), definition);
            return this;
        }

        public Builder addColumn(String tableName, String columnName, String type) {
            CheckArg.isNotEmpty((String)tableName, (String)"tableName");
            CheckArg.isNotEmpty((String)columnName, (String)"columnName");
            CheckArg.isNotNull((Object)type, (String)"type");
            return this.addColumn(tableName, columnName, type, false);
        }

        public Builder addColumn(String tableName, String columnName, String type, boolean fullTextSearchable) {
            CheckArg.isNotEmpty((String)tableName, (String)"tableName");
            CheckArg.isNotEmpty((String)columnName, (String)"columnName");
            CheckArg.isNotNull((Object)type, (String)"type");
            SelectorName selector = new SelectorName(tableName);
            ImmutableTable existing = this.tables.get(selector);
            ImmutableTable table = null;
            if (existing == null) {
                ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
                columns.add(new ImmutableColumn(columnName, type, fullTextSearchable));
                table = new ImmutableTable(selector, columns);
            } else {
                table = existing.withColumn(columnName, type);
            }
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder makeSearchable(String tableName, String columnName) {
            CheckArg.isNotEmpty((String)tableName, (String)"tableName");
            CheckArg.isNotEmpty((String)columnName, (String)"columnName");
            SelectorName selector = new SelectorName(tableName);
            ImmutableTable existing = this.tables.get(selector);
            ImmutableTable table = null;
            if (existing == null) {
                ArrayList<Schemata.Column> columns = new ArrayList<Schemata.Column>();
                columns.add(new ImmutableColumn(columnName, this.typeSystem.getDefaultType(), true));
                table = new ImmutableTable(selector, columns);
            } else {
                Schemata.Column column = existing.getColumn(columnName);
                String type = this.typeSystem.getDefaultType();
                if (column != null) {
                    type = column.getPropertyType();
                }
                table = existing.withColumn(columnName, type, true);
            }
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder addKey(String tableName, String ... columnNames) {
            CheckArg.isNotEmpty((String)tableName, (String)"tableName");
            CheckArg.isNotEmpty((Object[])columnNames, (String)"columnNames");
            ImmutableTable existing = this.tables.get(new SelectorName(tableName));
            if (existing == null) {
                throw new IllegalArgumentException(GraphI18n.tableDoesNotExist.text(new Object[]{tableName}));
            }
            HashSet<Schemata.Column> keyColumns = new HashSet<Schemata.Column>();
            for (String columnName : columnNames) {
                Schemata.Column existingColumn = existing.getColumnsByName().get(columnName);
                if (existingColumn == null) {
                    String msg = GraphI18n.schemataKeyReferencesNonExistingColumn.text(new Object[]{tableName, columnName});
                    throw new IllegalArgumentException(msg);
                }
                keyColumns.add(existingColumn);
            }
            ImmutableTable table = existing.withKey(keyColumns);
            this.tables.put(table.getName(), table);
            return this;
        }

        public Schemata build() {
            ImmutableSchemata schemata = new ImmutableSchemata(new HashMap<SelectorName, Schemata.Table>(this.tables));
            HashMap<SelectorName, QueryCommand> definitions = new HashMap<SelectorName, QueryCommand>(this.viewDefinitions);
            boolean added = false;
            do {
                added = false;
                HashSet viewNames = new HashSet(definitions.keySet());
                for (SelectorName name : viewNames) {
                    Column column;
                    Schemata.Table source;
                    QueryCommand command = (QueryCommand)definitions.get(name);
                    QueryContext queryContext = new QueryContext(schemata, this.typeSystem);
                    CanonicalPlanner planner = new CanonicalPlanner();
                    PlanNode plan = planner.createPlan(queryContext, command);
                    if (queryContext.getProblems().hasErrors()) continue;
                    PlanNode project = plan.findAtOrBelow(PlanNode.Type.PROJECT);
                    assert (project != null);
                    List<Column> columns = project.getPropertyAsList(PlanNode.Property.PROJECT_COLUMNS, Column.class);
                    assert (!columns.isEmpty());
                    ArrayList<Schemata.Column> viewColumns = new ArrayList<Schemata.Column>(columns.size());
                    Iterator<Column> i$ = columns.iterator();
                    while (i$.hasNext() && (source = schemata.getTable((column = i$.next()).getSelectorName())) != null) {
                        String viewColumnName = column.getColumnName();
                        String sourceColumnName = column.getPropertyName();
                        Schemata.Column sourceColumn = source.getColumn(sourceColumnName);
                        if (sourceColumn == null) {
                            throw new InvalidQueryException(Visitors.readable(command), "The view references a non-existant column '" + column.getColumnName() + "' in '" + source.getName() + "'");
                        }
                        viewColumns.add(new ImmutableColumn(viewColumnName, sourceColumn.getPropertyType(), sourceColumn.isFullTextSearchable()));
                    }
                    if (viewColumns.size() != columns.size()) continue;
                    ImmutableView view = new ImmutableView(name, viewColumns, command);
                    definitions.remove(name);
                    schemata = schemata.with(view);
                    added = true;
                }
            } while (added && !definitions.isEmpty());
            if (!definitions.isEmpty()) {
                QueryCommand command = (QueryCommand)definitions.values().iterator().next();
                throw new InvalidQueryException(Visitors.readable(command), "The view definition cannot be resolved: " + Visitors.readable(command));
            }
            return schemata;
        }
    }
}

