/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import java.util.Collections;
import java.util.Set;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final String fromWorkspace;
    private final String intoWorkspace;
    private final Location from;
    private final Location into;
    private final Name desiredName;
    private final Path.Segment desiredSegment;
    private final boolean removeExisting;
    private Set<Location> removedExistingNodes;
    private Location actualFromLocation;
    private Location actualIntoLocation;

    public CloneBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForClone, Path.Segment exactSegmentForClone, boolean removeExisting) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)into, (String)"into");
        CheckArg.isNotNull((Object)fromWorkspace, (String)"fromWorkspace");
        CheckArg.isNotNull((Object)intoWorkspace, (String)"intoWorkspace");
        CheckArg.isNotSame((Object)from, (String)fromWorkspace, (Object)into, (String)intoWorkspace);
        assert (nameForClone != null ? exactSegmentForClone == null : exactSegmentForClone != null);
        this.from = from;
        this.into = into;
        this.fromWorkspace = fromWorkspace;
        this.intoWorkspace = intoWorkspace;
        this.desiredName = nameForClone;
        this.desiredSegment = exactSegmentForClone;
        this.removeExisting = removeExisting;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public String fromWorkspace() {
        return this.fromWorkspace;
    }

    public String intoWorkspace() {
        return this.intoWorkspace;
    }

    public boolean isSameWorkspace() {
        return false;
    }

    public Name desiredName() {
        return this.desiredName;
    }

    public Path.Segment desiredSegment() {
        return this.desiredSegment;
    }

    public boolean removeExisting() {
        return this.removeExisting;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocations(Location fromLocation, Location intoLocation) {
        this.checkNotFrozen();
        if (!this.from.equals(fromLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{fromLocation, this.from}));
        }
        CheckArg.isNotNull((Object)intoLocation, (String)"intoLocation");
        assert (fromLocation != null);
        assert (intoLocation != null);
        if (!fromLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{fromLocation}));
        }
        if (!intoLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{intoLocation}));
        }
        if (this.into.hasPath() && !intoLocation.getPath().getParent().equals(this.into.getPath())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotChildOfInputLocation.text(new Object[]{intoLocation, this.into}));
        }
        if (this.desiredSegment != null && !this.desiredSegment.equals(intoLocation.getPath().getLastSegment())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotAtCorrectChildSegment.text(new Object[]{intoLocation, this.desiredSegment}));
        }
        if (this.desiredName != null && !this.desiredName.equals(intoLocation.getPath().getLastSegment().getName())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationDoesNotHaveCorrectChildName.text(new Object[]{intoLocation, this.desiredName}));
        }
        this.actualFromLocation = fromLocation;
        this.actualIntoLocation = intoLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualFromLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualIntoLocation;
    }

    public void setRemovedNodes(Set<Location> existingNodesThatWereRemoved) {
        this.removedExistingNodes = existingNodesThatWereRemoved;
    }

    public Set<Location> getRemovedNodes() {
        return this.removedExistingNodes != null ? this.removedExistingNodes : Collections.emptySet();
    }

    @Override
    public boolean changes(String workspace, Path path) {
        return this.into.hasPath() && this.into.getPath().isAtOrBelow(path);
    }

    @Override
    public Location changedLocation() {
        return this.actualIntoLocation != null ? this.actualIntoLocation : this.into;
    }

    @Override
    public String changedWorkspace() {
        return this.intoWorkspace();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.from, this.fromWorkspace, this.into, this.intoWorkspace});
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualFromLocation = null;
        this.actualIntoLocation = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CloneBranchRequest that = (CloneBranchRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.into().isSame(that.into())) {
                return false;
            }
            if (!this.fromWorkspace.equals(that.fromWorkspace)) {
                return false;
            }
            return this.intoWorkspace.equals(that.intoWorkspace);
        }
        return false;
    }

    public String toString() {
        if (this.desiredName != null) {
            return "clone branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredName + " in the \"" + this.intoWorkspace + "\" workspace";
        }
        return "clone branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " in the \"" + this.intoWorkspace + "\" workspace as child " + this.desiredSegment();
    }

    @Override
    public CloneBranchRequest clone() {
        CloneBranchRequest result = new CloneBranchRequest(this.actualFromLocation != null ? this.actualFromLocation : this.from, this.fromWorkspace, this.actualIntoLocation != null ? this.actualIntoLocation : this.into, this.intoWorkspace, this.desiredName, this.desiredSegment, this.removeExisting);
        result.setRemovedNodes(this.removedExistingNodes);
        result.setActualLocations(this.actualFromLocation, this.actualIntoLocation);
        return result;
    }
}

