/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.NodeConflictBehavior;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;

public class CopyBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    public static final NodeConflictBehavior DEFAULT_NODE_CONFLICT_BEHAVIOR = NodeConflictBehavior.APPEND;
    private final Location from;
    private final Location into;
    private final String fromWorkspace;
    private final String intoWorkspace;
    private final Name desiredNameForCopy;
    private final NodeConflictBehavior nodeConflictBehavior;
    private Location actualFromLocation;
    private Location actualIntoLocation;

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace) {
        this(from, fromWorkspace, into, intoWorkspace, null, DEFAULT_NODE_CONFLICT_BEHAVIOR);
    }

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy) {
        this(from, fromWorkspace, into, intoWorkspace, nameForCopy, DEFAULT_NODE_CONFLICT_BEHAVIOR);
    }

    public CopyBranchRequest(Location from, String fromWorkspace, Location into, String intoWorkspace, Name nameForCopy, NodeConflictBehavior nodeConflictBehavior) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)into, (String)"into");
        CheckArg.isNotNull((Object)fromWorkspace, (String)"fromWorkspace");
        CheckArg.isNotNull((Object)intoWorkspace, (String)"intoWorkspace");
        CheckArg.isNotNull((Object)((Object)nodeConflictBehavior), (String)"nodeConflictBehavior");
        this.from = from;
        this.into = into;
        this.fromWorkspace = fromWorkspace;
        this.intoWorkspace = intoWorkspace;
        this.desiredNameForCopy = nameForCopy;
        this.nodeConflictBehavior = nodeConflictBehavior;
    }

    public Location from() {
        return this.from;
    }

    public Location into() {
        return this.into;
    }

    public String fromWorkspace() {
        return this.fromWorkspace;
    }

    public String intoWorkspace() {
        return this.intoWorkspace;
    }

    public boolean isSameWorkspace() {
        return this.fromWorkspace.equals(this.intoWorkspace);
    }

    public Name desiredName() {
        return this.desiredNameForCopy;
    }

    public boolean isReadOnly() {
        return false;
    }

    public NodeConflictBehavior nodeConflictBehavior() {
        return this.nodeConflictBehavior;
    }

    public void setActualLocations(Location fromLocation, Location intoLocation) {
        this.checkNotFrozen();
        if (!this.from.equals(fromLocation)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{fromLocation, this.from}));
        }
        CheckArg.isNotNull((Object)intoLocation, (String)"intoLocation");
        assert (fromLocation != null);
        assert (intoLocation != null);
        if (!fromLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualOldLocationMustHavePath.text(new Object[]{fromLocation}));
        }
        if (!intoLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualNewLocationMustHavePath.text(new Object[]{intoLocation}));
        }
        if (this.into.hasPath() && !intoLocation.getPath().getParent().equals(this.into.getPath())) {
            throw new IllegalArgumentException(GraphI18n.actualLocationIsNotChildOfInputLocation.text(new Object[]{intoLocation, this.into}));
        }
        this.actualFromLocation = fromLocation;
        this.actualIntoLocation = intoLocation;
    }

    public Location getActualLocationBefore() {
        return this.actualFromLocation;
    }

    public Location getActualLocationAfter() {
        return this.actualIntoLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.intoWorkspace.equals(workspace) && this.into.hasPath() && this.into.getPath().isAtOrBelow(path);
    }

    public Location changedLocation() {
        return this.actualIntoLocation != null ? this.actualIntoLocation : this.into;
    }

    public String changedWorkspace() {
        return this.intoWorkspace();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.from, this.fromWorkspace, this.into, this.intoWorkspace});
    }

    public void cancel() {
        super.cancel();
        this.actualFromLocation = null;
        this.actualIntoLocation = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            CopyBranchRequest that = (CopyBranchRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.into().isSame(that.into())) {
                return false;
            }
            if (!this.nodeConflictBehavior().equals((Object)that.nodeConflictBehavior())) {
                return false;
            }
            if (!this.fromWorkspace.equals(that.fromWorkspace)) {
                return false;
            }
            return this.intoWorkspace.equals(that.intoWorkspace);
        }
        return false;
    }

    public String toString() {
        if (this.fromWorkspace.equals(this.intoWorkspace)) {
            if (this.desiredNameForCopy != null) {
                return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredNameForCopy;
            }
            return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into();
        }
        if (this.desiredNameForCopy != null) {
            return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " with name " + this.desiredNameForCopy + " in the \"" + this.intoWorkspace + "\" workspace";
        }
        return "copy branch " + this.from() + " in the \"" + this.fromWorkspace + "\" workspace into " + this.into() + " in the \"" + this.intoWorkspace + "\" workspace";
    }

    public CopyBranchRequest clone() {
        CopyBranchRequest result = new CopyBranchRequest(this.actualFromLocation != null ? this.actualFromLocation : this.from, this.fromWorkspace, this.actualIntoLocation != null ? this.actualIntoLocation : this.into, this.intoWorkspace, this.desiredNameForCopy, this.nodeConflictBehavior);
        result.setActualLocations(this.actualFromLocation, this.actualIntoLocation);
        return result;
    }
}

