/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;

public final class DestroyWorkspaceRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private Location actualLocationOfRoot;

    public DestroyWorkspaceRequest(String workspaceName) {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
    }

    public String workspaceName() {
        return this.workspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.checkNotFrozen();
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    public boolean isReadOnly() {
        return false;
    }

    public int hashCode() {
        return this.workspaceName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            DestroyWorkspaceRequest that = (DestroyWorkspaceRequest)obj;
            return this.workspaceName.equals(that.workspaceName());
        }
        return false;
    }

    public String toString() {
        return "destroy workspace \"" + this.workspaceName() + "\"";
    }

    public Location changedLocation() {
        return this.actualLocationOfRoot;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName().equals(workspace);
    }

    public DestroyWorkspaceRequest clone() {
        return new DestroyWorkspaceRequest(this.workspaceName);
    }
}

