/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request;

import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.request.ChangeRequest;

public class RemovePropertyRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location from;
    private final String workspaceName;
    private final Name propertyName;
    private Location actualLocation;

    public RemovePropertyRequest(Location from, String workspaceName, Name propertyName) {
        CheckArg.isNotNull((Object)from, (String)"from");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.from = from;
        this.propertyName = propertyName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Location from() {
        return this.from;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name propertyName() {
        return this.propertyName;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        if (!this.from.equals(actual)) {
            throw new IllegalArgumentException(GraphI18n.actualLocationNotEqualToInputLocation.text(new Object[]{actual, this.from}));
        }
        assert (actual != null);
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.from.hasPath() && this.from.getPath().isAtOrBelow(path);
    }

    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.from, this.workspaceName, this.propertyName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            RemovePropertyRequest that = (RemovePropertyRequest)obj;
            if (!this.from().isSame(that.from())) {
                return false;
            }
            if (!this.propertyName().equals(that.propertyName())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.from;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public String toString() {
        return "remove property " + this.propertyName() + " from " + this.from() + " in the \"" + this.workspaceName + "\" workspace";
    }

    public RemovePropertyRequest clone() {
        RemovePropertyRequest request = new RemovePropertyRequest(this.actualLocation != null ? this.actualLocation : this.from, this.workspaceName, this.propertyName);
        request.setActualLocationOfNode(this.actualLocation);
        return request;
    }
}

