/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.request.processor;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.CloneBranchRequest;
import org.jboss.dna.graph.request.CloneWorkspaceRequest;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.CopyBranchRequest;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.CreateWorkspaceRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.DestroyWorkspaceRequest;
import org.jboss.dna.graph.request.FullTextSearchRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.LockBranchRequest;
import org.jboss.dna.graph.request.MoveBranchRequest;
import org.jboss.dna.graph.request.ReadAllChildrenRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadBranchRequest;
import org.jboss.dna.graph.request.ReadNextBlockOfChildrenRequest;
import org.jboss.dna.graph.request.ReadNodeRequest;
import org.jboss.dna.graph.request.ReadPropertyRequest;
import org.jboss.dna.graph.request.RemovePropertyRequest;
import org.jboss.dna.graph.request.RenameNodeRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.SetPropertyRequest;
import org.jboss.dna.graph.request.UnlockBranchRequest;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.request.UpdateValuesRequest;
import org.jboss.dna.graph.request.VerifyNodeExistsRequest;
import org.jboss.dna.graph.request.VerifyWorkspaceRequest;
import org.jboss.dna.graph.request.processor.RequestProcessor;

@Immutable
public class LoggingRequestProcessor
extends RequestProcessor {
    private final RequestProcessor delegate;
    private final Logger logger;
    private final Logger.Level level;

    public LoggingRequestProcessor(RequestProcessor delegate, Logger logger, Logger.Level level) {
        super(delegate.getSourceName(), delegate.getExecutionContext(), null);
        CheckArg.isNotNull((Object)logger, (String)"logger");
        this.delegate = delegate;
        this.logger = logger;
        this.level = level != null ? level : Logger.Level.TRACE;
    }

    public void process(VerifyWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
    }

    public void process(GetWorkspacesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CreateWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CloneBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CloneWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DestroyWorkspaceRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CopyBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CreateNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DeleteBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(DeleteChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(MoveBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(VerifyNodeExistsRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadAllPropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UpdatePropertiesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UpdateValuesRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(CompositeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(ReadPropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(SetPropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RemovePropertyRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(RenameNodeRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(LockBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(UnlockBranchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(AccessQueryRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(FullTextSearchRequest request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void process(Request request) {
        this.logger.log(this.level, GraphI18n.executingRequest, new Object[]{request});
        this.delegate.process(request);
        this.logger.log(this.level, GraphI18n.executedRequest, new Object[]{request});
    }

    public void close() {
        this.logger.log(this.level, GraphI18n.closingRequestProcessor, new Object[0]);
        this.delegate.close();
        this.logger.log(this.level, GraphI18n.closedRequestProcessor, new Object[0]);
    }
}

