/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.search;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.NamedThreadFactory;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.property.InvalidPathException;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.request.ChangeRequest;
import org.jboss.dna.graph.request.CompositeRequestChannel;
import org.jboss.dna.graph.request.CreateNodeRequest;
import org.jboss.dna.graph.request.DeleteBranchRequest;
import org.jboss.dna.graph.request.DeleteChildrenRequest;
import org.jboss.dna.graph.request.GetWorkspacesRequest;
import org.jboss.dna.graph.request.ReadAllPropertiesRequest;
import org.jboss.dna.graph.request.ReadBranchRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.UpdatePropertiesRequest;
import org.jboss.dna.graph.search.SearchEngine;
import org.jboss.dna.graph.search.SearchEngineException;
import org.jboss.dna.graph.search.SearchEngineProcessor;

@NotThreadSafe
public class SearchEngineIndexer {
    protected static final int DEFAULT_MAX_DEPTH_PER_READ = 100;
    private final ExecutionContext context;
    private final RepositoryConnectionFactory connectionFactory;
    private final String sourceName;
    private final SearchEngine searchEngine;
    private final int maxDepthPerRead = 100;
    private final ExecutorService service;
    private final CompositeRequestChannel channel;
    private final SearchEngineProcessor processor;
    private boolean closed = false;

    public SearchEngineIndexer(ExecutionContext context, SearchEngine searchEngine, RepositoryConnectionFactory connectionFactory) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        this.context = context;
        this.searchEngine = searchEngine;
        this.sourceName = searchEngine.getSourceName();
        this.connectionFactory = connectionFactory;
        this.channel = new CompositeRequestChannel(this.sourceName);
        this.service = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("search-" + this.sourceName));
        this.channel.start(this.service, this.context, this.connectionFactory);
        this.processor = this.searchEngine.createProcessor(this.context, null, false);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public SearchEngineIndexer index(String workspaceName) throws RepositorySourceException, SearchEngineException {
        Path rootPath = this.context.getValueFactories().getPathFactory().createRootPath();
        this.index(workspaceName, Location.create(rootPath));
        return this;
    }

    public SearchEngineIndexer indexAllWorkspaces() throws RepositorySourceException, SearchEngineException {
        GetWorkspacesRequest getWorkspaces = new GetWorkspacesRequest();
        try {
            this.channel.addAndAwait(getWorkspaces);
            this.checkRequestForErrors(getWorkspaces);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return this;
        }
        Path rootPath = this.context.getValueFactories().getPathFactory().createRootPath();
        Location rootLocation = Location.create(rootPath);
        for (String workspaceName : getWorkspaces.getAvailableWorkspaceNames()) {
            this.index(workspaceName, rootLocation);
        }
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Path path) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)path, (String)"path");
        this.indexSubgraph(workspaceName, Location.create(path), Integer.MAX_VALUE);
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Path path, int depth) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isPositive((int)depth, (String)"depth");
        if (depth == 1) {
            this.indexProperties(workspaceName, Location.create(path));
        } else {
            this.indexSubgraph(workspaceName, Location.create(path), depth);
        }
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Location location) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)location, (String)"location");
        this.indexSubgraph(workspaceName, location, Integer.MAX_VALUE);
        return this;
    }

    public SearchEngineIndexer index(String workspaceName, Location location, int depth) {
        this.checkNotClosed();
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        CheckArg.isNotNull((Object)location, (String)"location");
        CheckArg.isPositive((int)depth, (String)"depth");
        if (depth == 1) {
            this.indexProperties(workspaceName, location);
        } else {
            this.indexSubgraph(workspaceName, location, depth);
        }
        return this;
    }

    protected void indexSubgraph(String workspaceName, Location startingLocation, int depth) {
        int depthPerRead = Math.min(100, depth);
        ReadBranchRequest readSubgraph = new ReadBranchRequest(startingLocation, workspaceName, depthPerRead);
        try {
            this.channel.addAndAwait(readSubgraph);
            this.checkRequestForErrors(readSubgraph);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return;
        }
        catch (InvalidPathException e) {
            this.process(new DeleteBranchRequest(startingLocation, workspaceName));
            return;
        }
        Iterator<Location> locationIter = readSubgraph.iterator();
        assert (locationIter.hasNext());
        if (startingLocation.getPath().isRoot()) {
            this.process(new DeleteBranchRequest(startingLocation, workspaceName));
        } else {
            this.process(new DeleteChildrenRequest(startingLocation, workspaceName));
        }
        Location topNode = locationIter.next();
        assert (topNode.equals(startingLocation));
        Map<Name, Property> properties = readSubgraph.getPropertiesFor(topNode);
        if (properties == null) {
            return;
        }
        if (startingLocation.getPath().isRoot()) {
            Property rootPrimaryType = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, DnaLexicon.ROOT);
            properties.put(JcrLexicon.PRIMARY_TYPE, rootPrimaryType);
        }
        UpdatePropertiesRequest request = new UpdatePropertiesRequest(topNode, workspaceName, properties, true);
        request.setActualLocationOfNode(topNode);
        this.process(request);
        this.checkRequestForErrors(request);
        LinkedList<Location> locationsToRead = new LinkedList<Location>();
        block5: while (true) {
            Location location;
            if (locationIter.hasNext()) {
                location = locationIter.next();
                Path path = location.getPath();
                Location parent = readSubgraph.getLocationFor(path.getParent());
                Name childName = path.getLastSegment().getName();
                Collection<Property> nodePoperties = readSubgraph.getPropertiesFor(location).values();
                CreateNodeRequest create = new CreateNodeRequest(parent, workspaceName, childName, nodePoperties);
                create.setActualLocationOfNode(location);
                this.process(create);
                if (create.isCancelled() || create.hasError()) {
                    return;
                }
                Iterator<Location> i$ = readSubgraph.getChildren(location).iterator();
                while (true) {
                    if (!i$.hasNext()) continue block5;
                    Location child = i$.next();
                    if (readSubgraph.includes(child)) continue;
                    locationsToRead.add(child);
                }
            }
            if (locationsToRead.isEmpty()) break;
            location = (Location)locationsToRead.poll();
            assert (location != null);
            depthPerRead = depth - location.getPath().size();
            if (depthPerRead < 1) continue;
            readSubgraph = new ReadBranchRequest(location, workspaceName, depthPerRead);
            try {
                this.channel.addAndAwait(readSubgraph);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
            this.checkRequestForErrors(readSubgraph);
        }
    }

    protected void indexProperties(String workspaceName, Location location) {
        ReadAllPropertiesRequest readProps = new ReadAllPropertiesRequest(location, workspaceName);
        try {
            this.channel.addAndAwait(readProps);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        this.checkRequestForErrors(readProps);
        location = readProps.getActualLocationOfNode();
        Map<Name, Property> properties = readProps.getPropertiesByName();
        UpdatePropertiesRequest request = new UpdatePropertiesRequest(location, workspaceName, properties, true);
        request.setActualLocationOfNode(location);
        this.process(request);
        this.checkRequestForErrors(readProps);
    }

    public final void process(ChangeRequest searchEngineRequest) {
        this.processor.process(searchEngineRequest);
    }

    protected final void checkRequestForErrors(Request request) throws RepositorySourceException, RuntimeException {
        if (request.hasError()) {
            Throwable t = request.getError();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RepositorySourceException(this.sourceName, t);
        }
    }

    protected final void checkNotClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException(GraphI18n.searchEngineIndexerForSourceHasAlreadyBeenClosed.text(new Object[]{this.sourceName}));
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object v1;
        block9: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.channel.close();
                Object var2_1 = null;
                this.service.shutdown();
            }
            catch (Throwable throwable) {
                Object v0;
                Object var2_2 = null;
                this.service.shutdown();
                try {
                    try {
                        this.service.awaitTermination(5L, TimeUnit.SECONDS);
                        v0 = null;
                    }
                    catch (InterruptedException e) {
                        I18n msg = GraphI18n.errorShuttingDownExecutorServiceInSearchEngineIndexer;
                        Logger.getLogger(this.getClass()).error(msg, new Object[]{this.sourceName});
                        Thread.interrupted();
                        v0 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_10 = v0;
                this.processor.close();
                throw throwable;
            }
            try {
                try {
                    this.service.awaitTermination(5L, TimeUnit.SECONDS);
                    v1 = null;
                }
                catch (InterruptedException e) {
                    I18n msg = GraphI18n.errorShuttingDownExecutorServiceInSearchEngineIndexer;
                    Logger.getLogger(this.getClass()).error(msg, new Object[]{this.sourceName});
                    Thread.interrupted();
                    v1 = null;
                }
                break block9;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_9 = v1;
        this.processor.close();
    }
}

