/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.graph.search;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.GraphI18n;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.cache.CachePolicy;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.RepositorySourceCapabilities;
import org.jboss.dna.graph.connector.RepositorySourceException;
import org.jboss.dna.graph.observe.Changes;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.request.AccessQueryRequest;
import org.jboss.dna.graph.request.CompositeRequest;
import org.jboss.dna.graph.request.CompositeRequestChannel;
import org.jboss.dna.graph.request.FullTextSearchRequest;
import org.jboss.dna.graph.request.Request;
import org.jboss.dna.graph.request.processor.RequestProcessor;
import org.jboss.dna.graph.search.SearchEngine;
import org.jboss.dna.graph.search.SearchEngineProcessor;

public class SearchableRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = 1L;
    private final RepositorySource delegate;
    private final boolean executeAsynchronously;
    private final boolean updateIndexesAsynchronously;
    private final transient ExecutorService executorService;
    private final transient SearchEngine searchEngine;

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine, ExecutorService executorService, boolean executeAsynchronously, boolean updateIndexesAsynchronously) {
        CheckArg.isNotNull((Object)wrapped, (String)"wrapped");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        this.delegate = wrapped;
        this.executorService = executorService;
        this.searchEngine = searchEngine;
        this.updateIndexesAsynchronously = this.executorService != null && updateIndexesAsynchronously;
        this.executeAsynchronously = this.executorService != null && executeAsynchronously;
    }

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine) {
        this(wrapped, searchEngine, null, false, false);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void close() {
        this.delegate.close();
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new RepositorySourceCapabilities(this.delegate.getCapabilities()){

            public boolean supportsQueries() {
                return true;
            }

            public boolean supportsSearches() {
                return true;
            }
        };
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.executeRequestsAsynchronously()) {
            assert (this.executorService != null);
            return new ParallelConnection(this.executorService);
        }
        return new SynchronousConnection();
    }

    public int getRetryLimit() {
        return this.delegate.getRetryLimit();
    }

    public void initialize(final RepositoryContext context) throws RepositorySourceException {
        final String delegateSourceName = this.delegate.getName();
        final RepositoryConnectionFactory originalConnectionFactory = context.getRepositoryConnectionFactory();
        final RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (delegateSourceName.equals(sourceName)) {
                    return SearchableRepositorySource.this.delegate().getConnection();
                }
                return originalConnectionFactory.createConnection(sourceName);
            }
        };
        final Observer observer = new Observer(){

            public void notify(final Changes changes) {
                if (changes != null) {
                    if (SearchableRepositorySource.this.updateIndexesAsynchronously()) {
                        SearchableRepositorySource.this.executorService().submit(new Runnable(){

                            public void run() {
                                SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                            }
                        });
                    } else {
                        SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                    }
                }
            }
        };
        RepositoryContext newContext = new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return context.getConfiguration(depth);
            }

            public ExecutionContext getExecutionContext() {
                return context.getExecutionContext();
            }

            public Observer getObserver() {
                return observer;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return connectionFactory;
            }
        };
        this.delegate.initialize(newContext);
    }

    protected final SearchEngine searchEngine() {
        assert (this.searchEngine != null);
        return this.searchEngine;
    }

    protected final boolean updateIndexesAsynchronously() {
        return this.executorService != null && this.updateIndexesAsynchronously;
    }

    protected final boolean executeRequestsAsynchronously() {
        return this.executorService != null && this.executeAsynchronously;
    }

    protected final ExecutorService executorService() {
        assert (this.executorService != null);
        return this.executorService;
    }

    protected final RepositorySource delegate() {
        return this.delegate;
    }

    protected void process(ExecutionContext context, Changes changes) {
        assert (context != null);
        assert (changes != null);
        if (this.searchEngine == null) {
            return;
        }
        this.searchEngine.index(context, changes.getChangeRequests());
    }

    public void setRetryLimit(int limit) {
        this.delegate.setRetryLimit(limit);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    @NotThreadSafe
    protected class SynchronousConnection
    extends AbstractConnection {
        protected SynchronousConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            if (request instanceof AccessQueryRequest) {
                AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                SearchEngineProcessor searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                try {
                    searchProcessor.process(queryRequest);
                    Object var6_9 = null;
                    ((RequestProcessor)searchProcessor).close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    ((RequestProcessor)searchProcessor).close();
                    throw throwable;
                }
            } else if (request instanceof FullTextSearchRequest) {
                FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                SearchEngineProcessor searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                try {
                    searchProcessor.process(searchRequest);
                    Object var8_18 = null;
                    ((RequestProcessor)searchProcessor).close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var8_19 = null;
                    ((RequestProcessor)searchProcessor).close();
                    throw throwable;
                }
            } else if (request instanceof CompositeRequest) {
                CompositeRequest composite = (CompositeRequest)request;
                LinkedList<Request> delegateRequests = null;
                RequestProcessor searchProcessor = null;
                try {
                    void var6_12;
                    CompositeRequest compositeRequest = composite;
                    for (Request nested : composite) {
                        if (nested instanceof AccessQueryRequest) {
                            AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                            if (searchProcessor == null) {
                                searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                            }
                            searchProcessor.process(queryRequest);
                            Object var6_13 = null;
                            continue;
                        }
                        if (nested instanceof FullTextSearchRequest) {
                            FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                            if (searchProcessor == null) {
                                searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                            }
                            searchProcessor.process(searchRequest);
                            Object var6_14 = null;
                            continue;
                        }
                        if (delegateRequests == null) {
                            delegateRequests = new LinkedList<Request>();
                        }
                        delegateRequests.add(request);
                    }
                    if (var6_12 == null) {
                        if (delegateRequests != null) {
                            assert (!delegateRequests.isEmpty());
                            Request request2 = CompositeRequest.with((List<? extends Request>)delegateRequests);
                            this.delegateConnection().execute(context, request2);
                        }
                    } else {
                        this.delegateConnection().execute(context, request);
                    }
                    Object var11_24 = null;
                    if (searchProcessor == null) return;
                    searchProcessor.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var11_25 = null;
                    if (searchProcessor == null) throw throwable;
                    searchProcessor.close();
                    throw throwable;
                }
            } else {
                this.delegateConnection().execute(context, request);
            }
        }
    }

    @NotThreadSafe
    protected class ParallelConnection
    extends AbstractConnection {
        private final ExecutorService executorService;

        protected ParallelConnection(ExecutorService executorService) {
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            block42: {
                block41: {
                    Object v1;
                    if (request instanceof AccessQueryRequest) {
                        AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                        SearchEngineProcessor searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                        try {
                            searchProcessor.process(queryRequest);
                        }
                        finally {
                            ((RequestProcessor)searchProcessor).close();
                        }
                    }
                    if (request instanceof FullTextSearchRequest) {
                        FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                        SearchEngineProcessor searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                        try {
                            searchProcessor.process(searchRequest);
                        }
                        finally {
                            ((RequestProcessor)searchProcessor).close();
                        }
                    }
                    if (!(request instanceof CompositeRequest)) break block41;
                    CompositeRequest composite = (CompositeRequest)request;
                    CompositeRequestChannel channel = null;
                    RequestProcessor searchProcessor = null;
                    try {
                        for (Request nested : composite) {
                            if (nested instanceof AccessQueryRequest) {
                                AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                                if (searchProcessor == null) {
                                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                }
                                searchProcessor.process(queryRequest);
                                continue;
                            }
                            if (nested instanceof FullTextSearchRequest) {
                                FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                                if (searchProcessor == null) {
                                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                }
                                searchProcessor.process(searchRequest);
                                continue;
                            }
                            if (channel == null) {
                                RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

                                    public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                                        assert (SearchableRepositorySource.this.delegate().getName().equals(sourceName));
                                        return ParallelConnection.this.delegateConnection();
                                    }
                                };
                                channel = new CompositeRequestChannel(SearchableRepositorySource.this.delegate().getName());
                                channel.start(this.executorService, context, connectionFactory);
                            }
                            channel.add(request);
                        }
                        Object var10_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object v0;
                        Object var10_16 = null;
                        try {
                            if (searchProcessor != null) {
                                searchProcessor.close();
                            }
                            v0 = null;
                        }
                        catch (Throwable throwable2) {
                            Object var12_20;
                            v0 = var12_20 = null;
                        }
                        if (channel != null) {
                            try {
                                channel.close();
                                Object var14_23 = null;
                            }
                            catch (Throwable throwable3) {
                                Object var14_24 = null;
                                try {
                                    channel.await();
                                }
                                catch (CancellationException err) {
                                    composite.cancel();
                                }
                                catch (ExecutionException err) {
                                    composite.setError(err);
                                }
                                catch (InterruptedException err) {
                                    Thread.interrupted();
                                    I18n msg = GraphI18n.interruptedWhileClosingChannel;
                                    Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                                    composite.setError(err);
                                }
                                throw throwable3;
                            }
                            try {
                                channel.await();
                            }
                            catch (CancellationException err) {
                                composite.cancel();
                            }
                            catch (ExecutionException err) {
                                composite.setError(err);
                            }
                            catch (InterruptedException err) {
                                Thread.interrupted();
                                I18n msg = GraphI18n.interruptedWhileClosingChannel;
                                Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                                composite.setError(err);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (searchProcessor != null) {
                            searchProcessor.close();
                        }
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_19;
                        v1 = var12_19 = null;
                    }
                    if (channel == null) break block42;
                    try {
                        channel.close();
                        Object var14_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_22 = null;
                        try {
                            channel.await();
                        }
                        catch (CancellationException err) {
                            composite.cancel();
                        }
                        catch (ExecutionException err) {
                            composite.setError(err);
                        }
                        catch (InterruptedException err) {
                            Thread.interrupted();
                            I18n msg = GraphI18n.interruptedWhileClosingChannel;
                            Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                            composite.setError(err);
                        }
                        throw throwable;
                    }
                    try {
                        channel.await();
                    }
                    catch (CancellationException err) {
                        composite.cancel();
                    }
                    catch (ExecutionException err) {
                        composite.setError(err);
                    }
                    catch (InterruptedException err) {
                        Thread.interrupted();
                        I18n msg = GraphI18n.interruptedWhileClosingChannel;
                        Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                        composite.setError(err);
                    }
                    break block42;
                }
                this.delegateConnection().execute(context, request);
            }
        }
    }

    @NotThreadSafe
    protected abstract class AbstractConnection
    implements RepositoryConnection {
        private RepositoryConnection delegateConnection;

        protected AbstractConnection() {
        }

        protected RepositoryConnection delegateConnection() {
            if (this.delegateConnection == null) {
                this.delegateConnection = SearchableRepositorySource.this.delegate().getConnection();
            }
            return this.delegateConnection;
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            return this.delegateConnection().ping(time, unit);
        }

        public CachePolicy getDefaultCachePolicy() {
            return this.delegateConnection().getDefaultCachePolicy();
        }

        public String getSourceName() {
            return SearchableRepositorySource.this.delegate().getName();
        }

        public XAResource getXAResource() {
            return this.delegateConnection().getXAResource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.delegateConnection != null) {
                try {
                    this.delegateConnection.close();
                }
                finally {
                    this.delegateConnection = null;
                }
            }
        }
    }
}

