/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.maven.MavenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenDependency {
    public static final String DEFAULT_TYPE = "jar";
    public static final boolean DEFAULT_OPTIONAL = false;
    private MavenId id;
    private String type = "jar";
    private Scope scope = Scope.getDefault();
    private String systemPath;
    private boolean optional = false;
    private final Set<MavenId> exclusions = new LinkedHashSet<MavenId>();

    public MavenDependency(String coordinates) {
        this.id = new MavenId(coordinates);
    }

    public MavenDependency(MavenId id) {
        ArgCheck.isNotNull((Object)id, (String)"id");
        this.id = id;
    }

    public MavenDependency(String groupId, String artifactId, String version) {
        this.id = new MavenId(groupId, artifactId, version);
    }

    public MavenDependency(String groupId, String artifactId, String version, String classifier) {
        this.id = new MavenId(groupId, artifactId, version, classifier);
    }

    public MavenId getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type.trim() : DEFAULT_TYPE;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope != null ? scope : Scope.getDefault();
    }

    public void setScope(String text) {
        this.scope = Scope.valueByText(text, true);
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath != null ? systemPath.trim() : null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Set<MavenId> getExclusions() {
        return this.exclusions;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MavenDependency) {
            MavenDependency that = (MavenDependency)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    public String toString() {
        return this.id.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        COMPILE("compile"),
        TEST("test"),
        PROVIDED("provided"),
        SYSTEM("system"),
        RUNTIME("runtime");

        private String suffix;

        private Scope(String suffix) {
            this.suffix = suffix;
        }

        public String getText() {
            return this.suffix;
        }

        public static Scope valueByText(String suffix, boolean useDefault) {
            for (Scope type : Scope.values()) {
                if (!type.suffix.equalsIgnoreCase(suffix)) continue;
                return type;
            }
            return useDefault ? Scope.getDefault() : null;
        }

        public static Scope getDefault() {
            return COMPILE;
        }

        public static EnumSet<Scope> getRuntimeScopes() {
            return EnumSet.of(COMPILE, RUNTIME);
        }
    }
}

