/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.maven;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.dna.common.text.TextEncoder;
import org.jboss.dna.common.text.UrlEncoder;

public class MavenUrl {
    public static final int NO_PORT = -1;
    public static final String JCR_PROTOCOL = "jcr";
    protected static final String URL_PATH_DELIMITER = "/";
    private String hostname = "";
    private int port = -1;
    private String workspaceName = "";
    private String path = "/";

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname != null ? hostname.trim() : "";
        this.hostname = this.trimDelimiters(this.hostname, true, true);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostnameAndPort() {
        if (this.port == -1) {
            return this.hostname;
        }
        if (this.hostname.length() == 0) {
            return "";
        }
        return this.hostname + ":" + this.port;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName != null ? workspaceName.trim() : "";
        this.workspaceName = this.trimDelimiters(this.workspaceName, true, true);
    }

    protected String trimDelimiters(String string, boolean removeLeading, boolean removeTrailing) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (removeLeading) {
            string = string.replaceAll("^/+", "");
        }
        if (removeTrailing) {
            string = string.replaceAll("/+$", "");
        }
        return string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path != null ? URL_PATH_DELIMITER + path.trim() : URL_PATH_DELIMITER;
        this.path = this.path.replaceAll("^/{2,}", URL_PATH_DELIMITER);
        assert (this.path.startsWith(URL_PATH_DELIMITER));
    }

    public URL getUrl(URLStreamHandler handler, TextEncoder encoder) throws MalformedURLException {
        if (encoder == null) {
            encoder = new UrlEncoder().setSlashEncoded(false);
        }
        boolean hasWorkspaceName = this.workspaceName.length() > 0;
        boolean hasPath = this.path.length() > 1;
        String filePart = null;
        filePart = hasWorkspaceName && hasPath ? URL_PATH_DELIMITER + encoder.encode(this.workspaceName) + encoder.encode(this.path) : (hasWorkspaceName ? URL_PATH_DELIMITER + encoder.encode(this.workspaceName) + URL_PATH_DELIMITER : (hasPath ? URL_PATH_DELIMITER + encoder.encode(this.path) : URL_PATH_DELIMITER));
        int actualPort = this.hostname.length() != 0 ? this.port : -1;
        return new URL(JCR_PROTOCOL, this.hostname, actualPort, filePart, handler);
    }

    public String toString() {
        UrlEncoder encoder = new UrlEncoder().setSlashEncoded(false);
        String encodedWorkspace = encoder.encode(this.workspaceName);
        String encodedPath = encoder.encode(this.path);
        boolean hasHostname = this.hostname.length() > 0;
        boolean hasPath = encodedPath.length() > 1;
        StringBuilder sb = new StringBuilder();
        sb.append(JCR_PROTOCOL).append(":");
        if (hasHostname) {
            sb.append("//").append(this.hostname);
            if (this.port != -1) {
                sb.append(":").append(this.port);
            }
        }
        sb.append(URL_PATH_DELIMITER).append(encodedWorkspace);
        if (hasPath) {
            sb.append(encodedPath);
        } else {
            sb.append(URL_PATH_DELIMITER);
        }
        return sb.toString();
    }

    public static MavenUrl parse(String url, TextEncoder decoder) {
        if (decoder == null) {
            decoder = new UrlEncoder();
        }
        Pattern urlPattern = Pattern.compile("jcr:(//(([^/:]*)(:([^/]*))?))?/([^/]*)(/?.*)");
        Matcher matcher = urlPattern.matcher(url);
        MavenUrl result = null;
        if (matcher.find()) {
            result = new MavenUrl();
            result.setHostname(matcher.group(3));
            String portStr = matcher.group(5);
            if (portStr != null && portStr.trim().length() != 0) {
                result.setPort(Integer.parseInt(portStr));
            }
            String workspaceName = decoder.decode(matcher.group(6));
            String path = decoder.decode(matcher.group(7));
            result.setWorkspaceName(workspaceName);
            result.setPath(path);
        }
        return result;
    }

    public static MavenUrl parse(URL url, TextEncoder decoder) {
        if (url == null) {
            return null;
        }
        return MavenUrl.parse(url.toExternalForm(), decoder);
    }
}

