/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.rules;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.rules.ConfigurationException;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.RuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetDeregistrationException;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.SystemFailureException;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.rules.InvalidRuleSetException;
import org.jboss.dna.repository.rules.RuleSet;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.AdministeredService;
import org.jboss.dna.repository.services.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RuleService
implements AdministeredService {
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(RuleService.class.getClassLoader());
    private Logger logger;
    private ClassLoaderFactory classLoaderFactory = DEFAULT_CLASSLOADER_FACTORY;
    private final Administrator administrator = new Administrator();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private final Map<String, RuleSet> ruleSets = new HashMap<String, RuleSet>();
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public RuleService() {
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.classLoaderFactory;
    }

    public void setClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory != null ? classLoaderFactory : DEFAULT_CLASSLOADER_FACTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleSet> getRuleSets() {
        ArrayList<RuleSet> results = new ArrayList<RuleSet>();
        try {
            this.lock.readLock().lock();
            if (this.ruleSets.size() != 0) {
                results.addAll(this.ruleSets.values());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableList(results);
    }

    /*
     * Loose catch block
     */
    public boolean addRuleSet(RuleSet ruleSet) {
        boolean updatedRuleSets;
        block25: {
            ArgCheck.isNotNull((Object)ruleSet, (String)"rule set");
            String providerUri = ruleSet.getProviderUri();
            String ruleSetName = ruleSet.getName();
            String rules = ruleSet.getRules();
            Map<Object, Object> properties = ruleSet.getExecutionSetProperties();
            StringReader ruleReader = new StringReader(rules);
            updatedRuleSets = false;
            try {
                boolean shouldAdd;
                this.lock.writeLock().lock();
                RuleServiceProvider ruleServiceProvider = this.findRuleServiceProvider(ruleSet);
                assert (ruleServiceProvider != null);
                RuleAdministrator ruleAdmin = ruleServiceProvider.getRuleAdministrator();
                if (ruleAdmin == null) {
                    throw new InvalidRuleSetException(RepositoryI18n.unableToObtainJsr94RuleAdministrator.text(new Object[]{providerUri, ruleSet.getComponentClassname(), ruleSetName}));
                }
                RuleSet existing = this.ruleSets.get(ruleSetName);
                LocalRuleExecutionSetProvider ruleExecutionSetProvider = ruleAdmin.getLocalRuleExecutionSetProvider(null);
                RuleExecutionSet executionSet = ruleExecutionSetProvider.createRuleExecutionSet((Reader)ruleReader, properties);
                boolean bl = shouldAdd = existing == null || ruleSet.hasChanged(existing);
                if (existing != null && shouldAdd) {
                    ruleServiceProvider = this.deregister(ruleSet);
                }
                if (!shouldAdd) break block25;
                boolean rollback = false;
                ruleAdmin.registerRuleExecutionSet(ruleSetName, executionSet, null);
                this.ruleSets.remove(ruleSet.getName());
                this.ruleSets.put(ruleSet.getName(), ruleSet);
                updatedRuleSets = true;
                Object var17_21 = null;
                if (!rollback) break block25;
                try {
                    if (existing != null) {
                        String oldRules = existing.getRules();
                        Map<Object, Object> oldProperties = existing.getExecutionSetProperties();
                        StringReader oldRuleReader = new StringReader(oldRules);
                        ruleServiceProvider = this.findRuleServiceProvider(existing);
                        assert (ruleServiceProvider != null);
                        executionSet = ruleExecutionSetProvider.createRuleExecutionSet((Reader)oldRuleReader, oldProperties);
                        ruleAdmin.registerRuleExecutionSet(ruleSetName, executionSet, null);
                        this.ruleSets.remove(ruleSetName);
                        this.ruleSets.put(ruleSetName, existing);
                    }
                    break block25;
                }
                catch (Throwable rollbackError) {
                    this.logger.error(rollbackError, RepositoryI18n.errorRollingBackRuleSetAfterUpdateFailed, new Object[]{ruleSetName});
                }
                break block25;
                {
                    catch (Throwable t) {
                        rollback = true;
                        throw new InvalidRuleSetException(RepositoryI18n.errorAddingOrUpdatingRuleSet.text(new Object[]{ruleSet.getName()}), t);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    if (rollback) {
                        try {
                            if (existing != null) {
                                String oldRules = existing.getRules();
                                Map<Object, Object> oldProperties = existing.getExecutionSetProperties();
                                StringReader oldRuleReader = new StringReader(oldRules);
                                ruleServiceProvider = this.findRuleServiceProvider(existing);
                                assert (ruleServiceProvider != null);
                                executionSet = ruleExecutionSetProvider.createRuleExecutionSet((Reader)oldRuleReader, oldProperties);
                                ruleAdmin.registerRuleExecutionSet(ruleSetName, executionSet, null);
                                this.ruleSets.remove(ruleSetName);
                                this.ruleSets.put(ruleSetName, existing);
                            }
                        }
                        catch (Throwable rollbackError) {
                            this.logger.error(rollbackError, RepositoryI18n.errorRollingBackRuleSetAfterUpdateFailed, new Object[]{ruleSetName});
                        }
                    }
                    throw throwable;
                }
            }
            catch (InvalidRuleSetException e) {
                throw e;
            }
            catch (ConfigurationException t) {
                throw new InvalidRuleSetException(RepositoryI18n.unableToObtainJsr94RuleAdministrator.text(new Object[]{providerUri, ruleSet.getComponentClassname(), ruleSetName}));
            }
            catch (RemoteException t) {
                throw new InvalidRuleSetException(RepositoryI18n.errorUsingJsr94RuleAdministrator.text(new Object[]{providerUri, ruleSet.getComponentClassname(), ruleSetName}));
            }
            catch (IOException t) {
                throw new InvalidRuleSetException(RepositoryI18n.errorReadingRulesAndProperties.text(new Object[]{ruleSetName}));
            }
            catch (RuleExecutionSetDeregistrationException t) {
                throw new InvalidRuleSetException(RepositoryI18n.errorDeregisteringRuleSetBeforeUpdatingIt.text(new Object[]{ruleSetName}));
            }
            catch (RuleExecutionSetCreateException t) {
                throw new InvalidRuleSetException(RepositoryI18n.errorRecreatingRuleSet.text(new Object[]{ruleSetName}));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return updatedRuleSets;
    }

    public boolean updateRuleSet(RuleSet ruleSet) {
        return this.addRuleSet(ruleSet);
    }

    public boolean removeRuleSet(String ruleSetName) {
        block7: {
            ArgCheck.isNotEmpty((String)ruleSetName, (String)"rule set");
            try {
                this.lock.writeLock().lock();
                RuleSet ruleSet = this.ruleSets.remove(ruleSetName);
                if (ruleSet == null) break block7;
                try {
                    this.deregister(ruleSet);
                }
                catch (Throwable t) {
                    this.ruleSets.put(ruleSetName, ruleSet);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable t) {
                throw new SystemFailureException(RepositoryI18n.errorRemovingRuleSet.text(new Object[]{ruleSetName}), t);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return false;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : Logger.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> executeRules(String ruleSetName, Map<String, Object> globals, Object ... facts) {
        ArgCheck.isNotEmpty((String)ruleSetName, (String)"rule set name");
        List result = null;
        List<Object> factList = Arrays.asList(facts);
        try {
            this.lock.readLock().lock();
            RuleSet ruleSet = this.ruleSets.get(ruleSetName);
            if (ruleSet == null) {
                throw new IllegalArgumentException(RepositoryI18n.unableToFindRuleSet.text(new Object[]{ruleSetName}));
            }
            RuleServiceProvider ruleServiceProvider = this.findRuleServiceProvider(ruleSet);
            assert (ruleServiceProvider != null);
            RuleRuntime ruleRuntime = ruleServiceProvider.getRuleRuntime();
            String executionSetName = ruleSet.getRuleSetUri();
            RuleSession session = ruleRuntime.createRuleSession(executionSetName, globals, 1);
            try {
                StatelessRuleSession statelessSession = (StatelessRuleSession)session;
                result = statelessSession.executeRules(factList);
            }
            finally {
                session.release();
            }
            if (this.logger.isTraceEnabled()) {
                String msg = "Executed rule set '{1}' with globals {2} and facts {3} resulting in {4}";
                this.logger.trace(msg, new Object[]{ruleSetName, StringUtil.readableString(globals), StringUtil.readableString((Object)facts), StringUtil.readableString((Object)result)});
            }
        }
        catch (Throwable t) {
            throw new SystemFailureException(RepositoryI18n.errorExecutingRuleSetWithGlobalsAndFacts.text(new Object[]{ruleSetName, StringUtil.readableString(globals), StringUtil.readableString((Object)facts)}), t);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllRuleSets() {
        try {
            this.lock.writeLock().lock();
            for (RuleSet ruleSet : this.ruleSets.values()) {
                try {
                    this.deregister(ruleSet);
                }
                catch (Throwable t) {
                    this.logger.error(t, RepositoryI18n.errorRemovingRuleSetUponShutdown, new Object[]{ruleSet.getName()});
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.shutdownLatch.countDown();
    }

    protected boolean doAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    private RuleServiceProvider findRuleServiceProvider(RuleSet ruleSet) throws ConfigurationException {
        assert (ruleSet != null);
        String providerUri = ruleSet.getProviderUri();
        RuleServiceProvider ruleServiceProvider = null;
        try {
            ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)providerUri);
        }
        catch (ConfigurationException e) {
            try {
                ClassLoader loader = this.classLoaderFactory.getClassLoader(ruleSet.getComponentClasspathArray());
                Class.forName(ruleSet.getComponentClassname(), true, loader);
                ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)providerUri);
                this.logger.debug("Loaded the rule service provider {0} ({1})", new Object[]{providerUri, ruleSet.getComponentClassname()});
            }
            catch (ConfigurationException ce) {
                throw ce;
            }
            catch (Throwable t) {
                throw new InvalidRuleSetException(RepositoryI18n.unableToObtainJsr94ServiceProvider.text(new Object[]{providerUri, ruleSet.getComponentClassname()}), t);
            }
        }
        if (ruleServiceProvider == null) {
            throw new InvalidRuleSetException(RepositoryI18n.unableToObtainJsr94ServiceProvider.text(new Object[]{providerUri, ruleSet.getComponentClassname()}));
        }
        return ruleServiceProvider;
    }

    private RuleServiceProvider deregister(RuleSet ruleSet) throws ConfigurationException, RuleExecutionSetDeregistrationException, RemoteException {
        RuleAdministrator ruleAdmin;
        assert (ruleSet != null);
        String providerUri = ruleSet.getProviderUri();
        assert (providerUri != null);
        RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)providerUri);
        if (ruleServiceProvider != null && (ruleAdmin = ruleServiceProvider.getRuleAdministrator()) != null) {
            ruleAdmin.deregisterRuleExecutionSet(ruleSet.getRuleSetUri(), null);
        }
        return ruleServiceProvider;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(ServiceAdministrator.State.PAUSED);
        }

        protected String serviceName() {
            return "RuleService";
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RuleService.this.removeAllRuleSets();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return RuleService.this.doAwaitTermination(timeout, unit);
        }
    }
}

