/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.jcr.Path;
import org.jboss.dna.common.util.StringUtil;
import org.jboss.dna.spi.sequencers.SequencerOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class SequencerOutputMap
implements SequencerOutput,
Iterable<Entry> {
    private static final String JCR_PRIMARY_TYPE_PROPERTY_NAME = "jcr:primaryType";
    private static final String JCR_NAME_PROPERTY_NAME = "jcr:name";
    private final Map<Path, List<PropertyValue>> data = new HashMap<Path, List<PropertyValue>>();
    private boolean valuesSorted = true;

    public void setProperty(String nodePath, String property, Object ... values) {
        Path path;
        List<PropertyValue> properties;
        if (JCR_NAME_PROPERTY_NAME.equals(property = property.trim())) {
            return;
        }
        if ((nodePath = nodePath.trim()).endsWith("/")) {
            nodePath = nodePath.replaceFirst("/+$", "");
        }
        if ((properties = this.data.get(path = new Path(nodePath))) == null) {
            if (values == null || values.length == 0) {
                return;
            }
            properties = new ArrayList<PropertyValue>();
            this.data.put(path, properties);
        }
        if (values == null || values.length == 0) {
            properties.remove(new PropertyValue(property, null));
        } else {
            Object[] propValue = values.length == 1 ? values[0] : values;
            PropertyValue value = new PropertyValue(property, propValue);
            properties.add(value);
            this.valuesSorted = false;
        }
    }

    public void setReference(String nodePath, String property, String ... paths) {
        if (paths == null || paths.length == 0) {
            this.setProperty(nodePath, property, null);
        } else if (paths.length == 1) {
            this.setProperty(nodePath, property, new Path(paths[0]));
        } else {
            Path[] pathsArray = new Path[paths.length];
            for (int i = 0; i != paths.length; ++i) {
                pathsArray[i] = new Path(paths[i]);
            }
            this.setProperty(nodePath, property, pathsArray);
        }
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    protected List<PropertyValue> removeProperties(Path nodePath) {
        return this.data.remove(nodePath);
    }

    protected List<PropertyValue> getProperties(Path nodePath) {
        return this.data.get(nodePath);
    }

    @Override
    public Iterator<Entry> iterator() {
        LinkedList<Path> paths = new LinkedList<Path>(this.data.keySet());
        Collections.sort(paths);
        this.sortValues();
        return new EntryIterator(paths.iterator());
    }

    protected void sortValues() {
        if (!this.valuesSorted) {
            for (List<PropertyValue> values : this.data.values()) {
                if (values.size() <= 1) continue;
                Collections.sort(values);
            }
            this.valuesSorted = true;
        }
    }

    public String toString() {
        return StringUtil.readableString(this.data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntryIterator
    implements Iterator<Entry> {
        private Path last;
        private final Iterator<Path> iter;

        protected EntryIterator(Iterator<Path> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Entry next() {
            this.last = this.iter.next();
            return new Entry(this.last, SequencerOutputMap.this.getProperties(this.last));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            try {
                SequencerOutputMap.this.removeProperties(this.last);
            }
            finally {
                this.last = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public class Entry {
        private final Path path;
        private final String primaryType;
        private final List<PropertyValue> properties;

        protected Entry(Path path, List<PropertyValue> properties) {
            assert (path != null);
            assert (properties != null);
            this.path = path;
            this.properties = properties;
            if (this.properties.size() > 0 && this.properties.get(0).getName().equals(SequencerOutputMap.JCR_PRIMARY_TYPE_PROPERTY_NAME)) {
                PropertyValue primaryTypeProperty = this.properties.remove(0);
                this.primaryType = primaryTypeProperty.getValue().toString();
            } else {
                this.primaryType = null;
            }
        }

        public Path getPath() {
            return this.path;
        }

        public String getPrimaryTypeValue() {
            return this.primaryType;
        }

        public List<PropertyValue> getPropertyValues() {
            return SequencerOutputMap.this.getProperties(this.path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public class PropertyValue
    implements Comparable<PropertyValue> {
        private final String name;
        private final Object value;

        protected PropertyValue(String propertyName, Object value) {
            this.name = propertyName;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int compareTo(PropertyValue that) {
            if (this == that) {
                return 0;
            }
            if (this.name.equals(SequencerOutputMap.JCR_PRIMARY_TYPE_PROPERTY_NAME)) {
                return -1;
            }
            if (that.name.equals(SequencerOutputMap.JCR_PRIMARY_TYPE_PROPERTY_NAME)) {
                return 1;
            }
            return this.name.compareTo(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PropertyValue) {
                PropertyValue that = (PropertyValue)obj;
                return this.getName().equals(that.getName());
            }
            return false;
        }

        public String toString() {
            return "[" + this.name + "=" + StringUtil.readableString((Object)this.value) + "]";
        }
    }
}

