/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jboss.dna.common.jcr.Path;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.sequencers.Sequencer;
import org.jboss.dna.repository.sequencers.SequencerConfig;
import org.jboss.dna.repository.sequencers.SequencerException;
import org.jboss.dna.repository.sequencers.SequencerOutputMap;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.RepositoryNodePath;
import org.jboss.dna.spi.sequencers.SequencerOutput;
import org.jboss.dna.spi.sequencers.StreamSequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSequencerAdapter
implements Sequencer {
    private SequencerConfig configuration;
    private final StreamSequencer streamSequencer;

    public StreamSequencerAdapter(StreamSequencer streamSequencer) {
        this.streamSequencer = streamSequencer;
    }

    public SequencerConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SequencerConfig configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(Node input, String sequencedPropertyName, NodeChange changes, Set<RepositoryNodePath> outputPaths, ExecutionContext context, ProgressMonitor progressMonitor) throws RepositoryException, SequencerException {
        try {
            progressMonitor.beginTask(100.0, RepositoryI18n.sequencingPropertyOnNode, new Object[]{sequencedPropertyName, input.getPath()});
            Property imageDataProperty = null;
            try {
                imageDataProperty = input.getProperty(sequencedPropertyName);
            }
            catch (PathNotFoundException e) {
                String msg = RepositoryI18n.unableToFindPropertyForSequencing.text(new Object[]{sequencedPropertyName, input.getPath()});
                throw new SequencerException(msg, e);
            }
            progressMonitor.worked(10.0);
            SequencerOutputMap output = new SequencerOutputMap();
            InputStream stream = null;
            Throwable firstError = null;
            ProgressMonitor sequencingMonitor = progressMonitor.createSubtask(50.0);
            try {
                stream = imageDataProperty.getStream();
                this.streamSequencer.sequence(stream, (SequencerOutput)output, sequencingMonitor);
            }
            catch (Throwable t) {
                firstError = t;
            }
            finally {
                sequencingMonitor.done();
                if (stream != null) {
                    try {
                        try {
                            stream.close();
                            stream = null;
                        }
                        catch (Throwable t) {
                            if (firstError == null) {
                                firstError = t;
                            }
                            stream = null;
                        }
                    }
                    catch (Throwable throwable) {
                        stream = null;
                        throw throwable;
                    }
                }
                if (firstError != null) {
                    throw new SequencerException(firstError);
                }
            }
            ProgressMonitor writingProgress = progressMonitor.createSubtask(40.0);
            writingProgress.beginTask((double)outputPaths.size(), RepositoryI18n.writingOutputSequencedFromPropertyOnNodes, new Object[]{sequencedPropertyName, input.getPath(), outputPaths.size()});
            for (RepositoryNodePath outputPath : outputPaths) {
                Session session = null;
                try {
                    String repositoryWorkspaceName = outputPath.getRepositoryWorkspaceName();
                    String nodePath = outputPath.getNodePath();
                    session = context.getSessionFactory().createSession(repositoryWorkspaceName);
                    Node outputNode = context.getTools().findOrCreateNode(session, nodePath);
                    if (!this.saveOutput(outputNode, output, context)) continue;
                    session.save();
                }
                finally {
                    writingProgress.worked(1.0);
                    if (session == null) continue;
                    session.logout();
                }
            }
            writingProgress.done();
            return;
        }
        finally {
            progressMonitor.done();
        }
    }

    protected boolean saveOutput(Node outputNode, SequencerOutputMap output, ExecutionContext context) throws RepositoryException {
        if (output.isEmpty()) {
            return false;
        }
        Path outputNodePath = new Path(outputNode.getPath());
        for (SequencerOutputMap.Entry entry : output) {
            Path targetNodePath = entry.getPath();
            String primaryType = entry.getPrimaryTypeValue();
            Path absolutePath = targetNodePath.isAbsolute() ? targetNodePath : outputNodePath.resolve(targetNodePath);
            Path relativePath = absolutePath.relativeTo(outputNodePath);
            Node targetNode = outputNode;
            int max = relativePath.size();
            for (int i = 0; i != max; ++i) {
                Path.Segment segment = relativePath.getSegment(i);
                String qualifiedName = segment.getQualifiedName(true);
                if (targetNode.hasNode(qualifiedName)) {
                    targetNode = targetNode.getNode(qualifiedName);
                } else {
                    if (segment.hasIndex()) {
                        qualifiedName = segment.getQualifiedName(false);
                    }
                    targetNode = i == max - 1 && primaryType != null ? targetNode.addNode(qualifiedName, primaryType) : targetNode.addNode(qualifiedName);
                }
                assert (targetNode != null);
            }
            assert (targetNode != null);
            for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                String propertyName = property.getName();
                Object value = property.getValue();
                Logger.getLogger(this.getClass()).trace("Writing property {0}/{1}={2}", new Object[]{targetNode.getPath(), propertyName, value});
                if (value instanceof Boolean) {
                    targetNode.setProperty(propertyName, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    targetNode.setProperty(propertyName, (String)value);
                    continue;
                }
                if (value instanceof Integer) {
                    targetNode.setProperty(propertyName, (long)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Short) {
                    targetNode.setProperty(propertyName, (long)((Short)value).shortValue());
                    continue;
                }
                if (value instanceof Long) {
                    targetNode.setProperty(propertyName, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    targetNode.setProperty(propertyName, (double)((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    targetNode.setProperty(propertyName, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Calendar) {
                    targetNode.setProperty(propertyName, (Calendar)value);
                    continue;
                }
                if (value instanceof Path) {
                    Path pathToReferencedNode = (Path)value;
                    if (!pathToReferencedNode.isAbsolute()) {
                        pathToReferencedNode = outputNodePath.resolve(pathToReferencedNode);
                    }
                    try {
                        Node referencedNode = outputNode.getNode(pathToReferencedNode.getString());
                        targetNode.setProperty(propertyName, referencedNode);
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        String msg = RepositoryI18n.errorGettingNodeRelativeToNode.text(new Object[]{value, outputNode.getPath()});
                        throw new SequencerException(msg, e);
                    }
                }
                if (value == null) {
                    targetNode.setProperty(propertyName, (String)null);
                    continue;
                }
                String msg = RepositoryI18n.unknownPropertyValueType.text(new Object[]{value, value.getClass().getName()});
                throw new SequencerException(msg);
            }
        }
        return true;
    }

    protected String[] extractMixinTypes(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }
}

