/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.services;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.services.ServiceAdministrator;

@ThreadSafe
public abstract class AbstractServiceAdministrator
implements ServiceAdministrator {
    private volatile ServiceAdministrator.State state;

    protected AbstractServiceAdministrator(ServiceAdministrator.State initialState) {
        assert (initialState != null);
        this.state = initialState;
    }

    public ServiceAdministrator.State getState() {
        return this.state;
    }

    @GuardedBy(value="this")
    public synchronized ServiceAdministrator setState(ServiceAdministrator.State state) {
        switch (state) {
            case STARTED: {
                this.start();
                break;
            }
            case PAUSED: {
                this.pause();
                break;
            }
            case SHUTDOWN: {
                this.shutdown();
            }
        }
        return this;
    }

    public ServiceAdministrator setState(String state) {
        ServiceAdministrator.State newState;
        ServiceAdministrator.State state2 = newState = state == null ? null : ServiceAdministrator.State.valueOf(state.toUpperCase());
        if (newState == null) {
            throw new IllegalArgumentException(RepositoryI18n.invalidStateString.text(new Object[]{state}));
        }
        return this.setState(newState);
    }

    public synchronized ServiceAdministrator start() {
        if (this.isShutdown()) {
            throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBeStarted.text(new Object[]{this.serviceName()}));
        }
        if (this.state != ServiceAdministrator.State.STARTED) {
            this.doStart(this.state);
            this.state = ServiceAdministrator.State.STARTED;
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doStart(ServiceAdministrator.State fromState) {
    }

    public synchronized ServiceAdministrator pause() {
        if (this.isShutdown()) {
            throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBePaused.text(new Object[]{this.serviceName()}));
        }
        if (this.state != ServiceAdministrator.State.PAUSED) {
            this.doPause(this.state);
            this.state = ServiceAdministrator.State.PAUSED;
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doPause(ServiceAdministrator.State fromState) {
    }

    public synchronized ServiceAdministrator shutdown() {
        if (this.state != ServiceAdministrator.State.SHUTDOWN) {
            this.doShutdown(this.state);
            this.state = ServiceAdministrator.State.SHUTDOWN;
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doShutdown(ServiceAdministrator.State fromState) {
    }

    public boolean isStarted() {
        return this.state == ServiceAdministrator.State.STARTED;
    }

    public boolean isPaused() {
        return this.state == ServiceAdministrator.State.PAUSED;
    }

    public boolean isShutdown() {
        return this.state == ServiceAdministrator.State.SHUTDOWN;
    }

    protected abstract String serviceName();
}

