/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.BasicExecutionContextFactory;
import org.jboss.dna.graph.ExecutionContextFactory;
import org.jboss.dna.graph.connectors.RepositoryConnection;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositoryConnectionPool;
import org.jboss.dna.graph.connectors.RepositoryContext;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryLibrary
implements RepositoryConnectionFactory {
    private final ServiceAdministrator administrator = new Administrator();
    private final ReadWriteLock sourcesLock = new ReentrantReadWriteLock();
    private final CopyOnWriteArrayList<RepositoryConnectionPool> pools = new CopyOnWriteArrayList();
    private RepositoryConnectionFactory delegate;
    private final ExecutionContextFactory executionContextFactory;
    private final RepositoryContext repositoryContext;

    public RepositoryLibrary() {
        this((ExecutionContextFactory)new BasicExecutionContextFactory(), null);
    }

    public RepositoryLibrary(RepositoryConnectionFactory delegate) {
        this((ExecutionContextFactory)new BasicExecutionContextFactory(), delegate);
    }

    public RepositoryLibrary(ExecutionContextFactory executionContextFactory) {
        this(executionContextFactory, null);
    }

    public RepositoryLibrary(ExecutionContextFactory executionContextFactory, RepositoryConnectionFactory delegate) {
        CheckArg.isNotNull((Object)executionContextFactory, (String)"executionContextFactory");
        this.delegate = delegate;
        this.executionContextFactory = executionContextFactory;
        this.repositoryContext = new RepositoryContext(){

            public ExecutionContextFactory getExecutionContextFactory() {
                return RepositoryLibrary.this.getExecutionContextFactory();
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return RepositoryLibrary.this;
            }
        };
    }

    public ExecutionContextFactory getExecutionContextFactory() {
        return this.executionContextFactory;
    }

    public RepositoryConnectionFactory getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RepositoryConnectionFactory delegate) {
        this.delegate = delegate;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    protected void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                pool.shutdown();
            }
            Object var4_3 = null;
            this.sourcesLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.awaitTermination(timeout, unit)) continue;
                boolean bl2 = false;
                Object var8_7 = null;
                this.sourcesLock.readLock().unlock();
                return bl2;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
        Object var8_8 = null;
        this.sourcesLock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTerminating() {
        boolean bl;
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (!pool.isTerminating()) continue;
                boolean bl2 = true;
                Object var5_5 = null;
                this.sourcesLock.readLock().unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.sourcesLock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTerminated() {
        boolean bl;
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.isTerminated()) continue;
                boolean bl2 = false;
                Object var5_5 = null;
                this.sourcesLock.readLock().unlock();
                return bl2;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.sourcesLock.readLock().unlock();
        return bl;
    }

    public Collection<String> getSourceNames() {
        HashSet<String> sourceNames = new HashSet<String>();
        for (RepositoryConnectionPool pool : this.pools) {
            sourceNames.add(pool.getRepositorySource().getName());
        }
        return Collections.unmodifiableCollection(sourceNames);
    }

    public Collection<RepositorySource> getSources() {
        LinkedList<RepositorySource> sources = new LinkedList<RepositorySource>();
        for (RepositoryConnectionPool pool : this.pools) {
            sources.add(pool.getRepositorySource());
        }
        return Collections.unmodifiableCollection(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositorySource getSource(String sourceName) {
        try {
            RepositoryConnectionPool existingPool;
            RepositorySource source;
            this.sourcesLock.readLock().lock();
            Iterator<RepositoryConnectionPool> i$ = this.pools.iterator();
            do {
                if (i$.hasNext()) continue;
                Object var7_7 = null;
                this.sourcesLock.readLock().unlock();
                return null;
            } while (!(source = (existingPool = i$.next()).getRepositorySource()).getName().equals(sourceName));
            RepositorySource repositorySource = source;
            Object var7_6 = null;
            this.sourcesLock.readLock().unlock();
            return repositorySource;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositoryConnectionPool getConnectionPool(String sourceName) {
        try {
            RepositoryConnectionPool existingPool;
            RepositorySource source;
            this.sourcesLock.readLock().lock();
            Iterator<RepositoryConnectionPool> i$ = this.pools.iterator();
            do {
                if (i$.hasNext()) continue;
                Object var7_7 = null;
                this.sourcesLock.readLock().unlock();
                return null;
            } while (!(source = (existingPool = i$.next()).getRepositorySource()).getName().equals(sourceName));
            RepositoryConnectionPool repositoryConnectionPool = existingPool;
            Object var7_6 = null;
            this.sourcesLock.readLock().unlock();
            return repositoryConnectionPool;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.sourcesLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addSource(RepositorySource source) {
        boolean bl;
        if (source == null) {
            return false;
        }
        try {
            this.sourcesLock.writeLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                if (!existingPool.getRepositorySource().getName().equals(source.getName())) continue;
                boolean bl2 = false;
                Object var6_6 = null;
                this.sourcesLock.writeLock().unlock();
                return bl2;
            }
            source.initialize(this.repositoryContext);
            RepositoryConnectionPool pool = new RepositoryConnectionPool(source);
            this.pools.add(pool);
            bl = true;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.sourcesLock.writeLock().unlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.sourcesLock.writeLock().unlock();
        return bl;
    }

    public boolean removeSource(RepositorySource source, long timeToAwait, TimeUnit unit) throws InterruptedException {
        return this.removeSource(source.getName(), timeToAwait, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource removeSource(String name, long timeToAwait, TimeUnit unit) throws InterruptedException {
        block5: {
            try {
                this.sourcesLock.writeLock().lock();
                Iterator<RepositoryConnectionPool> i$ = this.pools.iterator();
                if (!i$.hasNext()) break block5;
                RepositoryConnectionPool existingPool = i$.next();
                if (existingPool.getRepositorySource().getName().equals(name)) {
                    existingPool.shutdown();
                    if (timeToAwait > 0L) {
                        existingPool.awaitTermination(timeToAwait, unit);
                    }
                }
                RepositorySource repositorySource = existingPool.getRepositorySource();
                Object var9_7 = null;
                this.sourcesLock.writeLock().unlock();
                return repositorySource;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.sourcesLock.writeLock().unlock();
                throw throwable;
            }
        }
        Object var9_8 = null;
        this.sourcesLock.writeLock().unlock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RepositoryConnection createConnection(String sourceName) {
        block3: {
            RepositoryConnection repositoryConnection;
            try {
                this.sourcesLock.readLock().lock();
                for (RepositoryConnectionPool existingPool : this.pools) {
                    RepositorySource source = existingPool.getRepositorySource();
                    if (!source.getName().equals(sourceName)) continue;
                    RepositoryConnection repositoryConnection2 = existingPool.getConnection();
                    Object var7_6 = null;
                    this.sourcesLock.readLock().unlock();
                    return repositoryConnection2;
                }
                RepositoryConnectionFactory delegate = this.delegate;
                if (delegate == null) break block3;
                repositoryConnection = delegate.createConnection(sourceName);
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.sourcesLock.readLock().unlock();
                throw throwable;
            }
            Object var7_7 = null;
            this.sourcesLock.readLock().unlock();
            return repositoryConnection;
        }
        Object var7_8 = null;
        this.sourcesLock.readLock().unlock();
        return null;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryLibrary.this.start();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RepositoryLibrary.this.shutdown();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return RepositoryLibrary.this.awaitTermination(timeout, unit);
        }

        protected boolean doCheckIsTerminated() {
            return RepositoryLibrary.this.isTerminated();
        }
    }
}

