/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Reflection;
import org.jboss.dna.connector.federation.FederationException;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.connectors.RepositoryConnectionFactory;
import org.jboss.dna.graph.connectors.RepositorySource;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathNotFoundException;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.properties.ValueFactory;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.RepositoryLibrary;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.AdministeredService;
import org.jboss.dna.repository.services.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryService
implements AdministeredService {
    private final ExecutionContext context;
    private final RepositoryLibrary sources;
    private final String configurationSourceName;
    private final Path pathToConfigurationRoot;
    private final Administrator administrator = new Administrator();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public RepositoryService(RepositoryLibrary sources, String configurationSourceName, ExecutionContext context) {
        this(sources, configurationSourceName, null, context);
    }

    public RepositoryService(RepositoryLibrary sources, String configurationSourceName, Path pathToConfigurationRoot, ExecutionContext context) {
        CheckArg.isNotNull((Object)configurationSourceName, (String)"configurationSourceName");
        CheckArg.isNotNull((Object)sources, (String)"sources");
        CheckArg.isNotNull((Object)context, (String)"context");
        if (pathToConfigurationRoot == null) {
            pathToConfigurationRoot = (Path)context.getValueFactories().getPathFactory().create("/dna:system");
        }
        this.sources = sources;
        this.pathToConfigurationRoot = pathToConfigurationRoot;
        this.configurationSourceName = configurationSourceName;
        this.context = context;
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public String getConfigurationSourceName() {
        return this.configurationSourceName;
    }

    public RepositoryLibrary getRepositorySourceManager() {
        return this.sources;
    }

    public ExecutionContext getExecutionEnvironment() {
        return this.context;
    }

    public String getJndiName() {
        return null;
    }

    protected synchronized void startService() {
        if (!this.started.get()) {
            SimpleProblems problems = new SimpleProblems();
            Graph graph = Graph.create((String)this.getConfigurationSourceName(), (RepositoryConnectionFactory)this.sources, (ExecutionContext)this.context);
            Path pathToSourcesNode = this.context.getValueFactories().getPathFactory().create(this.pathToConfigurationRoot, "dna:sources");
            try {
                Subgraph sourcesGraph = (Subgraph)graph.getSubgraphOfDepth(3).at(pathToSourcesNode);
                for (Location location : sourcesGraph.getRoot().getChildren()) {
                    Node sourceNode = sourcesGraph.getNode(location);
                    this.sources.addSource(this.createRepositorySource(location.getPath(), sourceNode.getPropertiesByName(), (Problems)problems));
                }
            }
            catch (PathNotFoundException e) {
            }
            catch (Throwable err) {
                throw new FederationException(RepositoryI18n.errorStartingRepositoryService.text(new Object[0]), err);
            }
            this.started.set(true);
        }
    }

    protected RepositorySource createRepositorySource(Path path, Map<Name, Property> properties, Problems problems) {
        ValueFactories valueFactories = this.context.getValueFactories();
        ValueFactory stringFactory = valueFactories.getStringFactory();
        Property classnameProperty = properties.get(DnaLexicon.CLASSNAME);
        Property classpathProperty = properties.get(DnaLexicon.CLASSPATH);
        if (classnameProperty == null) {
            problems.addError(RepositoryI18n.requiredPropertyIsMissingFromNode, new Object[]{DnaLexicon.CLASSNAME, path});
        }
        if (problems.hasErrors()) {
            return null;
        }
        String classname = (String)stringFactory.create(classnameProperty.getValues().next());
        String[] classpath = classpathProperty == null ? new String[]{} : (String[])stringFactory.create(classpathProperty.getValuesAsArray());
        ClassLoader classLoader = this.context.getClassLoader(classpath);
        RepositorySource source = null;
        try {
            Class<?> sourceClass = classLoader.loadClass(classname);
            source = (RepositorySource)sourceClass.newInstance();
        }
        catch (ClassNotFoundException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToLoadClassUsingClasspath, new Object[]{classname, classpath});
        }
        catch (IllegalAccessException err) {
            problems.addError((Throwable)err, RepositoryI18n.unableToAccessClassUsingClasspath, new Object[]{classname, classpath});
        }
        catch (Throwable err) {
            problems.addError(err, RepositoryI18n.unableToInstantiateClassUsingClasspath, new Object[]{classname, classpath});
        }
        Reflection reflection = new Reflection(source.getClass());
        try {
            reflection.invokeSetterMethodOnTarget("name", (Object)source, (Object)path.getLastSegment().getName().getLocalName());
        }
        catch (SecurityException err) {
        }
        catch (NoSuchMethodException err) {
        }
        catch (IllegalArgumentException err) {
        }
        catch (IllegalAccessException err) {
        }
        catch (InvocationTargetException err) {
            // empty catch block
        }
        for (Map.Entry<Name, Property> entry : properties.entrySet()) {
            Name propertyName = entry.getKey();
            Property property = entry.getValue();
            String javaPropertyName = propertyName.getLocalName();
            if (property.isEmpty()) continue;
            Object[] value = null;
            if (property.isSingle()) {
                value = (Object[])property.getValues().next();
            } else if (property.isMultiple()) {
                value = property.getValuesAsArray();
            }
            try {
                reflection.invokeSetterMethodOnTarget(javaPropertyName, (Object)source, (Object)value);
            }
            catch (SecurityException err) {
            }
            catch (NoSuchMethodException err) {
            }
            catch (IllegalArgumentException err) {
            }
            catch (IllegalAccessException err) {
            }
            catch (InvocationTargetException err) {}
        }
        return source;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.PAUSED);
        }

        protected boolean doCheckIsTerminated() {
            return true;
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryService.this.startService();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }
}

