/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.common.text.Inflector;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Reflection;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositorySource;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathExpression;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.ValueFormatException;
import org.jboss.dna.graph.property.basic.RootPath;
import org.jboss.dna.repository.DnaConfigurationException;
import org.jboss.dna.repository.DnaLexicon;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.sequencer.Sequencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Configurator<BuilderType> {
    protected final BuilderType builder;
    protected final ExecutionContext context;
    protected ConfigurationRepository configurationSource;
    private Graph graph;
    private Graph.Batch batch;

    protected Configurator(ExecutionContext context, BuilderType builder) {
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull(builder, (String)"builder");
        this.context = context;
        this.builder = builder;
        this.configurationSource = this.createDefaultConfigurationSource();
    }

    protected ConfigurationRepository createDefaultConfigurationSource() {
        InMemoryRepositorySource defaultSource = new InMemoryRepositorySource();
        defaultSource.setName("Configuration");
        ConfigurationRepository result = new ConfigurationRepository((RepositorySource)defaultSource, "Configuration Repository", null);
        return result;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    protected final PathFactory pathFactory() {
        return this.getExecutionContext().getValueFactories().getPathFactory();
    }

    protected final Graph graph() {
        if (this.graph == null) {
            this.graph = Graph.create((RepositorySource)this.configurationSource.getRepositorySource(), (ExecutionContext)this.context);
        }
        return this.graph;
    }

    protected final Graph.Batch configuration() {
        if (this.batch == null) {
            this.batch = this.graph().batch();
        }
        return this.batch;
    }

    public BuilderType save() {
        if (this.batch != null) {
            this.batch.execute();
            this.batch = this.graph.batch();
        }
        return this.builder;
    }

    protected abstract Name nameFor(String var1);

    protected Path createOrReplaceNode(Path parentPath, String id) {
        Path path = this.pathFactory().create(parentPath, id);
        this.configuration().create(path).with(DnaLexicon.READABLE_NAME, new Object[]{id}).and();
        return path;
    }

    protected void recordBeanPropertiesInGraph(Path path, Object javaBean) {
        Reflection reflector = new Reflection(javaBean.getClass());
        for (String propertyName : reflector.findGetterPropertyNames()) {
            try {
                Object value = reflector.invokeGetterMethodOnTarget(propertyName, javaBean);
                if (value == null) continue;
                propertyName = Inflector.getInstance().lowerCamelCase(propertyName, new char[0]);
                ((Graph.On)this.configuration().set(this.nameFor(propertyName)).to(value)).on(path);
            }
            catch (ValueFormatException err) {
                throw err;
            }
            catch (Throwable err) {
                // empty catch block
            }
        }
    }

    @Immutable
    public static class ConfigurationRepository {
        private final RepositorySource source;
        private final String description;
        private final Path path;

        protected ConfigurationRepository(RepositorySource source) {
            this(source, null, null);
        }

        protected ConfigurationRepository(RepositorySource source, String description, Path path) {
            this.source = source;
            this.description = description != null ? description : "";
            this.path = path != null ? path : RootPath.INSTANCE;
        }

        public RepositorySource getRepositorySource() {
            return this.source;
        }

        public String getDescription() {
            return this.description;
        }

        public Path getPath() {
            return this.path;
        }

        public ConfigurationRepository with(String description) {
            return new ConfigurationRepository(this.source, description, this.path);
        }

        public ConfigurationRepository with(Path path) {
            return new ConfigurationRepository(this.source, this.description, path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphMimeTypeDetectorDetails<ReturnType>
    implements MimeTypeDetectorDetails<ReturnType> {
        private final Path path;
        private final ReturnType returnObject;

        protected GraphMimeTypeDetectorDetails(Path path, ReturnType returnObject) {
            assert (path != null);
            assert (returnObject != null);
            this.path = path;
            this.returnObject = returnObject;
        }

        @Override
        public MimeTypeDetectorDetails<ReturnType> named(String name) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.READABLE_NAME).to(name)).on(this.path);
            return this;
        }

        @Override
        public PropertySetter<MimeTypeDetectorDetails<ReturnType>> with(String propertyName) {
            return new GraphPropertySetter<MimeTypeDetectorDetails<ReturnType>>(this.path, propertyName, this);
        }

        @Override
        public MimeTypeDetectorDetails<ReturnType> describedAs(String description) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.DESCRIPTION).to(description)).on(this.path);
            return this;
        }

        @Override
        public ReturnType and() {
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphSequencerDetails<ReturnType>
    implements SequencerDetails<ReturnType> {
        private final Path path;
        private final List<String> compiledExpressions = new ArrayList<String>();
        private final ReturnType returnObject;

        protected GraphSequencerDetails(Path path, ReturnType returnObject) {
            assert (path != null);
            assert (returnObject != null);
            this.path = path;
            this.returnObject = returnObject;
        }

        @Override
        public PathExpressionOutput<ReturnType> sequencingFrom(final String from) {
            CheckArg.isNotEmpty((String)from, (String)"from");
            return new PathExpressionOutput<ReturnType>(){

                @Override
                public SequencerDetails<ReturnType> andOutputtingTo(String into) {
                    CheckArg.isNotEmpty((String)into, (String)"into");
                    return GraphSequencerDetails.this.sequencingFrom(PathExpression.compile((String)(from + " => " + into)));
                }
            };
        }

        @Override
        public SequencerDetails<ReturnType> named(String name) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.READABLE_NAME).to(name)).on(this.path);
            return this;
        }

        @Override
        public SequencerDetails<ReturnType> sequencingFrom(PathExpression expression) {
            CheckArg.isNotNull((Object)expression, (String)"expression");
            String compiledExpression = expression.getExpression();
            if (!this.compiledExpressions.contains(compiledExpression)) {
                this.compiledExpressions.add(compiledExpression);
            }
            ((Graph.SetValuesTo)Configurator.this.configuration().set(DnaLexicon.PATH_EXPRESSIONS).on(this.path)).to(this.compiledExpressions);
            return this;
        }

        @Override
        public SequencerDetails<ReturnType> describedAs(String description) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.DESCRIPTION).to(description)).on(this.path);
            return this;
        }

        @Override
        public ReturnType and() {
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphRepositoryDetails<ReturnType>
    implements RepositoryDetails<ReturnType> {
        private final Path path;
        private final ReturnType returnObject;

        protected GraphRepositoryDetails(Path path, ReturnType returnObject) {
            assert (path != null);
            assert (returnObject != null);
            this.path = path;
            this.returnObject = returnObject;
        }

        @Override
        public RepositoryDetails<ReturnType> named(String name) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.READABLE_NAME).to(name)).on(this.path);
            return this;
        }

        @Override
        public RepositoryDetails<ReturnType> describedAs(String description) {
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.DESCRIPTION).to(description)).on(this.path);
            return this;
        }

        @Override
        public PropertySetter<RepositoryDetails<ReturnType>> with(String propertyName) {
            return new GraphPropertySetter<RepositoryDetails<ReturnType>>(this.path, propertyName, this);
        }

        @Override
        public ReturnType and() {
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphPropertySetter<ReturnType>
    implements PropertySetter<ReturnType> {
        private final Path path;
        private final String beanPropertyName;
        private final ReturnType returnObject;

        protected GraphPropertySetter(Path path, String beanPropertyName, ReturnType returnObject) {
            assert (path != null);
            assert (beanPropertyName != null);
            assert (returnObject != null);
            this.path = path;
            this.beanPropertyName = Inflector.getInstance().lowerCamelCase(beanPropertyName, new char[0]);
            this.returnObject = returnObject;
        }

        @Override
        public ReturnType setTo(boolean value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(int value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(long value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(short value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to((int)value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(float value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(double value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(String value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }

        @Override
        public ReturnType setTo(Object value) {
            ((Graph.On)Configurator.this.configuration().set(Configurator.this.nameFor(this.beanPropertyName)).to(value)).on(this.path);
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BeanPropertySetter<ReturnType>
    implements PropertySetter<ReturnType> {
        private final Object javaBean;
        private final String beanPropertyName;
        private final ReturnType returnObject;

        protected BeanPropertySetter(Object javaBean, String beanPropertyName, ReturnType returnObject) {
            assert (javaBean != null);
            assert (beanPropertyName != null);
            assert (returnObject != null);
            this.javaBean = javaBean;
            this.beanPropertyName = beanPropertyName;
            this.returnObject = returnObject;
        }

        @Override
        public ReturnType setTo(boolean value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(int value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(long value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(short value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(float value) {
            return this.setTo(Float.valueOf(value));
        }

        @Override
        public ReturnType setTo(double value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(String value) {
            return this.setTo((Object)value);
        }

        @Override
        public ReturnType setTo(Object value) {
            Reflection reflection = new Reflection(this.javaBean.getClass());
            try {
                reflection.invokeSetterMethodOnTarget(this.beanPropertyName, this.javaBean, value);
            }
            catch (Throwable err) {
                I18n msg = RepositoryI18n.errorSettingJavaBeanPropertyOnInstanceOfClass;
                throw new DnaConfigurationException(msg.text(new Object[]{this.beanPropertyName, this.javaBean.getClass(), err.getMessage()}), err);
            }
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassChooser<ComponentClass, ReturnType>
    implements ChooseClass<ComponentClass, ReturnType> {
        protected final Path pathOfComponentNode;
        protected final ReturnType returnObject;

        protected ClassChooser(Path pathOfComponentNode, ReturnType returnObject) {
            assert (pathOfComponentNode != null);
            assert (returnObject != null);
            this.pathOfComponentNode = pathOfComponentNode;
            this.returnObject = returnObject;
        }

        @Override
        public LoadedFrom<ReturnType> usingClass(String classname) {
            CheckArg.isNotEmpty((String)classname, (String)"classname");
            ((Graph.On)Configurator.this.configuration().set(DnaLexicon.CLASSNAME).to(classname)).on(this.pathOfComponentNode);
            return new LoadedFrom<ReturnType>(){

                @Override
                public ReturnType loadedFromClasspath() {
                    return ClassChooser.this.returnObject;
                }

                @Override
                public ReturnType loadedFrom(String ... classpath) {
                    CheckArg.isNotEmpty((Object[])classpath, (String)"classpath");
                    if (classpath.length == 1 && classpath[0] != null) {
                        ((Graph.On)Configurator.this.configuration().set(DnaLexicon.CLASSPATH).to(classpath[0])).on(ClassChooser.this.pathOfComponentNode);
                    } else {
                        Object[] remaining = new String[classpath.length - 1];
                        System.arraycopy(classpath, 1, remaining, 0, remaining.length);
                        ((Graph.On)Configurator.this.configuration().set(DnaLexicon.CLASSPATH).to((Object)classpath[0], remaining)).on(ClassChooser.this.pathOfComponentNode);
                    }
                    return ClassChooser.this.returnObject;
                }
            };
        }

        @Override
        public ReturnType usingClass(Class<? extends ComponentClass> clazz) {
            CheckArg.isNotNull(clazz, (String)"clazz");
            return this.usingClass(clazz.getName()).loadedFromClasspath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigurationSourceDetails<ReturnType>
    implements ConfigRepositoryDetails<ReturnType> {
        private final ReturnType returnObject;

        protected ConfigurationSourceDetails(ReturnType returnObject) {
            assert (returnObject != null);
            this.returnObject = returnObject;
        }

        @Override
        public ConfigRepositoryDetails<ReturnType> describedAs(String description) {
            Configurator.this.configurationSource = Configurator.this.configurationSource.with(description);
            return this;
        }

        @Override
        public PropertySetter<ConfigRepositoryDetails<ReturnType>> with(String propertyName) {
            return new BeanPropertySetter<ConfigRepositoryDetails<ReturnType>>(Configurator.this.configurationSource.getRepositorySource(), propertyName, this);
        }

        @Override
        public ConfigRepositoryDetails<ReturnType> under(String path) {
            CheckArg.isNotNull((Object)path, (String)"path");
            Path newPath = (Path)Configurator.this.getExecutionContext().getValueFactories().getPathFactory().create(path);
            Configurator.this.configurationSource = Configurator.this.configurationSource.with(newPath);
            return null;
        }

        @Override
        public ReturnType and() {
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigurationRepositoryClassChooser<ReturnType>
    implements ChooseClass<RepositorySource, ConfigRepositoryDetails<ReturnType>> {
        private final ReturnType returnObject;

        protected ConfigurationRepositoryClassChooser(ReturnType returnObject) {
            assert (returnObject != null);
            this.returnObject = returnObject;
        }

        @Override
        public LoadedFrom<ConfigRepositoryDetails<ReturnType>> usingClass(final String className) {
            return new LoadedFrom<ConfigRepositoryDetails<ReturnType>>(){

                @Override
                public ConfigRepositoryDetails loadedFrom(String ... classpath) {
                    ClassLoader classLoader = Configurator.this.getExecutionContext().getClassLoader(classpath);
                    Class<?> clazz = null;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException err) {
                        throw new DnaConfigurationException(RepositoryI18n.unableToLoadClassUsingClasspath.text(new Object[]{className, classpath}));
                    }
                    return ConfigurationRepositoryClassChooser.this.usingClass(clazz);
                }

                @Override
                public ConfigRepositoryDetails loadedFromClasspath() {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException err) {
                        throw new DnaConfigurationException(RepositoryI18n.unableToLoadClass.text(new Object[]{className}));
                    }
                    return ConfigurationRepositoryClassChooser.this.usingClass(clazz);
                }
            };
        }

        @Override
        public ConfigRepositoryDetails<ReturnType> usingClass(Class<? extends RepositorySource> repositorySource) {
            try {
                Configurator.this.configurationSource = new ConfigurationRepository(repositorySource.newInstance());
            }
            catch (InstantiationException err) {
                I18n msg = RepositoryI18n.errorCreatingInstanceOfClass;
                throw new DnaConfigurationException(msg.text(new Object[]{repositorySource.getName(), err.getLocalizedMessage()}), err);
            }
            catch (IllegalAccessException err) {
                I18n msg = RepositoryI18n.errorCreatingInstanceOfClass;
                throw new DnaConfigurationException(msg.text(new Object[]{repositorySource.getName(), err.getLocalizedMessage()}), err);
            }
            return new ConfigurationSourceDetails<ReturnType>(this.returnObject);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface And<ReturnType> {
        public ReturnType and();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LoadedFrom<ReturnType> {
        public ReturnType loadedFrom(String ... var1);

        public ReturnType loadedFromClasspath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetName<ReturnType> {
        public ReturnType named(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetDescription<ReturnType> {
        public ReturnType describedAs(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChooseClass<ComponentClassType, ReturnType> {
        public LoadedFrom<ReturnType> usingClass(String var1);

        public ReturnType usingClass(Class<? extends ComponentClassType> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySetter<ReturnType> {
        public ReturnType setTo(int var1);

        public ReturnType setTo(long var1);

        public ReturnType setTo(short var1);

        public ReturnType setTo(boolean var1);

        public ReturnType setTo(float var1);

        public ReturnType setTo(double var1);

        public ReturnType setTo(String var1);

        public ReturnType setTo(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetProperties<ReturnType> {
        public PropertySetter<ReturnType> with(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MimeTypeDetectorDetails<ReturnType>
    extends SetName<MimeTypeDetectorDetails<ReturnType>>,
    SetDescription<MimeTypeDetectorDetails<ReturnType>>,
    SetProperties<MimeTypeDetectorDetails<ReturnType>>,
    And<ReturnType> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PathExpressionOutput<ReturnType> {
        public SequencerDetails<ReturnType> andOutputtingTo(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SequencerDetails<ReturnType>
    extends SetName<SequencerDetails<ReturnType>>,
    SetDescription<SequencerDetails<ReturnType>>,
    And<ReturnType> {
        public PathExpressionOutput<ReturnType> sequencingFrom(String var1);

        public SequencerDetails<ReturnType> sequencingFrom(PathExpression var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConfigRepositoryDetails<ReturnType>
    extends SetDescription<ConfigRepositoryDetails<ReturnType>>,
    SetProperties<ConfigRepositoryDetails<ReturnType>>,
    And<ReturnType> {
        public ConfigRepositoryDetails<ReturnType> under(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepositoryDetails<ReturnType>
    extends SetName<RepositoryDetails<ReturnType>>,
    SetDescription<RepositoryDetails<ReturnType>>,
    SetProperties<RepositoryDetails<ReturnType>>,
    And<ReturnType> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Builder<ReturnType> {
        public ReturnType build() throws DnaConfigurationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MimeDetectorConfigurator<ReturnType> {
        public ChooseClass<MimeTypeDetector, MimeTypeDetectorDetails<ReturnType>> addMimeTypeDetector(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepositoryConfigurator<ReturnType> {
        public ChooseClass<RepositorySource, RepositoryDetails<ReturnType>> addRepository(String var1);

        public ReturnType addRepository(RepositorySource var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Initializer<ReturnType> {
        public ChooseClass<RepositorySource, ConfigRepositoryDetails<ReturnType>> withConfigurationRepository();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SequencerConfigurator<ReturnType> {
        public ChooseClass<Sequencer, SequencerDetails<ReturnType>> addSequencer(String var1);
    }
}

